/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpUtils {
    private static final String REGX_IP = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";

    public static Boolean judgeIpInRange(String clientIp, String[] ips) {
        if (ips != null && ips.length > 0) {
            for (String ip : ips) {
                if (clientIp.contains(":") && IpUtils.judgeIpV6InRange(clientIp, ip)) {
                    return true;
                }
                if (!clientIp.contains(".") || !IpUtils.judgeIpV4InRange(clientIp, ip)) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean judgeIpInRange(String clientIp, String ipStart, String ipEnd) {
        if (!(ipStart.matches(REGX_IP) && clientIp.matches(REGX_IP) && ipEnd.matches(REGX_IP))) {
            return true;
        }
        String[] sips = ipStart.split("\\.");
        String[] sipe = ipEnd.split("\\.");
        String[] sipt = clientIp.split("\\.");
        long ips = 0L;
        long ipe = 0L;
        long ipt = 0L;
        for (int i = 0; i < 4; ++i) {
            ips = ips << 8 | (long)Integer.parseInt(sips[i]);
            ipe = ipe << 8 | (long)Integer.parseInt(sipe[i]);
            ipt = ipt << 8 | (long)Integer.parseInt(sipt[i]);
        }
        if (ips > ipe) {
            long t = ips;
            ips = ipe;
            ipe = t;
        }
        return ips <= ipt && ipt <= ipe;
    }

    private static boolean judgeIpV6InRange(String clientIp, String ips) {
        try {
            String[] ipRange;
            if (ips.contains("/") && (ipRange = ips.split("/")).length == 2) {
                return IpUtils.checkIPV6Range(clientIp, ipRange);
            }
            if (clientIp.equals(ips)) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private static boolean judgeIpV4InRange(String clientIp, String ip) {
        String[] ipRange = ip.split("-");
        return ipRange.length > 1 ? IpUtils.judgeIpInRange(clientIp, ipRange[0], ipRange[1]) != false : clientIp.equals(ipRange[0]);
    }

    private static boolean checkIPV6Range(String clientIp, String[] ipRange) throws UnknownHostException {
        int mask;
        InetAddress ip = InetAddress.getByName(clientIp);
        InetAddress network = InetAddress.getByName(ipRange[0]);
        byte[] ipBytes = ip.getAddress();
        byte[] networkBytes = network.getAddress();
        int prefixLength = Integer.parseInt(ipRange[1]);
        int prefixBytes = prefixLength / 8;
        int prefixBits = prefixLength % 8;
        for (int i = 0; i < prefixBytes; ++i) {
            if (ipBytes[i] == networkBytes[i]) continue;
            return false;
        }
        return prefixBits <= 0 || (ipBytes[prefixBytes] & (mask = 255 << 8 - prefixBits)) == (networkBytes[prefixBytes] & mask);
    }
}

