/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Date;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MServiceUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.session.SessionInfo;

public class MLogUtils {
    private static final String BOS_LOGIN = "bos-login";
    private static final String BIZ_APP_ID = "83bfebc8000037ac";
    private static final String BIZ_OBJ_ID = "bos_user";
    private static final Log logger = LogFactory.getLog(MLogUtils.class);

    public static void addLog(Account currentCenter, String userid, String orgid, String modulName, String operationName, String resourceLocationModule, String resourceLocationOperation, LoginClientEnum clientEnum, String ip, String sessionId, SessionInfo si) {
        Lang oldLangage = LoginLangUtils.getLang();
        try {
            if (LoginUtils.isGuestUser(userid)) {
                return;
            }
            if ("0".equals(userid)) {
                return;
            }
            if (StringUtils.isEmpty(sessionId)) {
                sessionId = LoginUtils.getGuestSessionId(currentCenter.getAccountId(), currentCenter.getTenantId(), oldLangage, ip);
                si = SessionUtils.getGuestSessionData(Instance.getClusterName(), currentCenter.getTenantId(), currentCenter.getAccountId(), oldLangage);
            }
            MServiceUtils.invoke("ILogService", "addLog", sessionId, clientEnum, si, MLogUtils.wrapLogInfo(BIZ_APP_ID, BIZ_OBJ_ID, ResManager.loadKDString((String)modulName, (String)resourceLocationModule, (String)BOS_LOGIN, (Object[])new Object[0]), MLogUtils.getForceLogoutDesc(ResManager.loadKDString((String)operationName, (String)resourceLocationOperation, (String)BOS_LOGIN, (Object[])new Object[0])), StringUtils.isNotBlank(orgid) ? Long.valueOf(Long.parseLong(orgid)) : null, StringUtils.isNotBlank(userid) ? Long.valueOf(Long.parseLong(userid)) : null, clientEnum, ip, currentCenter));
        }
        catch (Exception e) {
            logger.error("addLog\u5f02\u5e38", (Throwable)e);
        }
        LoginLangUtils.setLang(oldLangage);
    }

    public static void addLog(Account currentCenter, String userid, String orgid, String modulName, String operationName, String resourceLocationModule, String resourceLocationOperation, LoginClientEnum clientEnum, String ip) {
        MLogUtils.addLog(currentCenter, userid, orgid, modulName, operationName, resourceLocationModule, resourceLocationOperation, clientEnum, ip, "", null);
    }

    private static AppLogInfo wrapLogInfo(String bizAppId, String bizObjId, String opName, String message, Long orgId, Long userId, LoginClientEnum clientEnum, String ip, Account currentCenter) {
        Lang lang = LoginLangUtils.getLang();
        String clientType = "";
        if (null != clientEnum && StringUtils.isNotEmpty(clientEnum.name())) {
            clientType = clientEnum.name().toLowerCase(Locale.ENGLISH);
        }
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(userId);
        logInfo.setOrgID(orgId);
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(bizObjId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(clientType);
        logInfo.setClientIP(ip);
        logInfo.setOpName(opName);
        logInfo.setOpDescription(message);
        logInfo.setAccountId(currentCenter.getAccountId());
        logInfo.setTenantId(currentCenter.getTenantId());
        logInfo.setClientName(clientType);
        logInfo.setLogType(1);
        logInfo.setLanguage(lang.name());
        return logInfo;
    }

    private static String getForceLogoutDesc(String operationName) {
        String str = ResManager.loadKDString((String)"\u8e22\u51fa\u7528\u6237\u6210\u529f", (String)"SessionUtils_3", (String)BOS_LOGIN, (Object[])new Object[0]);
        String result = "";
        if (StringUtils.isNotEmpty(operationName) && operationName.contains(str)) {
            result = RequestContext.get() != null ? SystemPropertyUtils.getProptyByTenant("force_logout_log_operation_description", RequestContext.get().getTenantId()) : SystemPropertyUtils.getProptyByTenant("force_logout_log_operation_description", null);
        }
        if (StringUtils.isEmpty(result)) {
            result = operationName;
        }
        return result;
    }
}

