/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.SmsService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.sms.SMSSender;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import org.apache.commons.lang.StringUtils;

public class MessageUtils {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(MessageUtils.class);

    @Deprecated
    public static boolean sendMessage(String phone, String message) {
        return MessageUtils.sendMessage(phone, message, null);
    }

    @Deprecated
    public static boolean sendMessage(String phone, String message, String signature) {
        SMSSender sender = null;
        String tenantId = RequestContext.get() != null ? RequestContext.get().getTenantId() : "";
        String senderString = SystemPropertyUtils.getProptyByTenant("login.sms.sender", tenantId);
        if (senderString != null) {
            sender = (SMSSender)BeanUtils.getBean(senderString);
        }
        if (sender == null) {
            sender = new KDSMSSender();
        }
        if (StringUtils.isNotEmpty((String)signature)) {
            return sender.sendMessage(phone, message, signature);
        }
        return sender.sendMessage(phone, message);
    }

    public static int getSMSTimeOut() {
        int timeout = 120;
        String configTimeout = System.getProperty("login.sms.timeout");
        if (configTimeout != null && kd.bos.util.StringUtils.isNumericString((String)configTimeout)) {
            timeout = Integer.parseInt(configTimeout);
        }
        return timeout;
    }

    public static int getSMSCodelength() {
        int codeLength = 6;
        String configLength = System.getProperty("login.sms.code.length");
        if (configLength != null && kd.bos.util.StringUtils.isNumericString((String)configLength)) {
            codeLength = Integer.parseInt(configLength);
        }
        return codeLength;
    }

    public static String getSMSContent(String code) {
        String returnValue = null;
        String content = System.getProperty("login.sms.content");
        if (StringUtils.isNotEmpty((String)content)) {
            returnValue = content.replace("<<smsCode>>", code);
        }
        if (StringUtils.isEmpty(returnValue)) {
            returnValue = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%s\uff0c\u6765\u81ea\u624b\u673a\u77ed\u4fe1\u767b\u5f55\uff0c5\u5206\u949f\u5185\u6709\u6548\u3002", (String)"MessageUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]), code);
        }
        return returnValue;
    }

    public static String getSignature(Account currentCenter) {
        return MessageUtils.parseSmsConfig(SmsService.getSmsConfig(currentCenter));
    }

    private static String parseSmsConfig(String smsConfig) {
        String signature = null;
        if (StringUtils.isBlank((String)smsConfig)) {
            return null;
        }
        try {
            Map smsConfigMap = (Map)JSONObject.parseObject((String)smsConfig, Map.class);
            String signatureMultiLang = smsConfigMap.get("signature").toString();
            Map signatureMap = (Map)JSONObject.parseObject((String)signatureMultiLang, Map.class);
            signature = signatureMap.get(LoginLangUtils.getLang().name()).toString();
        }
        catch (Exception e) {
            logger.error("ResetPasswordAction--parseSmsConfig error", (Throwable)e);
        }
        return signature;
    }

    public static boolean sendMessage(String phone, String code, String message, String signature, Lang lang) {
        SMSSender sender = null;
        String tenantId = RequestContext.get() != null ? RequestContext.get().getTenantId() : "";
        String senderString = SystemPropertyUtils.getProptyByTenant("login.sms.sender", tenantId);
        if (senderString != null && (sender = (SMSSender)BeanUtils.getBean(senderString)) != null) {
            if (StringUtils.isNotEmpty((String)signature)) {
                return sender.sendMessage(phone, message, signature);
            }
            return sender.sendMessage(phone, message);
        }
        sender = new KDSMSSender();
        if (RequestContext.get() != null && kd.bos.util.StringUtils.isNotEmpty((String)RequestContext.get().getTenantId()) && "false".equals(SystemPropertyUtils.getProptyByTenant("bos.svc.close.old.loginSms", RequestContext.get().getTenantId()))) {
            if (StringUtils.isNotEmpty((String)signature)) {
                return sender.sendMessage(phone, message, signature);
            }
            return sender.sendMessage(phone, message);
        }
        return sender.sendMessage(phone, code, signature, lang);
    }
}

