/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class ModeTypeUtils {
    private static final String ACCOUNTTYPEDESC = "accounttypedesc";
    private static final String TABWORD = "tabword";
    private static final String WELCOMEMSG = "welcomemsg";
    private static String[] defaultKeys = new String[]{"accounttypedesc", "tabword", "welcomemsg"};
    private static Map<String, Map<String, String>> galaxyDefaultValue = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> cosmicTeachDefaultValue = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> cosmicDefaultValue = new HashMap<String, Map<String, String>>();
    private static final String ZH_CN = "zh_CN";
    private static final String ZH_TW = "zh_TW";
    private static final String EN_US = "en_US";

    public static Map<String, Map<String, String>> getDefaultData(int modeType) {
        HashMap<String, Map<String, String>> defaultMap = new HashMap<String, Map<String, String>>(0);
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        if (oemEnv) {
            defaultMap.putAll(cosmicDefaultValue);
            return defaultMap;
        }
        switch (modeType) {
            case 2: 
            case 4: {
                defaultMap.putAll(galaxyDefaultValue);
                break;
            }
            case 3: {
                if (!ModeTypeUtils.isEducation()) break;
                defaultMap.putAll(cosmicTeachDefaultValue);
                break;
            }
        }
        return defaultMap;
    }

    public static void setSingleDefaultValue(int modeType, String key, Map<String, String> map) {
        switch (modeType) {
            case 2: {
                ModeTypeUtils.setSingleDefaultValue(galaxyDefaultValue.get(key), map);
                break;
            }
            case 4: {
                ModeTypeUtils.setSingleDefaultValue(galaxyDefaultValue.get(key), map);
                break;
            }
            case 3: {
                if (!ModeTypeUtils.isEducation()) break;
                ModeTypeUtils.setSingleDefaultValue(cosmicTeachDefaultValue.get(key), map);
                break;
            }
        }
    }

    private static void setSingleDefaultValue(Map<String, String> defaultData, Map<String, String> map) {
        if (defaultData != null) {
            map.clear();
            map.putAll(defaultData);
        }
    }

    public static void setDefaultValue(int modeType, Map<String, Object> returnMap) {
        switch (modeType) {
            case 2: {
                ModeTypeUtils.setDefaultValue(galaxyDefaultValue, returnMap);
                break;
            }
            case 4: {
                ModeTypeUtils.setDefaultValue(galaxyDefaultValue, returnMap);
                break;
            }
            case 3: {
                if (!ModeTypeUtils.isEducation()) break;
                ModeTypeUtils.setDefaultValue(cosmicTeachDefaultValue, returnMap);
                break;
            }
        }
    }

    private static void setDefaultValue(Map<String, Map<String, String>> defaultValue, Map<String, Object> returnMap) {
        for (String key : defaultKeys) {
            if (returnMap.containsKey(key)) continue;
            returnMap.put(key, defaultValue.get(key));
        }
    }

    public static boolean isEducation() {
        boolean flag = false;
        List productInfos = LicenseServiceHelper.getProductInfos();
        if (!CollectionUtils.isEmpty((Collection)productInfos)) {
            long a = productInfos.stream().filter(info -> "kingdee cloud 5.0 for education".equals(info.get("softwarename"))).count();
            flag = a > 0L;
        }
        return flag;
    }

    static {
        HashMap<String, String> accounttypedesc = new HashMap<String, String>();
        accounttypedesc.put(EN_US, "Galaxy Flagship Edition Account Login");
        galaxyDefaultValue.put(ACCOUNTTYPEDESC, accounttypedesc);
        HashMap<String, String> tabword = new HashMap<String, String>();
        tabword.put(EN_US, "Galaxy Flagship Edition");
        galaxyDefaultValue.put(TABWORD, tabword);
        HashMap<String, String> welcomemsg = new HashMap<String, String>();
        welcomemsg.put(EN_US, "Welcome to Galaxy Flagship Edition");
        galaxyDefaultValue.put(WELCOMEMSG, welcomemsg);
        HashMap<String, String> cosmicTeachAccounttypedesc = new HashMap<String, String>();
        cosmicTeachAccounttypedesc.put(EN_US, "");
        cosmicTeachDefaultValue.put(ACCOUNTTYPEDESC, cosmicTeachAccounttypedesc);
        HashMap<String, String> cosmicTeachTabword = new HashMap<String, String>();
        cosmicTeachTabword.put(EN_US, "");
        cosmicTeachDefaultValue.put(TABWORD, cosmicTeachTabword);
        HashMap<String, String> cosmicTeachWelcomemsg = new HashMap<String, String>();
        cosmicTeachWelcomemsg.put(EN_US, "Welcome to Galaxy Flagship Edition");
        cosmicTeachDefaultValue.put(WELCOMEMSG, cosmicTeachWelcomemsg);
        HashMap<String, String> cosmicAccounttypedesc = new HashMap<String, String>();
        cosmicAccounttypedesc.put(EN_US, "Kingdee Cloud Cosmic Account Login");
        cosmicDefaultValue.put(ACCOUNTTYPEDESC, cosmicAccounttypedesc);
        HashMap<String, String> cosmicTabword = new HashMap<String, String>();
        cosmicTabword.put(EN_US, "Kingdee Cloud Cosmic");
        cosmicDefaultValue.put(TABWORD, cosmicTabword);
        HashMap<String, String> cosmicWelcomemsg = new HashMap<String, String>();
        cosmicWelcomemsg.put(EN_US, "Welcome to Welcome to Kingdee Cloud Cosmic");
        cosmicDefaultValue.put(WELCOMEMSG, cosmicWelcomemsg);
    }
}

