/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.DefaultPwdUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.util.PasswordEncryptUtil;

public class PswStrategyUtils {
    public static final String SUCCESS = "success";

    public static Map<String, Object> isLocked(Account currentCenter, String userId) throws KDException {
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentCenter, Long.parseLong(userId));
        Map<String, Object> lockedMap = PswStrategyService.isLocked(currentCenter, passwordStrategy, Long.parseLong(userId));
        boolean isLocked = (Boolean)lockedMap.get("isLocked");
        if (isLocked) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{lockedMap.get("message")});
        }
        return lockedMap;
    }

    public static String verifyPSWStrategy(Account currentCenter, Long userId, String password) {
        String msg = "";
        if (PswStrategyUtils.checkDefaultPwd(currentCenter, password)) {
            msg = String.format(ResManager.loadKDString((String)"\u4e3a\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u8bf7\u5b8c\u6210\u8d26\u53f7\u9a8c\u8bc1\u5e76\u4fee\u6539\u521d\u59cb\u5bc6\u7801\u3002", (String)"LoginAction_16", (String)"bos-login", (Object[])new Object[0]), new Object[0]);
            return msg;
        }
        Map<String, Object> verifyPSWStrategyResult = PswStrategyService.verifyPSWStrategy(currentCenter, userId, password);
        if (null != verifyPSWStrategyResult && null != verifyPSWStrategyResult.get(SUCCESS) && !((Boolean)verifyPSWStrategyResult.get(SUCCESS)).booleanValue()) {
            msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u7b26\u5408\u6700\u65b0\u5bc6\u7801\u7b56\u7565\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u540e\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_26", (String)"bos-login", (Object[])new Object[0]), new Object[0]);
            return msg;
        }
        Boolean passExpired = PswStrategyService.isPassExpired(currentCenter, userId);
        if (passExpired.booleanValue()) {
            msg = String.format(ResManager.loadKDString((String)"\u5bc6\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u3002", (String)"LoginAction_14", (String)"bos-login", (Object[])new Object[0]), new Object[0]);
        }
        return msg;
    }

    public static String getUserDefaultPsw(String tenantId) {
        String defaultPwd = DefaultPwdUtils.getDefaultPwd(RequestContext.get().getAccountId() + "login_default_pwd");
        if (StringUtils.isNotEmpty(defaultPwd)) {
            return defaultPwd;
        }
        String defaultPsw = SystemPropertyUtils.getProptyByTenant("login_default_pwd", tenantId);
        defaultPsw = StringUtils.isNotEmpty(defaultPsw) ? Encrypters.decode((String)defaultPsw) : DefaultParameterService.getDefaultValueByKey("default_pwd");
        return defaultPsw;
    }

    public static String getEncryptedUserDefaultPsw(String tenantId) {
        String defaultPsw = PswStrategyUtils.getUserDefaultPsw(tenantId);
        String encryptDefPsw = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)defaultPsw);
        return encryptDefPsw;
    }

    private static boolean checkDefaultPwd(Account currentCenter, String password) {
        String defaultPwd = DefaultParameterService.getDefaultValueByKey("default_pwd");
        boolean defaultB = StringUtils.isNotEmpty(defaultPwd) && defaultPwd.equals(password);
        String mcDefaultPwd = PswStrategyUtils.getUserDefaultPsw(currentCenter.getTenantId());
        boolean defaultM = StringUtils.isNotEmpty(mcDefaultPwd) && mcDefaultPwd.equals(password);
        return defaultB || defaultM;
    }
}

