/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.SessionIdUtils;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.after.LoginAfterBase;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.thirdauth.app.tencent.WxqyhLoginAfter;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.collections4.MapUtils;

public class SessionUtils {
    private static final String FORGID = "forgid";
    private static final String FTRUENAME = "ftruename";
    private static final String FOPENID = "fopenid";
    private static final String USER_TYPE = "userType";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String SESSION_UTILS_0 = "SessionUtils_0";
    private static final String SESSION_UTILS_1 = "SessionUtils_1";
    private static final String BOS_LOGIN = "bos-login";
    private static final String LOGGER_NETWORK_MUTEX_RELS_FAIL = "releaseByReLogin#";
    private static final String SUCCESS = "success";
    private static Log logger = LogFactory.getLog(SessionUtils.class);

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, LoginClientEnum clientEnum) {
        return SessionUtils.createNewSession(request, response, currentCenter, lang, IP, mpUser, clientEnum, SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()));
    }

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, LoginClientEnum clientEnum, int timeOut) {
        return SessionUtils.createNewSession(request, response, currentCenter, lang, IP, mpUser, clientEnum, timeOut, true);
    }

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, LoginClientEnum clientEnum, int timeOut, boolean copyToClient, boolean needMutilClient) {
        SessionInfo si = new SessionInfo();
        si.setTenantId(currentCenter.getTenantId());
        si.setOrgId(mpUser.get(FORGID));
        si.setUserId(mpUser.get("fid"));
        si.setUserName(mpUser.get(FTRUENAME));
        si.setUserOpenId(mpUser.get(FOPENID));
        si.setUserType(mpUser.get(USER_TYPE));
        si.setLoginIP(IP);
        si.setLanguage(lang.toString());
        si.setUid(mpUser.get("fuid"));
        if (mpUser.get("sessionType") != null) {
            si.setSessionType(mpUser.get("sessionType"));
        } else {
            si.setSessionType("1");
        }
        if (LoginClientEnum.WEB.equals((Object)clientEnum) && AgentUtil.isMobile(request)) {
            clientEnum = LoginClientEnum.MOBILE;
        }
        String type = SessionUtils.getClientString(clientEnum);
        si.setClient(type);
        SessionUtils.setApiClientContext(si);
        if (mpUser.get("ssoParmas") != null) {
            si.setSsoPramas(mpUser.get("ssoParmas"));
        }
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        si.setLoginTime(df.format(new Date()));
        String bizPartnerId = mpUser.get("fbizpartnerid");
        si = SessionUtils.getSessionInfo(currentCenter, si, bizPartnerId);
        logger.info("onlineUserInfo===>" + type);
        String sessionId = SessionUtils.getLastSessionId(request, response, clientEnum, si, timeOut, copyToClient);
        boolean typeFlag = LoginClientEnum.WEB.getDesc().equals(type) || LoginClientEnum.MOBILE.getDesc().equals(type);
        boolean noGuestFlag = mpUser.get("fid") != null && !"0".equals(mpUser.get("fid")) && !"-1".equals(mpUser.get("fid"));
        SessionUtils.setOnlineUser(typeFlag, noGuestFlag, sessionId, type, timeOut);
        return sessionId;
    }

    private static void setOnlineUser(boolean typeFlag, boolean noGuestFlag, String sessionId, String type, int timeOut) {
        if (typeFlag && noGuestFlag) {
            try {
                OnlineUserUtil.login(sessionId, type, timeOut);
            }
            catch (Exception e) {
                logger.error("onlineUser====>" + e.getMessage());
            }
        }
    }

    private static SessionInfo getSessionInfo(Account currentCenter, SessionInfo si, String bizPartnerId) {
        SessionInfo sessionInfo = si;
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object enableSwitchBizpartner = systemParamService.loadPublicParameterFromCache("enable_switch_bizpartner");
            if (enableSwitchBizpartner == null || !Boolean.parseBoolean(enableSwitchBizpartner.toString())) {
                return sessionInfo;
            }
            List bizPartnerIdList = UserServiceHelper.getBizPartnerByUserId((long)Long.parseLong(si.getUserId()));
            if (bizPartnerIdList != null && bizPartnerIdList.size() > 0 && (Long)bizPartnerIdList.get(0) != 0L) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)bizPartnerId) && !bizPartnerId.equals("0")) {
                    if (bizPartnerIdList.contains(Long.parseLong(bizPartnerId))) {
                        sessionInfo.setBizPartnerId(bizPartnerId);
                    } else {
                        sessionInfo.setBizPartnerId(((Long)bizPartnerIdList.get(0)).toString());
                    }
                } else {
                    sessionInfo.setBizPartnerId(((Long)bizPartnerIdList.get(0)).toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("getSessionInfo#" + e);
        }
        return sessionInfo;
    }

    public static void setApiClientContext(SessionInfo si) {
        ApiContext context;
        if ((LoginClientEnum.API.getDesc().equals(si.getClient()) || LoginClientEnum.WEBSERVICE.getDesc().equals(si.getClient())) && (context = ApiContext.get()) != null) {
            si.setApi3rdAppId(StringUtils.getStringValue(context.getAppId()));
            si.setApi3rdAppNum(context.getAppNum());
        }
    }

    private static String getLastSessionId(HttpServletRequest request, HttpServletResponse response, LoginClientEnum clientEnum, SessionInfo si, int timeOut, boolean copyToClient, boolean needMutilClient) {
        String sessionString = response == null ? SessionManager.newSession((SessionInfo)si, (int)timeOut) : SessionManager.newSession((HttpServletRequest)request, (HttpServletResponse)response, (SessionInfo)si, (boolean)copyToClient);
        Account currentCenter = LoginAccountFactory.createInstanceBySession(si, Optional.empty()).getAccount();
        SessionParams params = new SessionParams();
        params.setClientEnum(clientEnum);
        params.setIP(si.getLoginIP());
        LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "login"), sessionString, si);
        String cacheKey = SessionUtils.getCachkeyByClient(si.getUserId(), si.getTenantId(), si.getAccountId());
        boolean isNoNeed = SessionUtils.getIsNoNeed(si.getTenantId());
        if (LoginClientEnum.API == clientEnum || LoginClientEnum.WEBSERVICE == clientEnum) {
            isNoNeed = true;
        }
        if (!isNoNeed) {
            SessionUtils.noNeedMoreLogin(si, clientEnum, cacheKey, params);
            SessionUtils.releaseByReLogin(sessionString, si, clientEnum);
        }
        SessionUtils.saveCacheData(sessionString, cacheKey, clientEnum.toString(), timeOut);
        SessionUtils.handleAfterLogin(request, si, sessionString);
        return sessionString;
    }

    public static boolean isMultiClientUserId(String tenantId, String userId) {
        String specailUserId = SystemPropertyUtils.getProptyByTenant("allow_multiclient_user_id", tenantId);
        if (StringUtils.isNotEmpty(specailUserId) && specailUserId.equals(userId)) {
            return true;
        }
        return "2012251852669732864".equals(userId);
    }

    private static boolean getMultiLoginIp(Account currentCenter) {
        Map<String, Object> commonParameters = ConfigureationService.getCommonParameters(currentCenter);
        Object multiLoginIp = commonParameters.get("multi_login_ip");
        if (null == multiLoginIp) {
            return false;
        }
        if (multiLoginIp instanceof Boolean) {
            return (Boolean)multiLoginIp;
        }
        return false;
    }

    private static void handleAfterLogin(HttpServletRequest request, SessionInfo si, String sessionString) {
        si.setGloableSessionId(sessionString);
        String loginAfterClasses = SystemPropertyUtils.getProptyByTenant("login.after.handle.classes", RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (kd.bos.util.StringUtils.isNotEmpty((String)loginAfterClasses)) {
            String[] classes;
            for (String loginClass : classes = loginAfterClasses.split(",")) {
                try {
                    LoginAfterBase loginHandler = (LoginAfterBase)BeanUtils.getBean(loginClass.trim());
                    loginHandler.handling(request, si);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    try {
                        SessionManager.removeSession((String)sessionString);
                    }
                    catch (Exception ex) {
                        logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                    }
                    throw e;
                }
            }
        }
        WxqyhLoginAfter wxqyhLoginAfter = new WxqyhLoginAfter();
        ((LoginAfterBase)wxqyhLoginAfter).handling(request, si);
    }

    public static boolean getIsNoNeed(String tenantId) {
        boolean isNONeed = false;
        try {
            String needString = System.getProperty(tenantId + "_" + "login.session.terminalLimit");
            if (kd.bos.util.StringUtils.isEmpty((String)needString)) {
                needString = System.getProperty("login.session.terminalLimit");
            }
            isNONeed = StringUtils.getBooleanValue(needString);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return isNONeed;
    }

    public static String getSessionKeyType() {
        return "";
    }

    public static String getCachkeyByClient(String session, String tenantId, String accountId, LoginClientEnum clientEnum) {
        String sessionId = null;
        if (clientEnum != null && session != null) {
            sessionId = tenantId + accountId + "_" + session + "_" + (Object)((Object)clientEnum);
        }
        return sessionId;
    }

    public static String getCachkeyByClient(String session, String tenantId, String accountId) {
        String sessionId = null;
        if (session != null) {
            sessionId = tenantId + accountId + "_" + session;
        }
        return sessionId;
    }

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, Map<String, String> appLoginInfo, LoginClientEnum clientEnum) {
        return SessionUtils.createNewSession(request, response, currentCenter, lang, IP, mpUser, appLoginInfo, clientEnum, SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()));
    }

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, Map<String, String> appLoginInfo, LoginClientEnum clientEnum, int timeOut) {
        SessionInfo si = new SessionInfo();
        si.setTenantId(currentCenter.getTenantId());
        si.setOrgId(mpUser.get(FORGID));
        si.setUserId(mpUser.get("fid"));
        si.setUserName(mpUser.get(FTRUENAME));
        si.setUserOpenId(mpUser.get(FOPENID));
        si.setUserType(mpUser.get(USER_TYPE));
        si.setLoginIP(IP);
        si.setLanguage(lang.toString());
        si.setClient(SessionUtils.getClientString(clientEnum));
        si.setUid(mpUser.get("fuid"));
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        si.setLoginTime(df.format(new Date()));
        si.setYzjAppId(appLoginInfo.get("yzjAppId"));
        si.setYzjAppTicket(appLoginInfo.get("yzjAppTicket"));
        SessionUtils.setApiClientContext(si);
        String type = SessionUtils.getClientString(clientEnum);
        si.setClient(type);
        String bizPartnerId = mpUser.get("fbizpartnerid");
        si = SessionUtils.getSessionInfo(currentCenter, si, bizPartnerId);
        String sessionId = SessionUtils.getLastSessionId(request, response, clientEnum, si, timeOut, true);
        boolean typeFlag = LoginClientEnum.WEB.getDesc().equals(type) || LoginClientEnum.MOBILE.getDesc().equals(type);
        boolean noGuestFlag = mpUser.get("fid") != null && !"0".equals(mpUser.get("fid")) && !"-1".equals(mpUser.get("fid"));
        SessionUtils.setOnlineUser(typeFlag, noGuestFlag, sessionId, type, timeOut);
        return sessionId;
    }

    public static boolean verifyCookieSession(HttpServletRequest request, String globalSessionId) {
        if (kd.bos.util.StringUtils.isEmpty((String)globalSessionId)) {
            return false;
        }
        String reqTenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        if (!kd.bos.util.StringUtils.isEmpty((String)reqTenantNo)) {
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
            String sessionTenantId = sessionDAO.getAttribute("tenantId");
            return reqTenantNo.equalsIgnoreCase(sessionTenantId);
        }
        return true;
    }

    public static String getClientString(LoginClientEnum clientEnum) {
        return LoginClientEnum.getClientDescForLevel1(clientEnum);
    }

    public static String[] getGlobalSessionByUserId(String userId, String tenantId, String accountId, LoginClientEnum clientEnum) {
        String cacheKey = SessionUtils.getCachkeyByClient(userId, tenantId, accountId, clientEnum);
        String sessionId = CacheLoginData.getAttribute((String)SessionUtils.getSessionKeyType(), (String)cacheKey);
        return new String[]{sessionId};
    }

    public static void setLoginExitMessageBySessionId(String sessionId, String notifyMessage) {
        SessionUtils.setLoginExitMessageBySessionId(sessionId, notifyMessage, SessionIdUtils.getTimeout((String)sessionId));
    }

    public static void setLoginExitMessageBySessionId(String sessionId, String notifyMessage, int timeOut) {
        CacheLoginData.setAttribute((String)"", (String)LoginUtils.getExistsCachkey(sessionId), (String)notifyMessage, (int)timeOut);
    }

    public static String getLoginExitMessageBySessionId(String sessionId) {
        return CacheLoginData.getAttribute((String)"", (String)LoginUtils.getExistsCachkey(sessionId));
    }

    public static String getLoginExitMessageBySessionId(String sessionId, String type) {
        return CacheLoginData.getAttribute((String)type, (String)LoginUtils.getExistsCachkey(sessionId));
    }

    public static String createNewSession4WS(Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, LoginClientEnum clientEnum, int timeOut) {
        SessionInfo si = new SessionInfo();
        si.setTenantId(currentCenter.getTenantId());
        si.setOrgId(mpUser.get(FORGID));
        si.setUserId(mpUser.get("fid"));
        si.setUserName(mpUser.get(FTRUENAME));
        si.setUserOpenId(mpUser.get(FOPENID));
        si.setUserType(mpUser.get(USER_TYPE));
        si.setLoginIP(IP);
        si.setLanguage(lang.toString());
        si.setUid(mpUser.get("fuid"));
        si.setClient(SessionUtils.getClientString(clientEnum));
        SessionUtils.setApiClientContext(si);
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        si.setLoginTime(df.format(new Date()));
        si.setAccCompany(mpUser.get("accCompanyId"));
        String bizPartnerId = mpUser.get("fbizpartnerid");
        si = SessionUtils.getSessionInfo(currentCenter, si, bizPartnerId);
        return SessionUtils.getLastSessionId(clientEnum, si, timeOut);
    }

    private static String getLastSessionId(LoginClientEnum clientEnum, SessionInfo si, int timeOut) {
        String sessionString = SessionManager.newSession((SessionInfo)si, (int)timeOut);
        Account currentCenter = LoginAccountFactory.createInstanceBySession(si, Optional.empty()).getAccount();
        SessionParams params = new SessionParams();
        params.setClientEnum(clientEnum);
        params.setIP(si.getLoginIP());
        LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "login"), sessionString, si);
        String cacheKey = SessionUtils.getCachkeyByClient(si.getUserId(), si.getTenantId(), si.getAccountId());
        boolean isNoNeed = SessionUtils.getIsNoNeed(si.getTenantId());
        if (LoginClientEnum.API == clientEnum || LoginClientEnum.WEBSERVICE == clientEnum || LoginClientEnum.NEWAPI == clientEnum) {
            isNoNeed = true;
        }
        if (isNoNeed) {
            return sessionString;
        }
        SessionUtils.noNeedMoreLogin(si, clientEnum, cacheKey, params);
        SessionUtils.releaseByReLogin(sessionString, si, clientEnum);
        SessionUtils.saveCacheData(sessionString, cacheKey, clientEnum.toString(), timeOut);
        return sessionString;
    }

    private static void noNeedMoreLogin(SessionInfo si, LoginClientEnum clientEnum, String cacheKey, SessionParams params) {
        Account currentCenter = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        String[] list = CacheLoginUtils.getList((String)cacheKey);
        for (int i = list.length - 1; i >= 0; --i) {
            String userInfo = list[i];
            try {
                SessionDAO sessionDAO;
                Map cast = JSONUtils.cast(userInfo, Map.class);
                String sessionId = (String)cast.get("sessionId");
                String clientType = (String)cast.get("clientType");
                if (sessionId == null || !clientEnum.toString().equals(clientType) || SessionUtils.excludeRemoveSession(sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId), si)) continue;
                SessionManager.removeSession((String)sessionId);
                LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "remove"), sessionId, si);
                boolean multiLoginIp = SessionUtils.getMultiLoginIp(currentCenter);
                String notifyMessage = multiLoginIp ? String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%1s\u5728\u8bbe\u5907%2s\u767b\u5f55\uff0c\u60a8\u88ab\u8feb\u4e0b\u7ebf\u3002\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u53ef\u80fd\u6cc4\u9732\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SessionUtils_4", (String)BOS_LOGIN, (Object[])new Object[0]), DateUtils.getDateTime(), si.getLoginIP()) : String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%s\u5728\u5176\u4ed6\u673a\u5668\u767b\u5f55\uff0c\u60a8\u88ab\u8feb\u4e0b\u7ebf\u3002\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u53ef\u80fd\u6cc4\u9732\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SessionUtils_7", (String)BOS_LOGIN, (Object[])new Object[0]), DateUtils.getDateTime());
                SessionUtils.setLoginExitMessageBySessionId(sessionId, notifyMessage);
                CacheLoginUtils.removeListObject((String)cacheKey, (int)i);
                continue;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        SessionUtils.releaseByReLogin(si, params);
    }

    private static void releaseByReLogin(SessionInfo si, SessionParams params) {
        try {
            RequestContextCreator.createForOnlySesssion((String)params.getSessionId(), (SessionInfo)si, (String)params.getClientEnum().toString());
            DispatchServiceHelper.invokeBOSService("DataMutexService", "releaseByReLogin", new Object[0]);
        }
        catch (Exception e) {
            logger.error(LOGGER_NETWORK_MUTEX_RELS_FAIL, (Throwable)e);
        }
        catch (Error er) {
            logger.error(LOGGER_NETWORK_MUTEX_RELS_FAIL, (Throwable)er);
        }
    }

    private static void releaseByReLogin(String sessionString, SessionInfo si, LoginClientEnum clientEnum) {
        try {
            RequestContextCreator.createForOnlySesssion((String)sessionString, (SessionInfo)si, (String)clientEnum.toString());
            DispatchServiceHelper.invokeBOSService("DataMutexService", "releaseByReLogin", new Object[0]);
        }
        catch (Exception e) {
            logger.error(LOGGER_NETWORK_MUTEX_RELS_FAIL, (Throwable)e);
        }
        catch (Error er) {
            logger.error(LOGGER_NETWORK_MUTEX_RELS_FAIL, (Throwable)er);
        }
    }

    private static void saveCacheData(String sessionId, String cacheKey, String clientType, int timeOut) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("sessionId", sessionId);
            map.put("clientType", clientType);
            CacheLoginUtils.addList((String)cacheKey, (String[])new String[]{JSONUtils.toString(map)}, (int)timeOut, (int)100);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void createDefaultRequestContext(HttpServletRequest request, String accountId, String loginType) {
        SessionInfo si = SessionUtils.getGuestSessionData(request, accountId, loginType);
        RequestContextCreator.create((HttpServletRequest)request, (String)"", (SessionInfo)si);
    }

    private static SessionInfo getGuestSessionData(HttpServletRequest request, String accountId, String loginType) {
        SessionInfo si = new SessionInfo();
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        si.setTenantId(tenantId);
        si.setSandboxId("");
        si.setUserId("-1");
        si.setUserName("Guest");
        si.setUserOpenId("");
        si.setUserType("1");
        si.setYzjAppId("");
        si.setYzjAppTicket("");
        si.setLanguage(LoginLangUtils.getLoginLanguage(request).toString());
        si.setUid("-1");
        si.setAccountId(accountId);
        si.setClient(loginType);
        si.setLoginOrg("0");
        return si;
    }

    public static Map<String, Object> checkSessionLimit(HttpServletRequest request, Account currentCenter, String userId, Lang lang) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS, true);
        try {
            if (!SessionUtils.getIsNoNeed(currentCenter.getTenantId())) {
                String globalSessionId = LoginUtils.getKDCookieValue(request);
                Map<String, String> userInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, userId, lang.name());
                String cacheKey = SessionUtils.getCachkeyByClient(userInfo.get("fid"), currentCenter.getTenantId(), currentCenter.getAccountId());
                String[] list = CacheLoginUtils.getList((String)cacheKey);
                String sessionId = null;
                for (String s : list) {
                    Map cast = JSONUtils.cast(s, Map.class);
                    if (!LoginClientEnum.WEB.toString().equals(cast.get("clientType"))) continue;
                    sessionId = (String)cast.get("sessionId");
                    break;
                }
                if (kd.bos.util.StringUtils.isNotEmpty(sessionId)) {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)globalSessionId) && globalSessionId.equals(sessionId)) {
                        result.put(SUCCESS, true);
                    } else {
                        result.put(SUCCESS, false);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("checkSessionLimit\u5f02\u5e38\uff1a" + e);
        }
        result.put("userId", userId);
        return result;
    }

    public static void getGuestSessionRequestContext(HttpServletRequest request, HttpServletResponse response, boolean isAPI) {
        SessionInfo si = SessionUtils.getGuestSessionData(request, Instance.getClusterName());
        String globalSessionId = LoginUtils.getGuestGloalSessionId(request, response, isAPI);
        RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
    }

    private static SessionInfo getGuestSessionData(HttpServletRequest request, String sandboxId) {
        SessionInfo si = new SessionInfo();
        si.setSandboxId(sandboxId);
        si.setUserId("-1");
        si.setUserName("Guest");
        si.setUserOpenId("");
        si.setUserType("1");
        si.setYzjAppId("");
        si.setYzjAppTicket("");
        si.setLanguage(LoginLangUtils.getLoginLanguage(request).toString());
        si.setUid("-1");
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        si.setAccountId(currentCenter.getAccountId());
        si.setTenantId(loginAccount.getTenantId());
        String loginType = request.getParameter("logintype");
        String lType = LoginClientEnum.WEB.getDesc();
        if ("mobile".equalsIgnoreCase(loginType)) {
            lType = LoginClientEnum.MOBILE.getDesc();
        }
        si.setClient(lType);
        si.setLoginOrg("0");
        return si;
    }

    public static SessionInfo getGuestSessionData(String sandboxId, String tenantId, String accountId, Lang lang) {
        SessionInfo si = new SessionInfo();
        si.setTenantId(tenantId);
        si.setSandboxId(sandboxId);
        si.setUserId("-1");
        si.setUserName("Guest");
        si.setUserOpenId("");
        si.setUserType("1");
        si.setYzjAppId("");
        si.setYzjAppTicket("");
        si.setLanguage(lang.toString());
        si.setUid("-1");
        Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
        si.setAccountId(currentCenter.getAccountId());
        String lType = LoginClientEnum.WEB.getDesc();
        si.setClient(lType);
        si.setLoginOrg("0");
        return si;
    }

    public static Map<String, String> getSessionInfo(SessionDAO sessionDAO, String globalSessionId) {
        sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", USER_TYPE, "yzjAppId", "yzjAppTicket", "accountId", "uid", "loginOrg", "client", "api3rdAppId", "api3rdAppNum"});
        return sessionInfo;
    }

    public static SessionInfo createSessionInfo(Account currentCenter, Lang lang, Map<String, String> userInfo, String ip, LoginClientEnum clientEnum) {
        SessionInfo si = new SessionInfo();
        si.setTenantId(currentCenter.getTenantId());
        si.setOrgId(userInfo.get(FORGID));
        si.setUserId(userInfo.get("fid"));
        si.setUserName(userInfo.get(FTRUENAME));
        si.setUserOpenId(userInfo.get(FOPENID));
        si.setUserType(userInfo.get(USER_TYPE));
        si.setLoginIP(ip);
        si.setLanguage(lang.toString());
        si.setUid(userInfo.get("fuid"));
        si.setClient(SessionUtils.getClientString(clientEnum));
        SessionUtils.setApiClientContext(si);
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        si.setLoginTime(df.format(new Date()));
        si.setAccCompany(userInfo.get("accCompanyId"));
        String bizPartnerId = userInfo.get("fbizpartnerid");
        si = SessionUtils.getSessionInfo(currentCenter, si, bizPartnerId);
        return si;
    }

    public static String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, Lang lang, String IP, Map<String, String> mpUser, LoginClientEnum clientEnum, int timeOut, boolean copyToClient) {
        return SessionUtils.createNewSession(request, response, currentCenter, lang, IP, mpUser, clientEnum, timeOut, copyToClient, false);
    }

    public static String getLastSessionId(HttpServletRequest request, HttpServletResponse response, LoginClientEnum clientEnum, SessionInfo si, int timeOut, boolean copyToClient) {
        return SessionUtils.getLastSessionId(request, response, clientEnum, si, timeOut, copyToClient, false);
    }

    public static SessionInfo getSessinInfoBySessionId(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map sessionMap = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", USER_TYPE, "yzjAppId", "yzjAppTicket", "kdCsrfToken", "accountId", "uid", "loginIP", "loginOrg", "client", "accCompanyId", "api3rdAppId", "api3rdAppNum", "bizPartnerId"});
        SessionInfo sessionInfo = new SessionInfo();
        if (MapUtils.isEmpty((Map)sessionMap)) {
            return sessionInfo;
        }
        sessionInfo.setTenantId((String)sessionMap.get("tenantId"));
        sessionInfo.setSandboxId((String)sessionMap.get("sandboxId"));
        sessionInfo.setOrgId((String)sessionMap.get("orgId"));
        sessionInfo.setUserId((String)sessionMap.get("userId"));
        sessionInfo.setUserName((String)sessionMap.get("userName"));
        sessionInfo.setUserOpenId((String)sessionMap.get("userOpenId"));
        sessionInfo.setUserType((String)sessionMap.get(USER_TYPE));
        sessionInfo.setYzjAppId((String)sessionMap.get("yzjAppId"));
        sessionInfo.setYzjAppTicket((String)sessionMap.get("yzjAppTicket"));
        sessionInfo.setLanguage((String)sessionMap.get("language"));
        sessionInfo.setUid((String)sessionMap.get("uid"));
        sessionInfo.setAccCompany((String)sessionMap.get("accCompanyId"));
        sessionInfo.setAccountId((String)sessionMap.get("accountId"));
        String client = (String)sessionMap.get("client");
        sessionInfo.setClient(client);
        if ("api".equalsIgnoreCase(client)) {
            sessionInfo.setApi3rdAppId((String)sessionMap.get("api3rdAppId"));
            sessionInfo.setApi3rdAppNum((String)sessionMap.get("api3rdAppNum"));
        }
        sessionInfo.setLoginOrg((String)sessionMap.get("loginOrg"));
        sessionInfo.setBizPartnerId((String)sessionMap.get("bizPartnerId"));
        sessionInfo.setKdCsrfToken((String)sessionMap.get("kdCsrfToken"));
        sessionInfo.setLoginIP((String)sessionMap.get("loginIP"));
        return sessionInfo;
    }

    private static boolean excludeRemoveSession(SessionDAO sessionDAO, SessionInfo si) {
        String userId = sessionDAO.getAttribute("userId");
        if ("-1".equals(userId) || "0".equals(userId)) {
            return true;
        }
        String sessionType = sessionDAO.getAttribute("sessionType");
        return "2".equals(sessionType);
    }
}

