/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.impl.SelfCreateAuth;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.login.utils.account.LoginAccountFactory;

public class StrategeUtils {
    private static final String ACCOUNT_ID = "accountId";
    public static int MAX_ERROR_TIMES = 3;
    private static Log logger = LogFactory.getLog(StrategeUtils.class);

    @Deprecated
    public static boolean isReachMaxTimes(String mobile, Account currentCenter) {
        boolean returnValue = false;
        int vercodectrl = PswStrategyService.getVercodectrl(currentCenter, Long.parseLong(mobile));
        int times = StrategeUtils.getPasswordErrorTimes(mobile, currentCenter.getAccountId());
        if (vercodectrl != 0 && times >= vercodectrl) {
            returnValue = true;
        }
        return returnValue;
    }

    public static int getPasswordErrorTimes(String mobile, HttpServletRequest request) {
        int times = 0;
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        if (currentCenter != null) {
            times = StrategeUtils.getPasswordErrorTimes(mobile, currentCenter.getAccountId());
        }
        return times;
    }

    public static int getPasswordErrorTimes(String mobile, String accountId) {
        String timeString;
        int times = 0;
        if (StringUtils.isNotEmpty(mobile) && StringUtils.isNotEmpty(accountId) && StringUtils.isNotEmpty(timeString = CacheLoginData.getAttribute((String)StrategeUtils.getType4PasswordErr(), (String)(mobile + accountId))) && kd.bos.util.StringUtils.isNumeric((String)timeString)) {
            times = Integer.parseInt(timeString);
        }
        return times;
    }

    private static String getType4PasswordErr() {
        return "errorPass";
    }

    public static void setPasswordErrorTimes(String mobile, HttpServletRequest request, int times) {
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        if (currentCenter != null) {
            StrategeUtils.setPasswordErrorTimes(mobile, currentCenter.getAccountId(), times);
        }
    }

    public static void setPasswordErrorTimes(String mobile, String accountId, int times) {
        if (StringUtils.isNotEmpty(mobile) && StringUtils.isNotEmpty(accountId)) {
            CacheLoginData.setAttribute((String)StrategeUtils.getType4PasswordErr(), (String)(mobile + accountId), (String)String.valueOf(times), (int)LoginUtils.getSecondsNextDay());
        }
    }

    public static void clearPasswordErrorTimes(String mobile, String accountId) {
        if (StringUtils.isNotEmpty(mobile) && StringUtils.isNotEmpty(accountId)) {
            CacheLoginData.setAttribute((String)StrategeUtils.getType4PasswordErr(), (String)(mobile + accountId), (String)String.valueOf(0), (int)0);
        }
    }

    public static void addOne4PasswordErrorTimes(String userName, Account currentCenter) {
        int times = StrategeUtils.getPasswordErrorTimes(userName, currentCenter.getAccountId());
        StrategeUtils.setPasswordErrorTimes(userName, currentCenter.getAccountId(), ++times);
    }

    public static boolean isLocked(Map<String, Object> map) {
        boolean isLocked = false;
        if (map != null && map.get("isLocked") != null) {
            try {
                isLocked = (Boolean)map.get("isLocked");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return isLocked;
    }

    public static boolean isNeedDisplayVerifyCode(String userName, Account currentCenter) {
        boolean isNeed = false;
        int vercodectrl = 0;
        int times = StrategeUtils.getPasswordErrorTimes(userName, currentCenter.getAccountId());
        vercodectrl = PswStrategyService.getVercodectrl(currentCenter, Long.parseLong(userName));
        if (vercodectrl != 0 && times != 0 && times >= vercodectrl) {
            isNeed = true;
        }
        return isNeed;
    }

    public static void clearPasswordErrorTimes(String mobile, Account currentCenter) {
        if (StringUtils.isNotEmpty(mobile) && StringUtils.isNotEmpty(currentCenter.getAccountId())) {
            CacheLoginData.setAttribute((String)StrategeUtils.getType4PasswordErr(), (String)(mobile + currentCenter.getAccountId()), (String)"0");
        }
    }

    public static Map<String, Object> getUserId(HttpServletRequest servletRequest, String mobile, Account currentCenter) {
        Map<String, String> erpUserInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String userId = null;
        String deptId = null;
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        boolean isMobile = "1".equals(servletRequest.getParameter("loginType"));
        if (isMobile || ValidationUtils.isPhone(mobile) || SelfCreateAuth.getSpecialUser().equalsIgnoreCase(mobile)) {
            erpUserInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, mobile, lang.name());
            userId = erpUserInfo.get("fid");
            logger.info("\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u7528\u6237\u7684userId\u4e3a:" + userId);
            deptId = erpUserInfo.get("forgid");
            map.put("fpswstrategyid", erpUserInfo.get("fpswstrategyid"));
            map.put("fisactived", erpUserInfo.get("fisactived"));
        }
        if (!isMobile) {
            if (userId == null && ValidationUtils.isEmail(mobile)) {
                erpUserInfo = LoginUserService.getErpUserInfoByEmail(currentCenter, mobile, lang.name());
                userId = erpUserInfo.get("fid");
                logger.info("\u6839\u636e\u90ae\u7bb1\u83b7\u53d6\u7528\u6237\u7684userId\u4e3a:" + userId);
                deptId = erpUserInfo.get("forgid");
                map.put("fpswstrategyid", erpUserInfo.get("fpswstrategyid"));
                map.put("fisactived", erpUserInfo.get("fisactived"));
            }
            if (userId == null && StringUtils.isNotEmpty(mobile)) {
                erpUserInfo = LoginUserService.getErpUserInfoByUserName(currentCenter, mobile, lang.name());
                userId = erpUserInfo.get("fid");
                logger.info("\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u7684userId\u4e3a:" + userId);
                deptId = erpUserInfo.get("forgid");
                map.put("fpswstrategyid", erpUserInfo.get("fpswstrategyid"));
                map.put("fisactived", erpUserInfo.get("fisactived"));
            }
        }
        map.put("userId", userId);
        map.put("currentCenter", currentCenter);
        map.put("deptId", deptId);
        return map;
    }

    public static Map<String, Object> getUserId(HttpServletRequest servletRequest, String mobile) {
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        return StrategeUtils.getUserId(servletRequest, mobile, currentCenter);
    }

    @Deprecated
    private static String getDefaultTenant(String headerTenantId) {
        return headerTenantId;
    }

    public static boolean checkAPPIdAndSecretErrorTimesIsLock(String accountId, String appId) {
        int times;
        if ("KDPrintClient".equals(appId)) {
            return false;
        }
        boolean isLock = false;
        if (StringUtils.isNotEmpty(accountId) && StringUtils.isNotEmpty(appId) && (times = StrategeUtils.getCheckAPPIdAndSecretErrorTimes(accountId, appId)) >= 3) {
            isLock = true;
        }
        return isLock;
    }

    public static void setCheckAPPIdAndSecretErrorTimesLogic(String accountId, String appId) {
        int times = StrategeUtils.getCheckAPPIdAndSecretErrorTimes(accountId, appId);
        if (times < 2) {
            StrategeUtils.setCheckAPPIdAndSecretTimes(accountId, appId, ++times);
        } else {
            CacheLoginData.setAttribute((String)StrategeUtils.setCheckAPPIdAndSecretErrPrefix(), (String)(accountId + appId), (String)String.valueOf(++times), (int)LoginUtils.thirdAppIdLockTime());
        }
    }

    public static void clearCheckAPPIdAndSecretErrorTimesLogic(String accountId, String appId) {
        CacheLoginData.remove((String)StrategeUtils.setCheckAPPIdAndSecretErrPrefix(), (String)(accountId + appId));
    }

    private static String setCheckAPPIdAndSecretErrPrefix() {
        return "thirdAPIerror";
    }

    public static int getCheckAPPIdAndSecretErrorTimes(String accountId, String appId) {
        String timeString;
        int times = 0;
        if (StringUtils.isNotEmpty(accountId) && StringUtils.isNotEmpty(appId) && StringUtils.isNotEmpty(timeString = CacheLoginData.getAttribute((String)StrategeUtils.setCheckAPPIdAndSecretErrPrefix(), (String)(accountId + appId))) && kd.bos.util.StringUtils.isNumeric((String)timeString)) {
            times = Integer.parseInt(timeString);
        }
        return times;
    }

    public static void setCheckAPPIdAndSecretTimes(String accountId, String appId, int times) {
        if (StringUtils.isNotEmpty(accountId) && StringUtils.isNotEmpty(appId)) {
            CacheLoginData.setAttribute((String)StrategeUtils.setCheckAPPIdAndSecretErrPrefix(), (String)(accountId + appId), (String)String.valueOf(times), (int)LoginUtils.getSecondsNextDay());
        }
    }

    public static int getPasswordWrongTimes(Account currentCenter, String userId, String client) {
        if (StringUtils.isNotEmpty(userId)) {
            String timeString;
            String key = userId + currentCenter.getAccountId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)client)) {
                key = key + client;
            }
            if (StringUtils.isNotEmpty(timeString = CacheLoginData.getAttribute((String)StrategeUtils.getType4PasswordErr(), (String)key)) && kd.bos.util.StringUtils.isNumeric((String)timeString)) {
                return Integer.parseInt(timeString);
            }
            Map<String, Object> userInfo = PswStrategyService.getLockedUserInfo(currentCenter, Long.parseLong(userId));
            Object errcount = userInfo.get("errcount");
            if (!userInfo.isEmpty() && errcount != null && kd.bos.util.StringUtils.isNumeric((String)errcount.toString())) {
                CacheLoginData.setAttribute((String)StrategeUtils.getType4PasswordErr(), (String)key, (String)errcount.toString(), (int)LoginUtils.getSecondsNextDay());
                return Integer.parseInt(errcount.toString());
            }
        }
        return 0;
    }

    public static void addPasswordWrongTimes(Account currentCenter, String userId, String client) {
        int times = StrategeUtils.getPasswordWrongTimes(currentCenter, userId, client);
        StrategeUtils.setPasswordWrongTimes(currentCenter, userId, client, ++times);
    }

    private static void setPasswordWrongTimes(Account currentCenter, String userId, String client, int times) {
        if (StringUtils.isNotEmpty(userId)) {
            String key = userId + currentCenter.getAccountId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)client)) {
                key = key + client;
            }
            CacheLoginData.setAttribute((String)StrategeUtils.getType4PasswordErr(), (String)key, (String)String.valueOf(times), (int)LoginUtils.getSecondsNextDay());
        }
    }

    public static void clearPasswordWrongTimes(Account currentCenter, String userId, String client) {
        if (StringUtils.isNotEmpty(userId) && StringUtils.isNotEmpty(currentCenter.getAccountId())) {
            String key = userId + currentCenter.getAccountId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)client)) {
                key = key + client;
            }
            CacheLoginData.remove((String)StrategeUtils.getType4PasswordErr(), (String)key);
        }
    }

    public static boolean isNeedDisplayVerifyCode(Account currentCenter, Map<String, Object> userMap, String client) {
        boolean isNeed = false;
        int verCodeCtrl = 0;
        String userId = userMap.get("userId").toString();
        int times = StrategeUtils.getPasswordWrongTimes(currentCenter, userId, client);
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentCenter, userMap);
        if (!passwordStrategy.isEmpty() && null != passwordStrategy.get("floginoptions") && (passwordStrategy.get("floginoptions").equals("3") || passwordStrategy.get("floginoptions").equals("2") || passwordStrategy.get("floginoptions").equals("4"))) {
            return true;
        }
        verCodeCtrl = PswStrategyService.getVercodectrl(currentCenter, userMap);
        if (verCodeCtrl != 0 && times != 0 && times >= verCodeCtrl) {
            isNeed = true;
        }
        return isNeed;
    }

    @Deprecated
    public static boolean isNeedDisplayVerifyCode(Account currentCenter, String userId, String client) {
        boolean isNeed = false;
        int verCodeCtrl = 0;
        int times = StrategeUtils.getPasswordWrongTimes(currentCenter, userId, client);
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentCenter, Long.parseLong(userId));
        if (!passwordStrategy.isEmpty() && null != passwordStrategy.get("floginoptions") && passwordStrategy.get("floginoptions").equals("3")) {
            return true;
        }
        verCodeCtrl = PswStrategyService.getVercodectrl(currentCenter, Long.parseLong(userId));
        if (verCodeCtrl != 0 && times != 0 && times >= verCodeCtrl) {
            isNeed = true;
        }
        return isNeed;
    }
}

