/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ServletInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StreamUtils {
    private static final String UTF_8 = "UTF-8";
    private static Log logger = LogFactory.getLog(StreamUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String streamToString(InputStream inputStream) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, UTF_8));){
            int n;
            StringBuilder builder = new StringBuilder();
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, n);
            }
            byte[] input = bos.toByteArray();
            builder.append(new String(input, UTF_8));
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"Http \u670d\u52a1\u8c03\u7528\u5931\u8d25", (String)"StreamUtils_0", (String)"bos-login", (Object[])new Object[0]), e);
        }
    }

    public static byte[] readBytes(ServletInputStream inputStream) {
        return StreamUtils.streamToString((InputStream)inputStream).getBytes(Charset.forName(UTF_8));
    }
}

