/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.login.CacheLoginData;
import kd.bos.login.api.APILoginError;
import kd.bos.login.thirdapps.AppsService;
import kd.bos.login.thirdapps.BaseAuthInfo;
import kd.bos.login.thirdapps.Open3rdapps;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.session.SessionDAO;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ThirdAPIAPPUtils {
    private static final String BOS_LOGIN = "bos-login";
    static String APP_TOKEN_TIMEOUT_KEY = "apptoken.timeout";
    static int DEFAULT_TIMEOUT = 7200;
    private static final String TRUE_STRING = "true";
    public static final String PATH_VAR_SLIT = "/$/";
    public static final String SIGN_ACCOUNTID_SLIT = ":";
    public static final String BASE_AUTH_PATH_VAR_TAG = "/$/openApiSign";
    private static final String BASE_AUTHINFO_PARAMS_SIGN = "openApiSign";

    @SdkInternal
    public static int getTokenTimeout(String tenantId) {
        return SystemPropertyUtils.getInteger((String)tenantId, (String)APP_TOKEN_TIMEOUT_KEY, (Integer)DEFAULT_TIMEOUT);
    }

    private static List<Open3rdapps> getAll3rdApps(Account currentCenter) {
        return AppsService.getAll3rdApps(currentCenter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAppToken(Account currentCenter, String language, String appId, String appSecuret) {
        String content;
        String accountId = currentCenter.getAccountId();
        if (StrategeUtils.checkAPPIdAndSecretErrorTimesIsLock(accountId, appId)) {
            String lockTime = LoginUtils.thirdAppIdLockTime() + "";
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u7684\u8bbf\u95ee\u9519\u8bef\u5df2\u8fde\u7eed3\u6b21\uff0c\u8bf7\u5728%s\u79d2\u540e\u91cd\u8bd5\u3002", (String)"ThirdAPIAPPUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]), lockTime)});
        }
        String appToken = "";
        if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)appId) || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)appSecuret)) throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdAPIAPPUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
        List<Open3rdapps> allList = ThirdAPIAPPUtils.getAll3rdApps(currentCenter);
        Open3rdapps open3rdapps = null;
        for (Open3rdapps apps : allList) {
            if (!appId.equals(apps.getNumber()) || !PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(String.valueOf(apps.getPkId())), (String)appSecuret, (String)apps.getSyspwd())) continue;
            open3rdapps = apps;
            break;
        }
        if (open3rdapps != null) {
            content = ThirdAPIAPPUtils.getCachkeyByAppId(open3rdapps, accountId);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)content) && !SessionUtils.getIsNoNeed(currentCenter.getTenantId())) {
                CacheLoginData.setAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)content, (String)"", (int)0);
            }
        } else {
            StrategeUtils.setCheckAPPIdAndSecretErrorTimesLogic(accountId, appId);
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u4e0d\u6b63\u786e\u3002", (String)"ThirdAPIAPPUtils_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        appToken = UUID.randomUUID().toString();
        ThirdAPIAPPUtils.setCacheValue(currentCenter, appToken, content);
        ThirdAPIAPPUtils.setCacheValue(currentCenter, content, appToken);
        StrategeUtils.clearCheckAPPIdAndSecretErrorTimesLogic(accountId, appId);
        return appToken;
    }

    private static void setCacheValue(Account currentCenter, String appToken, Open3rdapps open3rdapps) {
        String content = ThirdAPIAPPUtils.getCachkeyByAppId(open3rdapps, currentCenter.getAccountId());
        ThirdAPIAPPUtils.setCacheValue(currentCenter, appToken, content);
    }

    private static void setCacheValue(Account currentCenter, String appToken, String content) {
        CacheLoginData.setAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)appToken, (String)content, (int)ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
    }

    public static String getAppTokenKeyType() {
        return "";
    }

    public static String getCachkeyByAppId(Open3rdapps open3rdapps, String accountId) {
        String appToken = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)open3rdapps.getNumber()) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)accountId)) {
            appToken = Instance.getClusterName() + "_" + accountId + "_" + open3rdapps.getPkId();
        }
        return appToken;
    }

    @Deprecated
    public static String getCachkeyByAppId(String appNumer, String accountId) {
        String appToken = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)appNumer) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)accountId)) {
            appToken = Instance.getClusterName() + "_" + accountId + "_" + appNumer;
        }
        return appToken;
    }

    public static boolean checkAppTokenValidation(Account currentCenter, String language, String appToken) {
        String cachContent;
        boolean isOk = false;
        if (appToken != null && currentCenter != null && language != null && (cachContent = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)appToken)) != null) {
            if (!cachContent.contains(currentCenter.getAccountId())) {
                return false;
            }
            String appPkId = ThirdAPIAPPUtils.getAppPkIdByAppToken(currentCenter, appToken);
            Open3rdapps open3rdapps = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)appPkId)) {
                open3rdapps = AppsService.getThirdApps(currentCenter, Long.parseLong(appPkId));
            }
            if (open3rdapps == null || open3rdapps != null && !open3rdapps.isEnable()) {
                return false;
            }
            isOk = true;
            ThirdAPIAPPUtils.setCacheValue(currentCenter, appToken, cachContent);
            ThirdAPIAPPUtils.setCacheValue(currentCenter, cachContent, appToken);
        }
        return isOk;
    }

    public static String getAppIdByAppToken(Account currentCenter, String appToken) {
        String[] contents;
        String openThirdappsPkId;
        String cachContent;
        String appId = "";
        if (appToken != null && currentCenter != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(cachContent = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)appToken))) && kd.bos.util.StringUtils.isNumeric((String)(openThirdappsPkId = (contents = cachContent.split("_"))[contents.length - 1]))) {
            Open3rdapps open3rdapps = AppsService.getThirdApps(currentCenter, Long.parseLong(openThirdappsPkId));
            appId = open3rdapps.getNumber();
        }
        return appId;
    }

    public static String getAppPkIdByAppToken(Account currentCenter, String appToken) {
        String cachContent;
        String appPkId = "";
        if (appToken != null && currentCenter != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(cachContent = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)appToken)))) {
            String[] contents = cachContent.split("_");
            appPkId = contents[contents.length - 1];
        }
        return appPkId;
    }

    public static void setAccessAndAppTokenCach(Account currentCenter, String accessToken, String appToken) {
        CacheLoginData.setAttribute((String)ThirdAPIAPPUtils.getAccessTokenKeyType(currentCenter.getAccountId()), (String)accessToken, (String)appToken, (int)ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
    }

    private static String getAccessTokenKeyType(String accountId) {
        return accountId + "_AC_Token";
    }

    public static String getAppTokenByAccessToken(Account currentCenter, String acessToken) {
        String appToken = null;
        if (acessToken != null && currentCenter != null) {
            appToken = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getAccessTokenKeyType(currentCenter.getAccountId()), (String)acessToken);
        }
        return appToken;
    }

    public static void touchAppToken(Account currentCenter, String appToken) {
        if (appToken != null && currentCenter != null) {
            String cachContent = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getAppTokenKeyType(), (String)appToken);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cachContent)) {
                ThirdAPIAPPUtils.setCacheValue(currentCenter, appToken, cachContent);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)appToken)) {
                ThirdAPIAPPUtils.setCacheValue(currentCenter, cachContent, appToken);
            }
        }
    }

    private static void touchAppTokenByAccessToken(Account currentCenter, String accessToken) {
        String appToken = ThirdAPIAPPUtils.getAppTokenByAccessToken(currentCenter, accessToken);
        if (appToken != null) {
            ThirdAPIAPPUtils.touchAppToken(currentCenter, appToken);
        }
    }

    public static void touchAppTokenByAccessToken(SessionDAO sessionDAO, Map<String, String> sessionInfo, String globalSessionId) {
        String userId;
        if (sessionDAO == null) {
            sessionInfo = SessionUtils.getSessionInfo(sessionDAO, globalSessionId);
        }
        if (sessionInfo != null && sessionInfo.size() > 0 && (userId = sessionInfo.get("userId")) != null) {
            Account currentCenter = LoginAccountFactory.createInstanceBySession(sessionInfo, Optional.empty()).getAccount();
            ThirdAPIAPPUtils.touchAppTokenByAccessToken(currentCenter, globalSessionId);
        }
    }

    public static boolean touchAppToken(SessionDAO sessionDAO, Map<String, String> sessionInfo, String globalSessionId) {
        boolean isAvailable = true;
        if (sessionDAO == null) {
            sessionInfo = SessionUtils.getSessionInfo(sessionDAO, globalSessionId);
        }
        if (sessionInfo != null && sessionInfo.size() > 0 && kd.bos.util.StringUtils.isNotEmpty((String)sessionInfo.get("userId"))) {
            Account currentCenter = LoginAccountFactory.createInstanceBySession(sessionInfo, Optional.empty()).getAccount();
            String appId = sessionInfo.get("api3rdAppId");
            List<Open3rdapps> open3rdapps = ThirdAPIAPPUtils.getAppList(currentCenter);
            if (kd.bos.util.StringUtils.isNotEmpty((String)appId) && open3rdapps != null && open3rdapps.size() >= 0) {
                for (Open3rdapps open3rdapp : open3rdapps) {
                    if (open3rdapp.getPkId().equals(Long.parseLong(appId))) {
                        isAvailable = true;
                        break;
                    }
                    isAvailable = false;
                }
            }
        }
        if (isAvailable) {
            ThirdAPIAPPUtils.touchAppTokenByAccessToken(sessionDAO, sessionInfo, globalSessionId);
        }
        return isAvailable;
    }

    public static String getKeysFrom3rdApps(String appId, Account currentCenter) {
        String key = null;
        List<Open3rdapps> appList = null;
        appList = ThirdAPIAPPUtils.getAppList(currentCenter);
        if (appList != null) {
            for (Open3rdapps open3rdapps : appList) {
                if (!open3rdapps.getNumber().equals(appId)) continue;
                key = open3rdapps.getEncryptedKey();
                break;
            }
        }
        return key;
    }

    public static void createApiContext(String appId, Account currentCenter) {
        List<Open3rdapps> appList = null;
        appList = ThirdAPIAPPUtils.getAppList(currentCenter);
        if (appList != null) {
            for (Open3rdapps open3rdapps : appList) {
                if (!open3rdapps.getNumber().equals(appId)) continue;
                ApiContext context = ApiContext.create();
                context.setAppId(open3rdapps.getPkId());
                context.setAppNum(appId);
                ApiContext.set((ApiContext)context);
                break;
            }
        }
    }

    public static boolean isSupportJWTPKI(String tenantId) {
        boolean isSupport = false;
        String isSupportString = System.getProperty(tenantId + "_" + "is_jwt_support_pki");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)isSupportString)) {
            isSupportString = System.getProperty("is_jwt_support_pki");
        }
        if (TRUE_STRING.equalsIgnoreCase(isSupportString)) {
            isSupport = true;
        }
        return isSupport;
    }

    public static Open3rdapps getAPPByID(String appId, Account currentCenter) {
        Open3rdapps returnValue = null;
        List<Open3rdapps> appList = null;
        appList = ThirdAPIAPPUtils.getAppList(currentCenter);
        if (appList != null) {
            for (Open3rdapps open3rdapps : appList) {
                if (!open3rdapps.getNumber().equals(appId)) continue;
                returnValue = open3rdapps;
                break;
            }
        }
        return returnValue;
    }

    private static List<Open3rdapps> getAppList(Account currentCenter) {
        List appList = null;
        if (currentCenter != null) {
            Object listObj = LocalCacheUtils.get("cosmic_local_applist" + currentCenter.getAccountId());
            if (listObj == null) {
                appList = AppsService.getAll3rdApps(currentCenter);
                LocalCacheUtils.put("cosmic_local_applist" + currentCenter.getAccountId(), appList);
            } else {
                appList = (List)listObj;
            }
        }
        return appList;
    }

    public static BaseAuthInfo getBaseAuthInfoBySign(Account currentCenter, String sign) {
        if (currentCenter == null) {
            return null;
        }
        BaseAuthInfo baseAuthInfo = null;
        String cacheSignKey = "cosmic_local_basicauth-" + currentCenter.getAccountId() + "-" + sign;
        Object listObj = LocalCacheUtils.get(cacheSignKey);
        if (listObj == null) {
            baseAuthInfo = AppsService.getBasicAuthInfo(currentCenter, sign);
            if (baseAuthInfo != null) {
                LocalCacheUtils.put(cacheSignKey, baseAuthInfo);
            }
        } else {
            baseAuthInfo = (BaseAuthInfo)listObj;
        }
        return baseAuthInfo;
    }

    public static void createBasicAuthApiContext(AuthResult authResult) {
        if (authResult == null) {
            return;
        }
        ApiContext context = ApiContext.create();
        context.setAppId(authResult.getThirdId());
        context.setAppNum(authResult.getThirdAppNumber());
        ApiContext.set((ApiContext)context);
    }

    public static String getSignByRequest(HttpServletRequest request) {
        return ThirdAPIAPPUtils.getBasicAuthParamsByRequest(request, BASE_AUTHINFO_PARAMS_SIGN);
    }

    public static String getBasicAuthParamsByRequest(HttpServletRequest request, String paramsName) {
        String requestURI = request.getRequestURI();
        String accessKey = "";
        if (StringUtil.isNotEmpty((String)requestURI) && requestURI.indexOf(BASE_AUTH_PATH_VAR_TAG) > 0) {
            String pathVars = requestURI.substring(requestURI.indexOf(PATH_VAR_SLIT) + PATH_VAR_SLIT.length());
            Map<String, String> pathVarMap = ThirdAPIAPPUtils.getPathVarMap(pathVars);
            accessKey = pathVarMap.get(paramsName);
        } else {
            accessKey = LoginUtils.getParamerter(request, paramsName);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)accessKey)) {
            accessKey = accessKey.trim();
        }
        return accessKey;
    }

    public static Map<String, String> getPathVarMap(String pathVar) {
        HashMap<String, String> pathVarMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)pathVar)) {
            return pathVarMap;
        }
        String[] vars = pathVar.split("/");
        if (vars != null && vars.length > 0) {
            for (int i = 0; i < vars.length; i += 2) {
                String value;
                String key = i < vars.length ? vars[i] : null;
                String string = value = i + 1 < vars.length ? vars[i + 1] : null;
                if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)key)) continue;
                pathVarMap.put(key, value);
            }
        }
        return pathVarMap;
    }

    public static Map<String, String> getAccountIdAndSignCode(String accessKey) {
        String signWithAccountId = new String(Base64.getUrlDecoder().decode(accessKey));
        String[] signWithAccountIds = signWithAccountId.split(SIGN_ACCOUNTID_SLIT);
        String signCode = "";
        String accountId = "";
        if (signWithAccountIds != null && signWithAccountIds.length == 2) {
            signCode = signWithAccountIds[0];
            accountId = signWithAccountIds[1];
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)signCode)) {
            signCode = signCode.trim();
        }
        result.put("signCode", signCode);
        result.put("accountId", accountId);
        return result;
    }

    public static boolean isBase64(String sign) {
        char[] strChars;
        if (StringUtil.isEmpty((String)sign)) {
            return false;
        }
        if (sign.length() % 4 != 0) {
            return false;
        }
        for (char c : strChars = sign.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '=' || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static void checkDateTimeAndSigature(String datetimeString, String signatureNonce, String tenantId, String accountId) {
        if (StringUtils.isEmpty(signatureNonce)) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11signatureNonce\u53c2\u6570\u3002", (String)"APIHandlerFilter_1", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        if (StringUtils.isEmpty(datetimeString)) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11timestamp\u53c2\u6570\u3002", (String)"APIHandlerFilter_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        Date sDate = null;
        sDate = kd.bos.util.StringUtils.isNumericString((String)datetimeString) ? ThirdAPIAPPUtils.getTime(datetimeString) : DateUtils.parseDateTime((String)datetimeString, (String)ShaSignUtils.SIGNATUR_TIME_FORMAT);
        if (sDate == null) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1atimestamp\u53c2\u6570\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u662f\uff1a%s", (String)"APIHandlerFilter_3", (String)BOS_LOGIN, (Object[])new Object[]{ShaSignUtils.SIGNATUR_TIME_FORMAT})});
        }
        int rangMiutes = ShaSignUtils.getSignRangeMinutes(tenantId);
        Date now = new Date();
        if (Math.abs(now.getTime() - sDate.getTime()) / 60000L > (long)rangMiutes) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"timestamp\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u5728\u6b63\u786e\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"APIHandlerFilter_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String currentNonce = CacheLoginData.getAttribute((String)ThirdAPIAPPUtils.getType(tenantId, accountId), (String)signatureNonce);
        if (StringUtils.isNotEmpty(currentNonce)) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u672c\u6b21\u53c2\u6570\u5df2\u7ecf\u8c03\u7528\u8fc7\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u8c03\u7528\uff1a", (String)"APIHandlerFilter_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        CacheLoginData.setAttribute((String)ThirdAPIAPPUtils.getType(tenantId, accountId), (String)signatureNonce, (String)signatureNonce, (int)(rangMiutes * 60));
    }

    private static Date getTime(String datetimeString) {
        Date sDate = null;
        try {
            sDate = new Date(Long.parseLong(datetimeString));
        }
        catch (Throwable e) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11timestamp\u53c2\u6570\u3002", (String)"APIHandlerFilter_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return sDate;
    }

    private static String getType(String tenantId, String accountId) {
        return "signatrue_noce" + tenantId + accountId;
    }
}

