/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.util.RevProxyUtil;

public class URLUtils {
    private static final String IERPANCHOR = "ierpanchor=";
    private static Log logger = LogFactory.getLog(URLUtils.class);
    private static String ATFLAG = "@";

    public static String buildRedirectUrl(ServletRequest servletRequest) {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String requestUrl = httpRequest.getRequestURL().toString();
        String contextPath = httpRequest.getContextPath() + "/";
        String pageUrl = requestUrl.substring(requestUrl.lastIndexOf(contextPath) + contextPath.length(), requestUrl.length());
        String requestFullUrl = RevProxyUtil.getURLContextPath((HttpServletRequest)httpRequest) + pageUrl;
        if (!kd.bos.util.StringUtils.isEmpty((String)requestFullUrl) && "1".equalsIgnoreCase(httpRequest.getHeader("https")) && requestFullUrl.startsWith("http://")) {
            requestFullUrl = requestFullUrl.replaceFirst("http:", "https:");
        }
        StringBuilder redirectUri = new StringBuilder();
        if (!httpRequest.getHeader("User-Agent").startsWith("Qing") && kd.bos.util.StringUtils.isNotEmpty((String)requestFullUrl)) {
            int segFrom = requestFullUrl.indexOf("/mobile.html");
            boolean bMobileTest = requestFullUrl.endsWith("mobile.html");
            if (segFrom > 0 && !bMobileTest) {
                String dform = requestFullUrl.substring(0, segFrom);
                requestFullUrl = dform + "/index.html?";
            }
        }
        redirectUri.append(requestFullUrl);
        String query = httpRequest.getQueryString();
        if (kd.bos.util.StringUtils.isNotEmpty((String)query)) {
            boolean transed = false;
            if (query.startsWith(IERPANCHOR)) {
                int segFrom = query.indexOf(38);
                if (segFrom > 0) {
                    String dform = query.substring(IERPANCHOR.length(), segFrom);
                    query = "#/" + dform + "&" + query.substring(segFrom + 1);
                    if (query.contains("kdMessageLogin")) {
                        query = query.substring(0, query.indexOf("&kdMessageLogin"));
                    }
                    transed = true;
                } else {
                    String dform = httpRequest.getParameter("ierpanchor");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)dform) && !SecurityUtils.checkXss(dform)) {
                        query = "#/" + dform;
                        transed = true;
                    }
                }
            }
            if (!transed) {
                redirectUri.append("?");
            }
            redirectUri.append(query);
        }
        return redirectUri.toString();
    }

    public static String buildRedirectUrl(String requestUrl) {
        String url;
        if (!requestUrl.contains(IERPANCHOR)) {
            url = requestUrl;
        } else {
            url = requestUrl.replaceAll("[?]ierpanchor=", "#/");
            if (url.contains(IERPANCHOR)) {
                url = url.replaceAll(IERPANCHOR, "#/");
            }
            logger.info(String.format("@...\u6784\u9020\u91cd\u5b9a\u5411\u7684URL,\u539f\u59cb\uff1a%s ,\u5904\u7406\u540e:%s .", requestUrl, url));
        }
        return url;
    }

    public static String checkRedirectUrl(HttpServletRequest request, String redirect) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)redirect) && !LoginUtils.isSelfEnvironment(redirect, request)) {
            redirect = "";
        }
        return redirect;
    }

    public static String securityFilterRedirectUrl(String redirect) {
        String url = redirect;
        if (kd.bos.util.StringUtils.isNotEmpty((String)redirect) && redirect.contains(ATFLAG)) {
            String[] urlArray = redirect.split(ATFLAG);
            url = urlArray[0];
        }
        return url;
    }

    @Deprecated
    public static String buildNoCodeUrl(String sessionId, String url, long timeOut) {
        String code = StringUtils.randomWord(32);
        url = url + "&nocodeCode=" + code;
        CacheLoginData.setAttribute((String)"nocode", (String)code, (String)sessionId, (int)((int)timeOut));
        return url;
    }

    @Deprecated
    public static String getNoCodeSession(HttpServletRequest request) {
        String code = request.getParameter("nocodeCode");
        String sessionId = CacheLoginData.getAttribute((String)"nocode", (String)code);
        return sessionId;
    }
}

