/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.StringUtils;

public class ZipUtils {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(ZipUtils.class);

    private static void zip(String srcRootDir, File file, ZipOutputStream zos) {
        block19: {
            try {
                if (file == null) {
                    return;
                }
                if (file.isFile()) {
                    int bufferLen = 1024;
                    byte[] data = new byte[bufferLen];
                    String subPath = file.getCanonicalPath();
                    int index = subPath.indexOf(srcRootDir);
                    if (index != -1) {
                        subPath = subPath.substring(srcRootDir.length() + File.separator.length());
                    }
                    ZipEntry entry = new ZipEntry(subPath);
                    zos.putNextEntry(entry);
                    try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                        int count;
                        while ((count = bis.read(data, 0, bufferLen)) != -1) {
                            zos.write(data, 0, count);
                        }
                        bis.close();
                        zos.closeEntry();
                        break block19;
                    }
                }
                File[] childFileList = file.listFiles();
                for (int n = 0; n < childFileList.length; ++n) {
                    ZipUtils.zip(srcRootDir, childFileList[n], zos);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
            }
        }
    }

    public static void zip(String srcPath, String zipPath, String zipFileName) {
        if (StringUtils.isEmpty(srcPath) || StringUtils.isEmpty(zipPath) || StringUtils.isEmpty(zipFileName)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8def\u5f84\u548c\u6587\u4ef6\u540d\u53c2\u6570\u9519\u8bef\u3002", (String)"ZipUtils_0", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        FilterOutputStream cos = null;
        ZipOutputStream zos = null;
        try {
            int index;
            String zipFilePath;
            File zipFile;
            File srcFile = new File(SecurityUtils.normalize(srcPath));
            if (srcFile.isDirectory() && zipPath.indexOf(srcPath) != -1) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%1s\u4e0d\u80fd\u662f%2s\u7684\u5b50\u8def\u5f84", (String)"ZipUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]), zipPath, srcFile));
            }
            File zipDir = new File(SecurityUtils.normalize(zipPath));
            if (!zipDir.exists() || !zipDir.isDirectory()) {
                zipDir.mkdirs();
            }
            if ((zipFile = new File(SecurityUtils.normalize(zipFilePath = zipPath + File.separator + zipFileName))).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(zipFilePath);
                zipFile.delete();
            }
            cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            zos = new ZipOutputStream(cos);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipUtils.zip(srcRootDir, srcFile, zos);
            if (zos != null) {
                zos.flush();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            try {
                if (cos != null) {
                    cos.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void unzip(String zipFilePath, String unzipFilePath, boolean includeZipFileName) {
        if (StringUtils.isEmpty(zipFilePath) || StringUtils.isEmpty(unzipFilePath)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u538b\u7f29\u8def\u5f84\u53c2\u6570\u9519\u8bef\u3002", (String)"ZipUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        ZipFile zip = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File unzipFileDir;
            File zipFile = new File(SecurityUtils.normalize(zipFilePath));
            if (includeZipFileName) {
                String fileName = zipFile.getName();
                if (StringUtils.isNotEmpty(fileName)) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                }
                unzipFilePath = unzipFilePath + File.separator + fileName;
            }
            if (!(unzipFileDir = new File(SecurityUtils.normalize(unzipFilePath))).exists() || !unzipFileDir.isDirectory()) {
                unzipFileDir.mkdirs();
            }
            ZipEntry entry = null;
            String entryFilePath = null;
            String entryDirPath = null;
            File entryFile = null;
            File entryDir = null;
            int index = 0;
            int count = 0;
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                entryFilePath = unzipFilePath + File.separator + entry.getName();
                index = entryFilePath.lastIndexOf(File.separator);
                entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
                entryDir = new File(SecurityUtils.normalize(entryDirPath));
                if (!entryDir.exists() || !entryDir.isDirectory()) {
                    entryDir.mkdirs();
                }
                if ((entryFile = new File(SecurityUtils.normalize(entryFilePath))).exists()) {
                    SecurityManager securityManager = new SecurityManager();
                    securityManager.checkDelete(entryFilePath);
                    entryFile.delete();
                }
                bos = new BufferedOutputStream(new FileOutputStream(entryFile));
                bis = new BufferedInputStream(zip.getInputStream(entry));
                while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void unzip(File zipFile, String unzipFilePath, boolean includeZipFileName) throws IOException {
        if (zipFile == null || StringUtils.isEmpty(unzipFilePath)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u538b\u7f29\u8def\u5f84\u53c2\u6570\u9519\u8bef\u3002", (String)"ZipUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        ZipFile zip = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File unzipFileDir;
            if (includeZipFileName) {
                String fileName = zipFile.getName();
                if (StringUtils.isNotEmpty(fileName)) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                }
                unzipFilePath = unzipFilePath + File.separator + fileName;
            }
            if (!(unzipFileDir = new File(SecurityUtils.normalize(unzipFilePath))).exists() || !unzipFileDir.isDirectory()) {
                unzipFileDir.mkdirs();
            }
            ZipEntry entry = null;
            String entryFilePath = null;
            String entryDirPath = null;
            File entryFile = null;
            File entryDir = null;
            int index = 0;
            int count = 0;
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                SecurityManager securityManager;
                entry = entries.nextElement();
                entryFilePath = unzipFilePath + File.separator + entry.getName();
                index = entryFilePath.lastIndexOf(File.separator);
                entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
                entryDir = new File(SecurityUtils.normalize(entryDirPath));
                if (!entryDir.exists() || !entryDir.isDirectory()) {
                    entryDir.mkdirs();
                }
                entryFile = new File(SecurityUtils.normalize(entryFilePath));
                if (entry.isDirectory()) {
                    securityManager = new SecurityManager();
                    entryFile.delete();
                    entryFile.mkdir();
                    continue;
                }
                if (entryFile.exists()) {
                    securityManager = new SecurityManager();
                    entryFile.delete();
                }
                bos = new BufferedOutputStream(new FileOutputStream(entryFile));
                bis = new BufferedInputStream(zip.getInputStream(entry));
                while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private static File getQueryFile(String fullPath, String unzipFilePath) {
        File returnFile = new File(unzipFilePath + File.separator + fullPath);
        return returnFile;
    }
}

