/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.log;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.util.SessionComUtil;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MServiceUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.log.AppLogParams;
import kd.bos.login.utils.log.LogInAppInfo;
import kd.bos.login.utils.log.LoginLogInfo;
import kd.bos.login.utils.log.OperateConfirmLog;
import kd.bos.service.ServiceFactory;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.NetAddressUtils;

public class LoginLogUtils {
    private static final String BOS_LOGIN = "bos-login";
    private static final String BIZ_APP_ID = "83bfebc8000037ac";
    private static final String BIZ_OBJ_ID = "bos_user";
    private static final Log logger = LogFactory.getLog(LoginLogUtils.class);
    private static final String MODULE_NAME = "moduleName";
    private static final String OPERATION_NAME = "operationName";
    private static final String RESOURCE_MODULE = "resourceLocationModule";
    private static final String RESOURCE_OPERATION = "resourceLocationOperation";
    private static final String SESSION_UTILS_0 = "SessionUtils_0";
    private static final String SESSION_UTILS_1 = "SessionUtils_1";
    private static final String SESSION_UTILS_6 = "SessionUtils_6";
    private static final String SESSION_UTILS_8 = "SessionUtils_8";
    private static final String SESSION_UTILS_9 = "SessionUtils_9";
    private static final String SESSION_UTILS_3 = "SessionUtils_3";
    private static final String LOGINACTION_51 = "LoginAction_51";
    private static final String LOGINACTION_21 = "LoginAction_21";
    private static final String RESETPASSWORDACTION_49 = "ResetPasswordAction_49";
    private static final String RESETPASSWORDACTION_50 = "ResetPasswordAction_50";
    private static final String PSWSTRATEGYSERVICE_11 = "PswStrategyService_11";
    private static final String PSWSTRATEGYSERVICE_12 = "PswStrategyService_12";
    private static final String PSWSTRATEGYSERVICE_9 = "PswStrategyService_9";
    private static final String PSWSTRATEGYSERVICE_10 = "PswStrategyService_10";
    public static final String PHONE = "phone";
    protected static Map<String, Map<String, String>> clientType;
    protected static Map<String, Map<String, String>> thirdAppType;

    private static void initClient() {
        clientType = SessionComUtil.getClients((String)"CLIENT_TYPE");
        thirdAppType = SessionComUtil.getClients((String)"THIRD_APP_TYPE");
    }

    public static void addLog(Account currentCenter, LoginLogInfo logInfo, String sessionId, SessionInfo si) {
        Lang oldLangage = LoginLangUtils.getLang();
        try {
            if (LoginLogUtils.isGuest(logInfo)) {
                return;
            }
            if (StringUtils.isEmpty(sessionId)) {
                sessionId = LoginUtils.getGuestSessionId(currentCenter.getAccountId(), currentCenter.getTenantId(), oldLangage, logInfo.getIp());
                si = SessionUtils.getGuestSessionData(Instance.getClusterName(), currentCenter.getTenantId(), currentCenter.getAccountId(), oldLangage);
            }
            MServiceUtils.invoke("ILogService", "addLog", sessionId, logInfo.getClientEnum(), si, LoginLogUtils.wrapLogInfo(logInfo, currentCenter));
        }
        catch (Exception e) {
            logger.error("addLog\u5f02\u5e38", (Throwable)e);
        }
        LoginLangUtils.setLang(oldLangage);
    }

    public static void addAuthOpLog(String sessionId, OperateConfirmLog operateConfirmLog) {
        try {
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
            Map<String, String> sessionInfo = SessionUtils.getSessionInfo(sessionDAO, sessionId);
            SessionInfo info = SessionManager.getSessionInfo(sessionInfo);
            MServiceUtils.invoke("ILogService", "addLog", sessionId, LoginClientEnum.WEB, info, operateConfirmLog);
        }
        catch (Exception e) {
            logger.error("addLog\u5f02\u5e38", (Throwable)e);
        }
    }

    public static LoginLogInfo initLoginLogInfo(SessionInfo si, SessionParams params, String operation) {
        String operationName = LoginLogUtils.getOperation(si, operation);
        Map<String, String> operationMaps = LoginLogUtils.getOperationMaps(operation, operationName);
        LoginLogInfo loginLogInfo = new LoginLogInfo(si.getUserId(), si.getOrgId(), operationMaps.get(MODULE_NAME), operationMaps.get(OPERATION_NAME));
        loginLogInfo.setClientEnum(params.getClientEnum());
        loginLogInfo.setIp(params.getIP());
        loginLogInfo.setResourceLocationModule(operationMaps.get(RESOURCE_MODULE));
        loginLogInfo.setResourceLocationOperation(operationMaps.get(RESOURCE_OPERATION));
        loginLogInfo.setAppType(params.getAppType());
        return loginLogInfo;
    }

    private static String getOperation(SessionInfo si, String operation) {
        String s = null;
        if ("UserUnLock".equals(operation)) {
            s = ResManager.loadKDString((String)"\u7528\u6237\uff1a%s\u89e3\u9501\u6210\u529f", (String)"LoginLogUtils_15", (String)BOS_LOGIN, (Object[])new Object[]{si.getUserId()});
        }
        return s;
    }

    public static LoginLogInfo initLoginLogInfo(String userId, String orgId, SessionParams params, String operation) {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setUserId(userId);
        sessionInfo.setOrgId(orgId);
        return LoginLogUtils.initLoginLogInfo(sessionInfo, params, operation);
    }

    private static Map<String, String> getOperationMaps(String operation, String operationName1) {
        HashMap<String, String> operationMaps = new HashMap<String, String>(8);
        String moduleName = "";
        String operationName = "";
        String resourceLocationModule = "";
        String resourceLocationOperation = "";
        switch (operation) {
            case "login": {
                moduleName = "LOGINLOGMULTILANG_0";
                operationName = "LOGINLOGMULTILANG_1";
                resourceLocationModule = SESSION_UTILS_0;
                resourceLocationOperation = SESSION_UTILS_1;
                break;
            }
            case "remove": {
                moduleName = "LOGINLOGMULTILANG_2";
                operationName = "LOGINLOGMULTILANG_4";
                resourceLocationModule = SESSION_UTILS_8;
                resourceLocationOperation = SESSION_UTILS_3;
                break;
            }
            case "logout": {
                moduleName = "LOGINLOGMULTILANG_2";
                operationName = "LOGINLOGMULTILANG_3";
                resourceLocationModule = SESSION_UTILS_8;
                resourceLocationOperation = SESSION_UTILS_9;
                break;
            }
            case "timeoutLogout": {
                moduleName = "LOGINLOGMULTILANG_2";
                operationName = "LOGINLOGMULTILANG_5";
                resourceLocationModule = SESSION_UTILS_8;
                resourceLocationOperation = SESSION_UTILS_6;
                break;
            }
            case "passwordError": {
                moduleName = "LOGINLOGMULTILANG_0";
                operationName = "LOGINLOGMULTILANG_6";
                resourceLocationModule = SESSION_UTILS_0;
                resourceLocationOperation = LOGINACTION_51;
                break;
            }
            case "IPControl": {
                moduleName = "LOGINLOGMULTILANG_0";
                operationName = "LOGINLOGMULTILANG_9";
                resourceLocationModule = SESSION_UTILS_0;
                resourceLocationOperation = LOGINACTION_21;
                break;
            }
            case "ResetPassword": {
                moduleName = "LOGINLOGMULTILANG_8";
                operationName = "LOGINLOGMULTILANG_7";
                resourceLocationModule = RESETPASSWORDACTION_49;
                resourceLocationOperation = RESETPASSWORDACTION_50;
                break;
            }
            case "UserLock": {
                moduleName = "LOGINLOGMULTILANG_10";
                operationName = "LOGINLOGMULTILANG_11";
                resourceLocationModule = PSWSTRATEGYSERVICE_11;
                resourceLocationOperation = PSWSTRATEGYSERVICE_12;
                break;
            }
            case "UserUnLock": {
                moduleName = "LOGINLOGMULTILANG_12";
                operationName = operationName1;
                resourceLocationModule = PSWSTRATEGYSERVICE_9;
                resourceLocationOperation = PSWSTRATEGYSERVICE_10;
                break;
            }
        }
        operationMaps.put(MODULE_NAME, moduleName);
        operationMaps.put(OPERATION_NAME, operationName);
        operationMaps.put(RESOURCE_MODULE, resourceLocationModule);
        operationMaps.put(RESOURCE_OPERATION, resourceLocationOperation);
        return operationMaps;
    }

    private static boolean isGuest(LoginLogInfo logInfo) {
        if (LoginUtils.isGuestUser(logInfo.getUserid())) {
            return true;
        }
        return "0".equals(logInfo.getUserid());
    }

    public static void addLog(Account currentCenter, LoginLogInfo logInfo) {
        LoginLogUtils.addLog(currentCenter, logInfo, "", null);
    }

    private static AppLogInfo wrapLogInfo(LoginLogInfo loginLogInfo, Account currentCenter) {
        if (null == thirdAppType) {
            LoginLogUtils.initClient();
        }
        LoginClientEnum clientEnum = loginLogInfo.getClientEnum();
        Lang lang = LoginLangUtils.getLang();
        String clientType = "";
        if (null != clientEnum && StringUtils.isNotEmpty(clientEnum.name())) {
            clientType = clientEnum.name().toUpperCase();
        }
        LogInAppInfo logInfo = new LogInAppInfo();
        logInfo.setUserID(StringUtils.isNotBlank(loginLogInfo.getUserid()) ? Long.valueOf(Long.parseLong(loginLogInfo.getUserid())) : null);
        logInfo.setOrgID(StringUtils.isNotBlank(loginLogInfo.getOrgid()) ? Long.valueOf(Long.parseLong(loginLogInfo.getOrgid())) : null);
        logInfo.setBizAppID(BIZ_APP_ID);
        logInfo.setBizObjID(BIZ_OBJ_ID);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(clientType);
        logInfo.setClientName(clientType);
        logInfo.setClientIP(loginLogInfo.getIp());
        logInfo.setOpName(loginLogInfo.getModulName());
        logInfo.setOpDescription(LoginLogUtils.getForceLogoutDesc(loginLogInfo.getOperationName()));
        logInfo.setAccountId(currentCenter.getAccountId());
        logInfo.setTenantId(currentCenter.getTenantId());
        logInfo.setLogType(1);
        logInfo.setLanguage(lang.name());
        if (kd.bos.util.StringUtils.isNotEmpty((String)loginLogInfo.getAppType())) {
            String extendClientName = LoginLogUtils.getExtendClientName(loginLogInfo.getAppType().toUpperCase());
            logInfo.setExtendClientName(extendClientName);
        } else {
            clientType = LoginClientEnum.MOBILE.name().equalsIgnoreCase(clientType) ? LoginClientEnum.WEB.name() : clientType;
            logInfo.setExtendClientName(clientType);
        }
        return logInfo;
    }

    public static String getExtendClientName(Map<String, String> client) {
        if (null != client) {
            return client.get(LoginLangUtils.getLang().name());
        }
        return null;
    }

    public static String getExtendClientName(String appType) {
        String extendClientName = LoginLogUtils.getExtendClientName(thirdAppType.get(appType));
        if (StringUtils.isNotBlank(extendClientName)) {
            return extendClientName;
        }
        return appType;
    }

    private static String getForceLogoutDesc(String operationName) {
        String str = ResManager.loadKDString((String)"\u8e22\u51fa\u7528\u6237\u6210\u529f", (String)SESSION_UTILS_3, (String)BOS_LOGIN, (Object[])new Object[0]);
        String result = "";
        if (StringUtils.isNotEmpty(operationName) && operationName.contains(str)) {
            result = RequestContext.get() != null ? SystemPropertyUtils.getProptyByTenant("force_logout_log_operation_description", RequestContext.get().getTenantId()) : SystemPropertyUtils.getProptyByTenant("force_logout_log_operation_description", null);
        }
        if (StringUtils.isEmpty(result)) {
            result = operationName;
        }
        return result;
    }

    private static AppLogInfo initAppLogInfo(AppLogParams params) {
        Map<String, String> info = LoginLogUtils.getUserInfo(params.getAccount(), params.getUser(), params.getType(), params.isAdmin());
        LogInAppInfo logInfo = new LogInAppInfo();
        long uid = 0L;
        long oid = 0L;
        if (StringUtils.isNotBlank(info.get("fid"))) {
            uid = Long.parseLong(info.get("fid"));
        }
        if (StringUtils.isNotBlank(info.get("forgid"))) {
            oid = Long.parseLong(info.get("forgid"));
        }
        logInfo.setUserID(uid);
        logInfo.setOrgID(oid);
        logInfo.setBizAppID(BIZ_APP_ID);
        logInfo.setBizObjID(BIZ_OBJ_ID);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(params.getClientType());
        logInfo.setClientName(params.getClientType());
        logInfo.setClientIP(params.getIp());
        logInfo.setOpName(StringUtils.isNotEmpty(params.getOpName()) ? params.getOpName() : ResManager.loadKDString((String)"\u767b\u5f55", (String)SESSION_UTILS_0, (String)BOS_LOGIN, (Object[])new Object[0]));
        logInfo.setOpDescription(LoginLogUtils.getAppResultInfo(params.getType(), params.isResult()));
        logInfo.setAccountId(params.getAccount().getAccountId());
        logInfo.setTenantId(params.getAccount().getTenantId());
        logInfo.setLanguage(Lang.get().name());
        return logInfo;
    }

    private static String getAppResultInfo(String type, boolean result) {
        String msg = PHONE.equals(type) ? ResManager.loadKDString((String)"\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801", (String)"LoginLogUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", (String)"LoginLogUtils_0", (String)BOS_LOGIN, (Object[])new Object[0]);
        msg = msg + (result ? ResManager.loadKDString((String)"\u6210\u529f", (String)"LoginLogUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"LoginLogUtils_3", (String)BOS_LOGIN, (Object[])new Object[0]));
        return msg;
    }

    private static Map<String, String> getUserInfo(Account account, String user, String type, boolean admin) {
        if (admin) {
            return LoginUserService.getErpUserInfoByUserName(account, user, Lang.get().name());
        }
        if (PHONE.equals(type)) {
            return LoginUserService.getErpUserInfoByPhone(account, user, Lang.get().name());
        }
        return LoginUserService.getErpUserInfoByEmail(account, user, Lang.get().name());
    }

    public static void addAppLog(AppLogParams logInfo) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addLog(LoginLogUtils.initAppLogInfo(logInfo));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static AppLogParams initParams(HttpServletRequest servletRequest, Account currentCenter, String phone, String type) {
        String clientType = AgentUtil.isMobile(servletRequest) ? LoginClientEnum.MOBILE.name() : LoginClientEnum.WEB.name();
        AppLogParams logParams = new AppLogParams(currentCenter, phone, type, true, clientType.toLowerCase(), NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
        return logParams;
    }
}

