/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.log;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;

public class ThirdAppLogUtils {
    private static Log logger = LogFactory.getLog(ThirdAppLogUtils.class);

    public static void addLog(ThirdAppLogInfo logInfo) {
        try {
            String errorCode;
            DynamicObject thirdAppLog = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_thirdapp_auth");
            thirdAppLog.set("corpid", (Object)logInfo.getCorpid());
            thirdAppLog.set("agentid", (Object)logInfo.getAgentid());
            thirdAppLog.set("opdesc", (Object)logInfo.getOpdesc());
            thirdAppLog.set("optime", (Object)logInfo.getOptime());
            thirdAppLog.set("status", (Object)logInfo.getStatus());
            thirdAppLog.set("url", (Object)logInfo.getUrl());
            Long thirdType = logInfo.getThirdType();
            if (thirdType != null) {
                thirdAppLog.set("imtype", (Object)thirdType);
            }
            if (StringUtils.isNotEmpty(errorCode = logInfo.getErrorcode())) {
                thirdAppLog.set("errorcode", (Object)errorCode);
            }
            thirdAppLog.set("resourceid", (Object)logInfo.getResourceId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{thirdAppLog});
        }
        catch (Exception e) {
            logger.info("ThirdAppLogUtils#addLog error", (Object)e);
        }
    }

    public static ThirdAppLogInfo wrapThirdAppLogInfo(KDException kde, HttpServletRequest request, boolean resourceExist) {
        ThirdAppLogInfo thirdAppLogInfo = new ThirdAppLogInfo();
        thirdAppLogInfo.setOptime(new Date());
        thirdAppLogInfo.setStatus("0");
        ErrorCode errorCode = kde.getErrorCode();
        String msg = "";
        if (errorCode != null) {
            String resourceId = errorCode.getCode();
            if (resourceExist) {
                thirdAppLogInfo.setResourceId(resourceId);
                Object[] args = kde.getArgs();
                if (args != null && args.length != 0) {
                    thirdAppLogInfo.setOpdesc(SerializationUtils.toJsonString(args));
                }
            }
            msg = errorCode.getMessage();
        }
        if (StringUtils.isEmpty(msg)) {
            msg = kde.getMessage();
        }
        if (!resourceExist) {
            thirdAppLogInfo.setOpdesc(msg);
        }
        if (request != null) {
            String url = UrlService.getDomainContextUrl() + request.getServletPath() + "?" + request.getQueryString();
            thirdAppLogInfo.setUrl(url);
        }
        return thirdAppLogInfo;
    }
}

