/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.sms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.apusic.aas.util.codec.binary.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.MessageUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.sms.SMSSender;
import kd.bos.login.utils.sms.SmsConfigInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class KDSMSSender
implements SMSSender {
    public static final String CLOUDCLIENTID = "201230";
    public static final String CLOUDCLIENTSECRET = KDSMSSender.getClientSecret();
    private static Log logger = LogFactory.getLog(MessageUtils.class);
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String PHONE = "phone";
    public static final String SMSCODE = "smscode";
    public static final String CONTENT = "content";
    public static final String SIGNATURE = "signature";
    public static final String COUNTRY_CODE = "country_code";
    private static int default_connectionTimeout = 3000;
    private static int default_readTimeout = 5000;
    private static String SCHEME_HTTPS = "https";
    private static LoginCacheService loginCacheService = new LoginCacheService();

    @Override
    @Deprecated
    public boolean sendMessage(String phone, String message) {
        String signature = ResManager.loadKDString((String)"\u91d1\u8776\u4e91", (String)"KDSMSSender_0", (String)"bos-login", (Object[])new Object[0]);
        String countryCode = "86";
        return KDSMSSender.sendMessage(phone, message, signature, countryCode);
    }

    @Override
    @Deprecated
    public boolean sendMessage(String phone, String message, String signature) {
        String countryCode = "86";
        return KDSMSSender.sendMessage(phone, message, signature, countryCode);
    }

    @Override
    public boolean sendMessage(String phone, String code, String signature, Lang lang) {
        try {
            Map product;
            SmsConfigInfo smsConfigInfo = new SmsConfigInfo();
            String config = DefaultParameterService.getDefaultValueByKey("login_sms_app_config");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config)) {
                smsConfigInfo = this.wrapData((Map)JSONUtils.cast((String)config, HashMap.class));
            }
            if (MapUtils.isEmpty((Map)(product = LicenseServiceHelper.getProductInfo()))) {
                throw new Exception("productCode is null");
            }
            this.setSmsAppSecret(smsConfigInfo, product);
            this.setSignature(smsConfigInfo, lang);
            return this.sendMessageByCloudPlatform(smsConfigInfo, phone, code, signature, lang);
        }
        catch (Exception e) {
            logger.info("KDSMSSender#sendMessage", (Object)e);
            return false;
        }
    }

    private SmsConfigInfo setSmsAppSecret(SmsConfigInfo smsConfigInfo, Map<String, String> product) throws Exception {
        String prodInstCode;
        String smsAppSrtInfo = DefaultParameterService.getDefaultValueByKey("login_business_app_config");
        Map<Object, Object> smsAppSrt = new HashMap(8);
        smsAppSrt = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)smsAppSrtInfo) ? this.createSmsAppSecretByCloudPlatform(smsConfigInfo, product) : (Map)JSONUtils.cast((String)smsAppSrtInfo, HashMap.class);
        if (product != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(prodInstCode = product.get("prodInstCode"))) && !prodInstCode.equals(smsAppSrt.get("prodInstCode"))) {
            smsAppSrt = this.createSmsAppSecretByCloudPlatform(smsConfigInfo, product);
        }
        if (MapUtils.isNotEmpty(smsAppSrt)) {
            smsConfigInfo.setSmsAppStr((String)smsAppSrt.get("appSrt"));
            smsConfigInfo.setSmsAppId((String)smsAppSrt.get("appId"));
        }
        return smsConfigInfo;
    }

    @Deprecated
    public static boolean sendMessage(String phone, String message, String signature, String countryCode) {
        String smsapiurl = "https://api.kingdee.com/msgsrv/sms2";
        String clientID = CLOUDCLIENTID;
        String clientsecret = KDSMSSender.getCloudClientSecret();
        String smscode = "10725";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CLIENT_ID, clientID);
        params.put(CLIENT_SECRET, clientsecret);
        params.put(PHONE, phone);
        params.put(SMSCODE, smscode);
        params.put(CONTENT, message);
        params.put(SIGNATURE, signature);
        params.put(COUNTRY_CODE, countryCode);
        try {
            Map map;
            String returnString = KDSMSSender.post(smsapiurl, null, params);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)returnString) && (map = (Map)JSONUtils.cast((String)returnString, HashMap.class)) != null && !"0".equals(String.valueOf(map.get("errcode")))) {
                logger.info(returnString);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error("getHTMLContent error", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("getHTMLContent error", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static HttpClient wrapperHttpClient(int connectionTimeout, int readTimeout) {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(javax.security.cert.X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                public void checkServerTrusted(javax.security.cert.X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(readTimeout).setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            return closeableHttpClient;
        }
        catch (Exception ex) {
            logger.error("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25:" + ex.getMessage());
            return null;
        }
    }

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return KDSMSSender.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        URI uri;
        String portString;
        String data = "";
        HttpClient client = KDSMSSender.createHttpClient(connectionTimeout, readTimeout);
        HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"compatibility");
        HttpPost post = new HttpPost(url);
        String tenantId = RequestContext.get() != null ? RequestContext.get().getTenantId() : "";
        String host = SystemPropertyUtils.getProptyByTenant("cq.http.proxyHost", tenantId);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)host) && kd.bos.util.StringUtils.isNumericString((String)(portString = SystemPropertyUtils.getProptyByTenant("cq.http.proxyPort", tenantId)))) {
            HttpHost proxy = new HttpHost(host, Integer.parseInt(portString), "http");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setProxy(proxy).build();
            post.setConfig(defaultRequestConfig);
        }
        if (SCHEME_HTTPS.equals((uri = post.getURI()).getScheme()) && (client = KDSMSSender.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
            return data;
        }
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (String key : header.keySet()) {
                    post.setHeader(key, header.get(key));
                }
            }
            if (body != null && body.size() != 0) {
                Iterator<String> iterator = body.keySet().iterator();
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    String value = body.get(key).toString();
                    params.add(new BasicNameValuePair(key, value));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = KDSMSSender.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("kdcloud_client_secret");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)clientSecret)) {
            clientSecret = Encrypters.decode((String)clientSecret);
        }
        return clientSecret;
    }

    private static String getCloudClientSecret() {
        String clientSecret = KDSMSSender.getClientSecret();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)clientSecret)) {
            clientSecret = DefaultParameterService.getDefaultValueByKey("client_param");
        }
        return clientSecret;
    }

    private SmsConfigInfo wrapData(Map<String, Object> data) {
        SmsConfigInfo smsConfigInfo = new SmsConfigInfo();
        if (data == null) {
            return smsConfigInfo;
        }
        if (data.get("seed_app") != null) {
            smsConfigInfo.setSeedAppId(data.get("seed_app").toString());
        }
        if (data.get("seed_app_str") != null) {
            smsConfigInfo.setSeedAppStr(data.get("seed_app_str").toString());
        }
        if (data.get("login_template") != null) {
            smsConfigInfo.setSmsLoginTemplate((Map)data.get("login_template"));
        }
        if (data.get("resetpwd_template") != null) {
            smsConfigInfo.setSmsResetpwdTemplate((Map)data.get("resetpwd_template"));
        }
        if (data.get("sign_str") != null) {
            smsConfigInfo.setSignTemplate((Map)data.get("sign_str"));
        }
        if (data.get("serviceId") != null) {
            smsConfigInfo.setServiceId(data.get("serviceId").toString());
        }
        return smsConfigInfo;
    }

    private static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)v)) {
                    byte[] bytes = com.apusic.aas.util.codec.binary.StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, com.apusic.aas.util.codec.binary.StringUtils.getBytesUtf8((String)appSecret)).hmac(com.apusic.aas.util.codec.binary.StringUtils.getBytesUtf8((String)sber.toString())));
    }

    private boolean sendMessageByCloudPlatform(SmsConfigInfo smsConfigInfo, String phone, String code, String signature, Lang lang) throws Exception {
        String url = DefaultParameterService.getDefaultValueByKey("cloud_platform_sms_url");
        HashMap<String, String> header = new HashMap<String, String>(8);
        if (!KDSMSSender.checkNetWork(smsConfigInfo)) {
            header.put("x-acgw-target", KDSMSSender.getTargetUrl(url));
            url = this.getUrl();
        }
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        String timestamp = System.currentTimeMillis() + "";
        header.put("x-acgw-timestamp", timestamp);
        String nonce = StringUtils.randomWord(32);
        header.put("x-acgw-nonce", nonce);
        header.put("x-acgw-appid", smsConfigInfo.getSmsAppId());
        TreeMap<String, String> params = new TreeMap<String, String>();
        header.put("x-acgw-sign", KDSMSSender.sign(smsConfigInfo.getSmsAppStr(), timestamp, nonce, params));
        String template = smsConfigInfo.getSmsLoginTemplate().get("zh_CN");
        if (lang != null) {
            template = smsConfigInfo.getSmsLoginTemplate().get(lang.name());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template)) {
            template = smsConfigInfo.getSmsLoginTemplate().get("zh_CN");
        }
        body.put("templateId", template);
        String signId = smsConfigInfo.getSignTemplate().get("zh_CN");
        if (lang != null) {
            signId = smsConfigInfo.getSignTemplate().get(lang.name());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)signId)) {
            signId = smsConfigInfo.getSignTemplate().get("zh_CN");
        }
        body.put("signId", signId);
        String countryCode = "86";
        if (phone.contains("-")) {
            String[] phoneArray = phone.split("-");
            countryCode = phoneArray[0];
            phone = phoneArray[1];
        }
        body.put("countryCode", countryCode);
        body.put(PHONE, phone);
        HashMap<String, String> templateParams = new HashMap<String, String>(8);
        templateParams.put("code", code);
        templateParams.put("time", "5");
        body.put("templateParams", templateParams);
        String response = HttpClientUtils.postAppJson((String)(url + "/sms/service/sendSms"), header, body);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject result = JSON.parseObject((String)response);
            if (result != null && "0".equals(String.valueOf(result.get((Object)"errcode")))) {
                return true;
            }
            logger.info(response);
        }
        return false;
    }

    private Map<String, String> createSmsAppSecretByCloudPlatform(SmsConfigInfo smsConfigInfo, Map<String, String> product) throws Exception {
        String createAppId = loginCacheService.get("x-acgw-create-appid");
        HashMap<String, String> smsAppSrt = new HashMap(8);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)createAppId)) {
            Map result;
            String url = DefaultParameterService.getDefaultValueByKey("cloud_platform_mcapi_url");
            HashMap<String, String> header = new HashMap<String, String>(8);
            if (!KDSMSSender.checkNetWork(smsConfigInfo)) {
                header.put("x-acgw-target", KDSMSSender.getTargetUrl(url));
                url = this.getUrl();
            }
            Map<Object, Object> body = new HashMap(8);
            String timestamp = System.currentTimeMillis() + "";
            header.put("x-acgw-timestamp", timestamp);
            String nonce = StringUtils.randomWord(32);
            header.put("x-acgw-nonce", nonce);
            header.put("x-acgw-appid", smsConfigInfo.getSeedAppId());
            TreeMap<String, String> params = new TreeMap<String, String>();
            header.put("x-acgw-sign", KDSMSSender.sign(smsConfigInfo.getSeedAppStr(), timestamp, nonce, params));
            body = this.getBody(smsConfigInfo, product);
            String response = HttpClientUtils.postAppJson((String)(url + "/seedapi/seedService/createApp"), header, body);
            logger.info(response);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response) && (result = (Map)JSONUtils.cast((String)response, HashMap.class)) != null && "0".equals(String.valueOf(result.get("errcode")))) {
                result = (Map)result.get("data");
                createAppId = result.get("id") + "";
                loginCacheService.put("x-acgw-create-appid", createAppId, 600);
                Thread.sleep(5000L);
            }
        }
        smsAppSrt = this.getSmsAppSecretByCloudPlatform(smsConfigInfo, createAppId, product);
        return smsAppSrt;
    }

    private Map<String, String> getSmsAppSecretByCloudPlatform(SmsConfigInfo smsConfigInfo, String createAppId, Map<String, String> product) throws Exception {
        JSONObject json;
        Map<String, String> smsAppSrt = new HashMap<String, String>(8);
        String url = DefaultParameterService.getDefaultValueByKey("cloud_platform_mcapi_url");
        HashMap<String, String> header = new HashMap<String, String>(8);
        if (!KDSMSSender.checkNetWork(smsConfigInfo)) {
            header.put("x-acgw-target", KDSMSSender.getTargetUrl(url));
            url = this.getUrl();
        }
        HashMap<String, String> body = new HashMap<String, String>(8);
        String timestamp = System.currentTimeMillis() + "";
        header.put("x-acgw-timestamp", timestamp);
        String nonce = StringUtils.randomWord(32);
        header.put("x-acgw-nonce", nonce);
        header.put("x-acgw-appid", smsConfigInfo.getSeedAppId());
        TreeMap<String, String> params = new TreeMap<String, String>();
        header.put("x-acgw-sign", KDSMSSender.sign(smsConfigInfo.getSeedAppStr(), timestamp, nonce, params));
        body.put("id", createAppId);
        String response = HttpClientUtils.postAppJson((String)(url + "/seedapi/seedService/getApp"), header, body);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response) && "0".equals((json = JSON.parseObject((String)response)).getString("errcode"))) {
            JSONArray array = json.getJSONArray("data");
            json = array.getJSONObject(0).getJSONObject("appInfo");
            json.put("appSrt", (Object)KDSMSSender.decryptGCM(smsConfigInfo.getSeedAppStr(), json.getString("secret")));
            if (product != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)product.get("prodInstCode"))) {
                json.put("prodInstCode", (Object)product.get("prodInstCode"));
            }
            json.remove((Object)"secret");
            Account currentCenter = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
            DefaultParameterService.updateDefaultParamsConfig(currentCenter, "login_business_app_config", json.toJSONString());
            smsAppSrt = (Map)JSONUtils.cast((String)json.toJSONString(), HashMap.class);
        }
        return smsAppSrt;
    }

    private Map<String, Object> getBody(SmsConfigInfo smsConfigInfo, Map<String, String> product) {
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("prodLine", "cosmic");
        ArrayList list = new ArrayList(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("serviceId", smsConfigInfo.getServiceId());
        HashMap<String, String> param = new HashMap<String, String>(8);
        param.put("code", product.get("productNo"));
        param.put("swCode", product.get("softwareCode"));
        param.put("instanceCode", product.get("prodInstCode"));
        map.put("prodInfo", param);
        list.add(map);
        body.put("prodList", list);
        return body;
    }

    private void setSignature(SmsConfigInfo smsConfigInfo, Lang lang) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bos_sms_signature", (String)"id,locale.number,name,signid", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"1")});
        Map<String, String> map = smsConfigInfo.getSignTemplate();
        for (DynamicObject data : array) {
            Object locale = data.get("locale.number");
            if (locale == null) continue;
            if (!locale.equals(lang.get().name())) continue;
            map.put(lang.get().name(), data.getString("signid"));
        }
        if (MapUtils.isNotEmpty(map)) {
            smsConfigInfo.setSignTemplate(map);
        }
    }

    private static String decryptGCM(String key, String ciphertext) throws Exception {
        byte[] str = java.util.Base64.getDecoder().decode(ciphertext);
        byte[] iv = new byte[16];
        byte[] content = new byte[str.length - iv.length];
        System.arraycopy(str, 0, iv, 0, iv.length);
        System.arraycopy(str, iv.length, content, 0, content.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec a = new SecretKeySpec(key.getBytes(), "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)a, spec);
        return new String(cipher.doFinal(content), "utf-8");
    }

    private String getUrl() {
        String url = System.getProperty("url");
        try {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)url)) {
                url = "https://api.kingdee.com";
            }
            if (!StringUtils.isEmpty(url) && url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return url;
    }

    private static boolean checkNetWork(SmsConfigInfo smsConfigInfo) throws IOException {
        String url = DefaultParameterService.getDefaultValueByKey("cloud_platform_mcapi_url");
        String flag = loginCacheService.get("cloud_platform_checkNetWork");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)flag)) {
            return Boolean.parseBoolean(flag);
        }
        HashMap<String, String> header = new HashMap<String, String>(8);
        HashMap<String, String> body = new HashMap<String, String>(8);
        String timestamp = System.currentTimeMillis() + "";
        header.put("x-acgw-timestamp", timestamp);
        String nonce = StringUtils.randomWord(32);
        header.put("x-acgw-nonce", nonce);
        header.put("x-acgw-appid", smsConfigInfo.getSeedAppId());
        TreeMap<String, String> params = new TreeMap<String, String>();
        header.put("x-acgw-sign", KDSMSSender.sign(smsConfigInfo.getSeedAppStr(), timestamp, nonce, params));
        body.put("id", "67576678979");
        try {
            String response = HttpClientUtils.postAppJson((String)(url + "/seedapi/seedService/getApp"), header, body);
            flag = "true";
        }
        catch (Exception e) {
            flag = "false";
        }
        loginCacheService.put("cloud_platform_checkNetWork", flag, 3600);
        return Boolean.parseBoolean(flag);
    }

    private static String getTargetUrl(String url) {
        String value = url;
        try {
            int length = "https://".length();
            value = value.substring(length, value.length());
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return value;
    }
}

