/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ssl.KDTrustmanager;

public class KDSSLSocketFactory
extends SSLSocketFactory {
    private static Log logger = LogFactory.getLog(KDSSLSocketFactory.class);
    private final SSLContext sslContext;
    private final SSLSocketFactory socketFactory;

    public KDSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        KDTrustmanager trustmanager = new KDTrustmanager();
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(null, new TrustManager[]{trustmanager}, new SecureRandom());
        this.socketFactory = this.sslContext.getSocketFactory();
    }

    public static SocketFactory getDefault() {
        try {
            return new KDSSLSocketFactory();
        }
        catch (KeyManagementException e) {
            logger.error((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }
}

