/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class YunzhijiaUtils {
    private static final String YUN_ZHI_JIA_CREATE_GROUP_URL = "YunZhiJiaCreateGroupURL";
    private static final String USER_NAME = "userName";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String GROUP_ID = "groupId";
    private static final String CURRENT_UID = "currentUid";
    private static final String SUCCESS = "success";
    private static final String CREATED = "created";
    private static final String USER_IDS = "userIds";
    private static final String GROUP_NAME = "groupName";
    private static Log logger = LogFactory.getLog(YunzhijiaUtils.class);
    private static String YUNZHIJIA_HOST = "";
    public static final String IMSDK_TICKET_GET = "/imsdk/getTicket.do";
    public static final String IMSDK_GROUP_GET = "/imsdk/group/list.do";
    public static String IMSDK_GROUP_CREATE = "/imsdk/open/group/create.do";
    public static final String IMSDK_GROUP_ADDUSER = "/imsdk/open/group/addUser.do";
    private static final String API_GROUP_CREATE = "/gateway/xtinterface/group/createGroup?accessToken=";
    private static final String API_THEME_URL = "/gateway/xtinterface/banner/create?accessToken=";
    private static final String API_GROUP_USERS = "/gateway/xtinterface/group/groupUsers?accessToken=";
    private static final String API_GROUP_ADD_USERS = "/gateway/xtinterface/group/addGroupUser?accessToken=";
    private static final String API_TOKEN_URL = "/gateway/oauth2/token/getAccessToken";
    private static final String CACHE_OUTER_KEY = "app.83bfebc8000037ac";
    private static final String LOCAL_CACHE_APP_INNER_KEY = "151000000";
    private static final String REDIS_CACHE_APP_INNER_KEY = "15.100000.0";
    private static final String ROOT_CACHE_FORMAT_KEY = "%s.SYSTEM_PARAMETER";
    private static final String LOCAL_CACHE_REGION = "PARAMETER";

    public Map<String, Object> getImGroupIdByOpenIds(Map<String, String> user, List<Map<String, String>> chatUsers) {
        String currUserOpenId;
        logger.info("@Yunzhijiachat:\u5f00\u59cb\u8c03\u7528getImGroupIdByOpenIds\u3002");
        if (chatUsers == null || chatUsers.isEmpty()) {
            return Collections.emptyMap();
        }
        String businessKey = kd.bos.util.StringUtils.getEmpty();
        Boolean assignGroupOwner = Boolean.TRUE;
        HashSet<Object> userNames = new HashSet<Object>(16);
        ArrayList<String> openIds = new ArrayList<String>(10);
        for (Map<String, String> mp : chatUsers) {
            List<String> ids = Arrays.asList(StringUtils.split((String)mp.get("openId"), (char)','));
            openIds.addAll(ids);
            userNames.add(mp.get(USER_NAME));
            businessKey = mp.get("businessKey");
            assignGroupOwner = Boolean.parseBoolean(mp.get("assignGroupOwner"));
        }
        String tenantId = RequestContext.get().getTenantId();
        String erpCachedGroupType = this.getErpCachedGroupType(tenantId, currUserOpenId = RequestContext.get().getUserOpenId(), openIds, businessKey, assignGroupOwner);
        Map cachedErpChatGroup = CacheLoginData.getCache((String)erpCachedGroupType);
        if (cachedErpChatGroup == null || cachedErpChatGroup.size() == 0) {
            logger.info("@Yunzhijiachat:\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa...");
            return this.createYzjChatGroup(openIds, userNames, erpCachedGroupType, user);
        }
        logger.info("@Yunzhijiachat:\u6210\u529f\u4ece\u4e91ERP\u7f13\u5b58\u4e2d\u83b7\u53d6\u7fa4\u7ec4\u3002");
        return this.checkGroupValidity(user, userNames, openIds, erpCachedGroupType, cachedErpChatGroup);
    }

    public void setYzjChatGroupTheme(String groupId, Map<String, Object> params) {
        Object businessType = params.get("businessType");
        if ("wf".equals(String.valueOf(businessType)) && "true".equals(CacheLoginData.getAttribute((String)(RequestContext.get().getAccountId() + "_YzjChatGroupTheme_"), (String)groupId))) {
            return;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(CONTENT_TYPE, APPLICATION_JSON);
        String accessToken = this.getAccessToken();
        if (kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            return;
        }
        HashMap<String, Object> executeParams = new HashMap<String, Object>(3);
        executeParams.put(GROUP_ID, groupId);
        executeParams.put(CURRENT_UID, RequestContext.get().getUserOpenId());
        ThemeParam param = new ThemeParam(params);
        executeParams.put("params", param);
        String themeUrl = YUNZHIJIA_HOST + API_THEME_URL + accessToken;
        try {
            logger.info(JSON.toJSONString(executeParams));
            String themeResp = HttpClientUtils.postjson((String)themeUrl, header, (String)JSON.toJSONString(executeParams));
            if (kd.bos.util.StringUtils.isEmpty((String)themeResp)) {
                logger.error("\u6dfb\u52a0\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u4e3b\u9898\u5931\u8d25.");
                return;
            }
            JSONObject respJson = JSON.parseObject((String)themeResp);
            if (!respJson.getBoolean(SUCCESS).booleanValue()) {
                logger.error("\u6dfb\u52a0\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u4e3b\u9898\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + respJson.getString("error"));
                return;
            }
            CacheLoginData.setAttribute((String)(RequestContext.get().getAccountId() + "_YzjChatGroupTheme_"), (String)groupId, (String)"true", (int)604800);
        }
        catch (IOException e) {
            logger.error("\u8bbe\u7f6e\u4e91\u4e4b\u5bb6\u804a\u5929\u7fa4\u7ec4\u4e3b\u9898\u5931\u8d25,\u63a5\u53e3\u5730\u5740\u4e3a\u3010" + themeUrl + "\u3011\uff0c\u7fa4\u7ec4id\u4e3a\u3010" + groupId + "\u3011.", (Throwable)e);
        }
    }

    private Map<String, Object> checkGroupValidity(Map<String, String> user, Set<Object> userNames, List<String> openIds, String erpCachedGroupType, Map<String, String> cachedErpChatGroup) {
        String accessToken = this.getAccessToken();
        if (kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            logger.error("@checkGroupValidity\uff1a\u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6token\u4e3a\u7a7a...");
            return Collections.emptyMap();
        }
        String groupId = cachedErpChatGroup.get(GROUP_ID);
        List<String> members = this.getGroupMembers(accessToken, groupId);
        if (null == members || members.isEmpty()) {
            logger.info("\u7fa4\u7ec4\u5df2\u7ecf\u89e3\u6563\uff0c\u91cd\u65b0\u521b\u5efa\u3002");
            return this.createYzjChatGroup(accessToken, openIds, userNames, erpCachedGroupType, user);
        }
        HashMap<String, Object> groupInfo = new HashMap<String, Object>(2);
        groupInfo.put(GROUP_ID, groupId);
        groupInfo.put(CREATED, false);
        List<String> notExistMembers = this.getNotExistMembers(members, user, openIds);
        if (notExistMembers.isEmpty()) {
            logger.info("\u65e0\u65b0\u6210\u5458\u52a0\u5165\uff0c\u76f4\u63a5\u8fd4\u56de\u5f53\u524d\u7fa4\u7ec4\u4fe1\u606f.");
            return groupInfo;
        }
        try {
            logger.info("\u6709\u7fa4\u6210\u5458\u9000\u51fa\u7fa4\u7ec4\u6216\u8005\u6709\u65b0\u6210\u5458\u52a0\u5165\uff0c\u9700\u8981\u91cd\u65b0\u6dfb\u52a0\u6210\u5458\u3002");
            this.addNewMemberToGroup(accessToken, groupId, notExistMembers, members.get(0));
            return groupInfo;
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u65b0\u6210\u5458\u5931\u8d25\uff0c\u6210\u5458id\u4e3a\u3010" + JSON.toJSONString(members) + "\u3011\uff0c\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u3010" + JSON.toJSONString(user) + "\u3011\uff0c\u7fa4\u7ec4id\u4e3a\uff1a" + groupId + "\uff0c\u91cd\u5efa\u7fa4\u7ec4...", (Throwable)e);
            return this.createYzjChatGroup(accessToken, openIds, userNames, erpCachedGroupType, user);
        }
    }

    private void addNewMemberToGroup(String accessToken, String groupId, List<String> members, String memberId) {
        try {
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put(CURRENT_UID, memberId);
            params.put(GROUP_ID, groupId);
            params.put(USER_IDS, members);
            String addUsersUrl = YUNZHIJIA_HOST + API_GROUP_ADD_USERS + accessToken;
            String result = HttpClientUtils.postjson((String)addUsersUrl, header, (String)JSON.toJSONString(params));
            JSONObject json = JSON.parseObject((String)result);
            if (!json.getBoolean(SUCCESS).booleanValue()) {
                throw new Exception("addNewMemberToGroup fail,\u3010" + json.getString("error") + "\u3011");
            }
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }

    private List<String> getNotExistMembers(List<String> memberArr, Map<String, String> user, List<String> openIds) {
        ArrayList<String> ids = new ArrayList<String>(openIds);
        String curUserOpenId = user.get("userOpenId");
        ids.add(curUserOpenId);
        ArrayList<String> notExistMembers = new ArrayList<String>(ids.size());
        for (String openId : ids) {
            if (memberArr.contains(openId)) continue;
            notExistMembers.add(openId);
        }
        return notExistMembers;
    }

    private List<String> getGroupMembers(String accessToken, String groupId) {
        HashMap<String, String> executeParams = new HashMap<String, String>(3);
        executeParams.put(GROUP_ID, groupId);
        executeParams.put(CURRENT_UID, RequestContext.get().getUserOpenId());
        String groupUsersUrl = YUNZHIJIA_HOST + API_GROUP_USERS + accessToken;
        try {
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            String result = HttpClientUtils.postjson((String)groupUsersUrl, header, (String)JSON.toJSONString(executeParams));
            JSONObject json = JSON.parseObject((String)result);
            if (json.getBoolean(SUCCESS).booleanValue()) {
                JSONObject data = json.getJSONObject("data");
                if (null == data) {
                    return Collections.emptyList();
                }
                JSONArray members = data.getJSONArray("participantIds");
                return JSON.parseArray((String)JSON.toJSONString((Object)members), String.class);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7fa4\u7ec4\u5931\u8d25\uff0c\u7fa4\u7ec4id\u4e3a\u3010" + groupId + "\u3011,\u9ed8\u8ba4\u5f53\u6210\u5df2\u7ecf\u89e3\u6563\u5904\u7406,\u9700\u8981\u91cd\u65b0\u521b\u5efa\u7fa4\u7ec4...", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Map<String, Object> createYzjChatGroup(List<String> openIds, Set<Object> userNames, String erpCachedGroupType, Map<String, String> user) {
        String accessToken = this.getAccessToken();
        if (kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            logger.error("\u521b\u5efa\u7fa4\u7ec4\u65f6\u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6token\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa...");
            return Collections.emptyMap();
        }
        return this.createYzjChatGroup(accessToken, openIds, userNames, erpCachedGroupType, user);
    }

    private Map<String, Object> createYzjChatGroup(String accessToken, List<String> openIds, Set<Object> userNames, String erpCachedGroupType, Map<String, String> user) {
        String createGroupUrl = YUNZHIJIA_HOST + API_GROUP_CREATE + accessToken;
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(CURRENT_UID, RequestContext.get().getUserOpenId());
        params.put(USER_IDS, openIds);
        if (user != null && user.size() > 0 && user.get(GROUP_NAME) != null) {
            params.put(GROUP_NAME, user.get(GROUP_NAME));
        } else {
            String groupName = StringUtils.join((Object[])userNames.toArray(), (String)",");
            if (kd.bos.util.StringUtils.isNotEmpty((String)groupName)) {
                params.put(GROUP_NAME, groupName);
            }
        }
        HashMap<String, Object> groupInfo = new HashMap<String, Object>(2);
        try {
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            String result = HttpClientUtils.postjson((String)createGroupUrl, header, (String)JSON.toJSONString(params));
            JSONObject json = JSON.parseObject((String)result);
            JSONObject data = json.getJSONObject("data");
            if (json.getBoolean(SUCCESS).booleanValue() && null != data) {
                String groupId = data.getString(GROUP_ID);
                if (kd.bos.util.StringUtils.isNotEmpty((String)groupId)) {
                    logger.info("@Yunzhijiachat:\u6210\u529f\u5728\u4e91\u4e4b\u5bb6\u4e2d\u521b\u5efa\u7fa4\u7ec4\u3002");
                    HashMap<String, String> mp = new HashMap<String, String>(1);
                    mp.put(GROUP_ID, groupId);
                    CacheLoginData.setAttributes((String)erpCachedGroupType, mp);
                    groupInfo.put(CREATED, true);
                    groupInfo.put(GROUP_ID, groupId);
                } else {
                    logger.error("@Yunzhijiachat:\u5728\u4e91\u4e4b\u5bb6\u4e2d\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25\u63a5\u53e3\u8def\u5f84\u4e3a\u3010%s\u3011,\u8bf7\u6c42\u53c2\u6570\u4e3a\u3010%s\u3011", createGroupUrl, JSON.toJSONString(params)), (Throwable)e);
        }
        return groupInfo;
    }

    private String getErpCachedGroupType(String tenantId, String curUserId, List<String> openIds, String businessKey, Boolean assignGroupOwner) {
        ArrayList<String> ids = new ArrayList<String>(openIds);
        ids.add(curUserId);
        Collections.sort(ids);
        String groupKey = StringUtils.join((Object[])ids.toArray(), (String)",");
        return CacheLoginData.getType4ImsdkGroup((String)tenantId, (String)curUserId, (String)groupKey, (String)businessKey, (Boolean)assignGroupOwner);
    }

    private String getAccessToken() {
        String tokenUrl = YUNZHIJIA_HOST + API_TOKEN_URL;
        TokenParam tokenParam = null;
        try {
            tokenParam = this.getTokenParam();
            HashMap<String, String> header = new HashMap<String, String>(1);
            header.put(CONTENT_TYPE, APPLICATION_JSON);
            String tokenResp = HttpClientUtils.postjson((String)tokenUrl, header, (String)JSONUtils.toString((Object)tokenParam));
            if (kd.bos.util.StringUtils.isEmpty((String)tokenResp)) {
                logger.error("\u6dfb\u52a0\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u4e3b\u9898\u65f6\u83b7\u53d6token\u4fe1\u606f\u8fd4\u56de\u503c\u4e3a\u7a7a");
                return kd.bos.util.StringUtils.getEmpty();
            }
            JSONObject tokenJson = JSON.parseObject((String)tokenResp);
            JSONObject data = tokenJson.getJSONObject("data");
            if (!tokenJson.getBoolean(SUCCESS).booleanValue() || null == data) {
                logger.error("\u6dfb\u52a0\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u4e3b\u9898\u65f6\u65e0\u6cd5\u83b7\u53d6token\u4fe1\u606f");
                return kd.bos.util.StringUtils.getEmpty();
            }
            return data.getString("accessToken");
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u83b7\u53d6token\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u3010" + tokenUrl + "\u3011,\u53c2\u6570\u4fe1\u606f\u4e3a\u3010" + tokenParam.getEid() + "\u3011,", (Throwable)e);
            return kd.bos.util.StringUtils.getEmpty();
        }
    }

    private TokenParam getTokenParam() {
        JSONObject systemParam = YunzhijiaUtils.getSystemParam();
        if (Objects.isNull(systemParam)) {
            throw new IllegalArgumentException("eid or imsecret is not config");
        }
        String eid = systemParam.getString("eid");
        String secret = systemParam.getString("imservicekey");
        return new TokenParam(secret, eid);
    }

    private static JSONObject getSystemParam() {
        Map mapParameter = new HashMap(8);
        if (RequestContext.get() != null && kd.bos.util.StringUtils.isNotEmpty((String)RequestContext.get().getAccountId())) {
            AppParam appParam = new AppParam();
            appParam.setAppId("83bfebc8000037ac");
            appParam.setOrgId(Long.valueOf(ParameterOrgUtils.getParamRootOrgId()));
            mapParameter = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        }
        if (!ObjectUtils.isEmpty(mapParameter)) {
            try {
                return YunzhijiaUtils.getSystemParam(JSONUtils.toString(mapParameter));
            }
            catch (Exception e) {
                logger.info("getSystemParamFromDB", (Object)e);
            }
        }
        logger.info("getSystemParamFromDB from db");
        return YunzhijiaUtils.getSystemParamFromDB();
    }

    private static JSONObject getSystemParamFromLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, "SYSTEM_PARAMETER", info);
        Object cacheData = localCache.get(CACHE_OUTER_KEY);
        if (Objects.isNull(cacheData)) {
            return null;
        }
        Object cache = ((Map)cacheData).get(LOCAL_CACHE_APP_INNER_KEY);
        if (Objects.isNull(cache)) {
            return null;
        }
        return YunzhijiaUtils.getSystemParam(JSON.toJSONString(cache));
    }

    private static JSONObject getSystemParamFromRedisCache(String acctId) {
        String rootCacheKey = String.format(ROOT_CACHE_FORMAT_KEY, acctId);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(LOCAL_CACHE_REGION, new DistributeCacheHAPolicy(true, true));
        String cacheData = (String)redisCache.get(rootCacheKey, CACHE_OUTER_KEY);
        if (kd.bos.util.StringUtils.isEmpty((String)cacheData)) {
            return null;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(cacheData = JSON.parseObject((String)cacheData).getString(REDIS_CACHE_APP_INNER_KEY)))) {
            return null;
        }
        return YunzhijiaUtils.getSystemParam(cacheData);
    }

    private static JSONObject getSystemParamFromDB() {
        String sql = "SELECT p.fdata FROM t_bas_sysparameter p JOIN t_bas_sysparaconsole c ON p.FPARAMID = c.FID WHERE  p.FVIEWTYPEID = '15' and p.FSUBSYSTEM = 'application/SYS/base' and c.FFORMID = 'bos_base_parameter'";
        String selectResult = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, resultSet -> {
            String result = kd.bos.util.StringUtils.getEmpty();
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
            return result;
        });
        return YunzhijiaUtils.getSystemParam(selectResult);
    }

    private static JSONObject getSystemParam(String config) {
        JSONObject json = JSON.parseObject((String)config);
        String eid = json.getString("eid");
        String secret = json.getString("imservicekey");
        String yzjKey = YunzhijiaUtils.getIntegratedKey(json);
        if (kd.bos.util.StringUtils.isEmpty((String)eid) || kd.bos.util.StringUtils.isEmpty((String)yzjKey) || kd.bos.util.StringUtils.isEmpty((String)secret)) {
            return null;
        }
        return json;
    }

    public Map<String, Object> getImGroupIdByOpenIds(List<Map<String, String>> chatUsers) {
        logger.info("@Yunzhijiachat:\u5f00\u59cb\u8c03\u7528getImGroupIdByOpenIds\u3002");
        HashMap<String, Object> groupInfo = new HashMap<String, Object>(2);
        if (chatUsers == null || chatUsers.size() == 0) {
            return groupInfo;
        }
        logger.info("@Yunzhijiachat:\u51c6\u5907\u83b7\u53d6tenantId");
        String tenantId = RequestContext.get().getTenantId();
        logger.info("@Yunzhijiachat:\u83b7\u53d6tenantId=" + tenantId);
        String curUserId = RequestContext.get().getUserId();
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserId=" + curUserId);
        String curUserName = RequestContext.get().getUserName();
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserName=" + curUserName);
        String curUserOpenId = RequestContext.get().getUserOpenId();
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserOpenId=" + curUserOpenId);
        logger.info("@Yunzhijiachat:\u5f00\u59cb\u83b7\u53d6ticket");
        String imsdkTicket = this.getImsdkTicket(tenantId, curUserId, curUserOpenId);
        logger.info("@Yunzhijiachat:\u83b7\u53d6imsdkTicket=" + imsdkTicket);
        if (kd.bos.util.StringUtils.isEmpty((String)imsdkTicket)) {
            logger.warn("@Yunzhijiachat:\u65e0\u6cd5\u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6imsdk\u7684ticket\u3002");
            return groupInfo;
        }
        logger.info("@Yunzhijiachat:\u6210\u529f\u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6imsdk\u7684ticket\u3002");
        ArrayList<String> openIds = new ArrayList<String>(10);
        HashSet<Object> userNames = new HashSet<Object>(16);
        String businessKey = kd.bos.util.StringUtils.getEmpty();
        Boolean assignGroupOwner = Boolean.TRUE;
        for (Map<String, String> mp : chatUsers) {
            openIds.add(mp.get("openId"));
            userNames.add(mp.get(USER_NAME));
            businessKey = mp.get("businessKey");
            assignGroupOwner = Boolean.parseBoolean(mp.get("assignGroupOwner"));
        }
        String erpCachedGroupType = this.getErpCachedGroupType(tenantId, curUserId, openIds, businessKey, assignGroupOwner);
        Map cachedErpChatGroup = CacheLoginData.getCache((String)erpCachedGroupType);
        if (cachedErpChatGroup == null || cachedErpChatGroup.size() == 0) {
            String destGroupId = "";
            try {
                destGroupId = this.createYzjChatGroup(imsdkTicket, openIds, userNames);
            }
            catch (Exception e) {
                logger.error("@Yunzhijiachat:\u5728\u4e91\u4e4b\u5bb6\u4e2d\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25\u3002");
            }
            if (!kd.bos.util.StringUtils.isEmpty((String)destGroupId)) {
                logger.info("@Yunzhijiachat:\u6210\u529f\u5728\u4e91\u4e4b\u5bb6\u4e2d\u521b\u5efa\u7fa4\u7ec4\u3002");
                HashMap<String, String> mp = new HashMap<String, String>(1);
                mp.put(GROUP_ID, destGroupId);
                CacheLoginData.setAttributes((String)erpCachedGroupType, mp);
                groupInfo.put(GROUP_ID, destGroupId);
                groupInfo.put(CREATED, true);
            } else {
                logger.warn("@Yunzhijiachat:\u5728\u4e91\u4e4b\u5bb6\u4e2d\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25\uff0c\u8be6\u7ec6\uff1a" + destGroupId);
            }
        } else {
            logger.info("@Yunzhijiachat:\u6210\u529f\u4ece\u4e91ERP\u7f13\u5b58\u4e2d\u83b7\u53d6\u7fa4\u7ec4\u3002");
            groupInfo.put(GROUP_ID, cachedErpChatGroup.get(GROUP_ID));
            groupInfo.put(CREATED, false);
        }
        logger.info("@Yunzhijiachat:\u5b8c\u6210\u8c03\u7528getImGroupIdByOpenIds\u3002");
        return groupInfo;
    }

    public String getImsdkTicket(String tenantId, String userId, String openId) {
        String url = YUNZHIJIA_HOST + IMSDK_TICKET_GET;
        try {
            Map mpTicket;
            String ctEkey = CacheLoginData.getType4UserImsdkKeyData((String)tenantId, (String)userId);
            logger.info("@getImsdkTicket:\u83b7\u53d6ctEkey=" + ctEkey);
            Map mpEkey = CacheLoginData.getCache((String)ctEkey);
            logger.info("@getImsdkTicket:\u83b7\u53d6mpEkey\u5b8c\u6210=" + mpEkey);
            if (mpEkey == null || mpEkey.size() == 0 || !mpEkey.containsKey("Eid")) {
                logger.info("@getImsdkTicket:\u91cd\u65b0\u751f\u6210rebuildIMSDKKey" + mpEkey);
                YunzhijiaUtils.rebuildIMSDKKey(tenantId, userId, openId);
                mpEkey = CacheLoginData.getCache((String)ctEkey);
            }
            HashMap para = new HashMap(2);
            para.put("eid", mpEkey.get("Eid"));
            para.put("data", mpEkey.get("KeyData"));
            logger.info("@getImsdkTicket:\u5f00\u59cb\u83b7\u53d6UserKeyData" + (String)mpEkey.get("UserKeyData"));
            logger.info("@getImsdkTicket:\u5f00\u59cb\u83b7\u53d6sTicket");
            String sTicket = HttpClientUtils.get((String)url, para);
            logger.info("@getImsdkTicket:\u83b7\u53d6sTicket=" + sTicket);
            if (kd.bos.util.StringUtils.isNotEmpty((String)sTicket) && (mpTicket = (Map)JSONUtils.cast((String)sTicket, HashMap.class)) != null && ((Boolean)mpTicket.get(SUCCESS)).booleanValue()) {
                return mpTicket.get("data").toString();
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return kd.bos.util.StringUtils.getEmpty();
    }

    private String createYzjChatGroup(String imsdkTicket, List<String> openIds, Set<Object> userNames) throws Exception {
        String sNewGroupName = StringUtils.join((Object[])userNames.toArray(), (String)",");
        return YunzhijiaUtils.createYzjChatGroup(imsdkTicket, openIds, sNewGroupName);
    }

    private static String createYzjChatGroup(String imsdkTicket, List<String> openIds, String groupName) {
        String groupId = "";
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_JSON);
        HashMap<String, Object> mpJson = new HashMap<String, Object>(3);
        mpJson.put(USER_IDS, openIds);
        mpJson.put(GROUP_NAME, groupName);
        if (openIds.size() == 1) {
            mpJson.put("forceMultiGroup", true);
        }
        try {
            String jsonPara = JSONUtils.toString(mpJson);
            if (System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL) != null && System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL).trim().length() > 0) {
                IMSDK_GROUP_CREATE = System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL);
            }
            String url = YUNZHIJIA_HOST + IMSDK_GROUP_CREATE + "?ticket=" + imsdkTicket;
            logger.info("create group url : " + url);
            logger.info("params: " + jsonPara);
            String newGroup = HttpClientUtils.postjson((String)url, mpHeader, (String)jsonPara);
            logger.info("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c: " + newGroup);
            if (kd.bos.util.StringUtils.isEmpty((String)newGroup)) {
                logger.error(jsonPara + "\uff1a\u521b\u5efa\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u5931\u8d25\uff1a\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
                return groupId;
            }
            Map data = (Map)JSONUtils.cast((String)newGroup, HashMap.class);
            if (data != null && ((Boolean)data.get(SUCCESS)).booleanValue() && data.get("data") != null) {
                Map dest = (Map)data.get("data");
                groupId = dest.get(GROUP_ID).toString();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u521b\u5efa\u4e91\u4e4b\u5bb6\u804a\u5929\u7ec4\u5931\u8d25\u3002%s", (String)"YunzhijiaUtils_0", (String)"bos-login", (Object[])new Object[]{e.getMessage()})});
        }
        return groupId;
    }

    public Boolean addUserToChatGroup(Map<String, String> user, List<String> openIds, String groupId) {
        String imsdkTicket = this.getImSdkTicket(user);
        HashMap<String, String> mpHeader = new HashMap<String, String>(1);
        mpHeader.put(CONTENT_TYPE, APPLICATION_JSON);
        HashMap<String, Object> mpJson = new HashMap<String, Object>(2);
        mpJson.put(USER_IDS, openIds);
        mpJson.put(GROUP_ID, groupId);
        try {
            String jsonPara = JSONUtils.toString(mpJson);
            logger.info("@addUserToChatGroup:\u5f00\u59cb\u6dfb\u52a0\u65b0\u6210\u5458\u5230\u7fa4\u7ec4\u4e2d");
            String result = HttpClientUtils.postjson((String)(YUNZHIJIA_HOST + IMSDK_GROUP_ADDUSER + "?ticket=" + imsdkTicket), mpHeader, (String)jsonPara);
            JSONObject json = JSON.parseObject((String)result);
            if (null != json && json.getBoolean(SUCCESS).booleanValue()) {
                return json.get((Object)"data") != null;
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458\u5230\u804a\u5929\u7fa4\u7ec4\u5931\u8d25\u3002%s", (String)"YunzhijiaUtils_1", (String)"bos-login", (Object[])new Object[]{e.getMessage()})});
        }
        return false;
    }

    private String getImSdkTicket(Map<String, String> user) {
        logger.info("@Yunzhijiachat:\u51c6\u5907\u83b7\u53d6tenantId");
        String tenantId = user.get("tenantId");
        logger.info("@Yunzhijiachat:\u83b7\u53d6tenantId=" + tenantId);
        String curUserId = user.get("userId");
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserId=" + curUserId);
        String curUserName = user.get(USER_NAME);
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserName=" + curUserName);
        String curUserOpenid = user.get("userOpenId");
        logger.info("@Yunzhijiachat:\u83b7\u53d6curUserOpenid=" + curUserOpenid);
        logger.info("@Yunzhijiachat:\u5f00\u59cb\u83b7\u53d6Ticket");
        return this.getImsdkTicket(tenantId, curUserId, curUserOpenid);
    }

    public static void rebuildIMSDKKey(String tenantId, String userId, String openId) {
        String sKeyData = kd.bos.util.StringUtils.getEmpty();
        String sEid = kd.bos.util.StringUtils.getEmpty();
        JSONObject systemParam = YunzhijiaUtils.getSystemParam();
        if (!Objects.isNull(systemParam)) {
            sEid = systemParam.getString("eid");
            sKeyData = YunzhijiaUtils.getIntegratedKey(systemParam);
        }
        byte[] keyByte = Base64.decodeBase64((String)sKeyData);
        String sIMSdkKey = "";
        PrivateKey privateKey = null;
        String sYzjPara = String.format("{\"privatevalue\":%s,\"flag\":\"0\",\"bizNo\":\"NEXTCLOUDERP\"}", openId);
        try {
            privateKey = EncryptUtils.restorePrivateKey((byte[])keyByte);
            sIMSdkKey = EncryptUtils.encryptWithEncodeBase64UTF8((String)sYzjPara, (Key)privateKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7528\u79df\u6237\u7684KeyFile\u5931\u8d25\uff0c\u5bfc\u81f4\u65e0\u6cd5\u65e0\u6cd5\u8c03\u7528\u4e91\u4e4b\u5bb6\u5373\u65f6\u901a\u8baf\u7ec4\u4ef6\u3002");
            return;
        }
        HashMap<String, String> mpKey = new HashMap<String, String>();
        mpKey.put("Eid", sEid);
        mpKey.put("KeyData", sIMSdkKey);
        String ctKeyData = CacheLoginData.getType4UserImsdkKeyData((String)tenantId, (String)userId);
        CacheLoginData.setAttributes((String)ctKeyData, mpKey);
    }

    private static String getIntegratedKey(JSONObject systemParam) {
        String yzjKey = systemParam.getString("yzjkey");
        if (kd.bos.util.StringUtils.isEmpty((String)yzjKey)) {
            yzjKey = systemParam.getString("yzjsecret");
        }
        return yzjKey;
    }

    static {
        YUNZHIJIA_HOST = System.getProperty("YunZhiJiaAppHost");
        if (System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL) != null && System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL).trim().length() > 0) {
            IMSDK_GROUP_CREATE = System.getProperty(YUN_ZHI_JIA_CREATE_GROUP_URL);
        }
    }

    static class TokenParam {
        private String secret;
        private Long timestamp;
        private String scope = "resGroupSecret";
        private String eid;

        TokenParam(String secret, String eid) {
            this.secret = secret;
            this.timestamp = System.currentTimeMillis();
            this.eid = eid;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getEid() {
            return this.eid;
        }

        public void setEid(String eid) {
            this.eid = eid;
        }
    }

    static class ThemeParam {
        private String title;
        private String content;
        private String lightAppId;
        private String thumbUrl;
        private String webpageUrl;
        private String primaryContent;
        private String contentUrl;

        ThemeParam(Map<String, Object> params) {
            Object contentUrl;
            Object primaryContent;
            Object webpageUrl;
            Object thumbUrl;
            this.content = params.get("content").toString();
            this.title = params.get("title").toString();
            Object lightAppId = params.get("lightAppId");
            if (!Objects.isNull(lightAppId)) {
                this.lightAppId = lightAppId.toString();
            }
            if (!Objects.isNull(thumbUrl = params.get("thumbUrl"))) {
                this.thumbUrl = thumbUrl.toString();
            }
            if (!Objects.isNull(webpageUrl = params.get("webpageUrl"))) {
                this.webpageUrl = webpageUrl.toString();
            }
            if (!Objects.isNull(primaryContent = params.get("primaryContent"))) {
                this.primaryContent = primaryContent.toString();
            }
            if (!Objects.isNull(contentUrl = params.get("contentUrl"))) {
                this.contentUrl = contentUrl.toString();
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getLightAppId() {
            return this.lightAppId;
        }

        public void setLightAppId(String lightAppId) {
            this.lightAppId = lightAppId;
        }

        public String getThumbUrl() {
            return this.thumbUrl;
        }

        public void setThumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
        }

        public String getWebpageUrl() {
            return this.webpageUrl;
        }

        public void setWebpageUrl(String webpageUrl) {
            this.webpageUrl = webpageUrl;
        }

        public String getPrimaryContent() {
            return this.primaryContent;
        }

        public void setPrimaryContent(String primaryContent) {
            this.primaryContent = primaryContent;
        }

        public String getContentUrl() {
            return this.contentUrl;
        }

        public void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }
    }
}

