/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia.lightapp.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.verfiy.BaseVerifier;
import kd.bos.login.verfiy.VerifyEnum;
import kd.bos.login.verfiy.VerifyResult;
import kd.bos.login.yunzhijia.LightAppLogin;
import kd.bos.login.yunzhijia.YunzhijiaAppContext;
import kd.bos.login.yunzhijia.lightapp.YunzhijiaTicketService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang.StringUtils;

public class YunzhijiaLightAppLoginImpl
implements LightAppLogin {
    private static final String BOS_LOGIN = "bos-login";
    private Log logger = LogFactory.getLog(YunzhijiaLightAppLoginImpl.class);
    private static final String LOGIN_VERIFY = "login_verfiers";
    private static final String LOGIN_ADDR = "/login.do";
    private static final String ACCOUNT_ID = "accountId";
    private LoginManage loginManage = new LoginManage();

    @Override
    public void lightAppLogin(HttpServletRequest request, HttpServletResponse response, String reqTenantNo, String appId, String ticket) {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            YunzhijiaAppContext appCtx = YunzhijiaTicketService.getContextByTicket(ticket, appId);
            if (appCtx != null) {
                Account currentCenter = null;
                currentCenter = kd.bos.util.StringUtils.isEmpty((String)reqTenantNo) ? LoginAccountFactory.createInstanceByEid(appCtx.getEid()).getAccount() : LoginAccountFactory.createInstanceByHttpRequest(request, Optional.of(reqTenantNo)).getAccount();
                if (currentCenter != null) {
                    Map<String, String> user = LoginUserService.getErpUserInfo(currentCenter, appCtx.getOpenid(), lang.name());
                    if ("1".equalsIgnoreCase(user.get("success"))) {
                        String allVerifies = System.getProperty(LOGIN_VERIFY);
                        if (!StringUtils.isEmpty((String)allVerifies)) {
                            String[] verifiers;
                            HashMap<Object, String> systemParameters = new HashMap<Object, String>();
                            systemParameters.put((Object)VerifyEnum.DB_DRIVER, user.get("db_driver"));
                            systemParameters.put((Object)VerifyEnum.DB_URL, user.get("db_url"));
                            systemParameters.put((Object)VerifyEnum.E_ID, user.get("feid"));
                            systemParameters.put((Object)VerifyEnum.USER_ID, user.get("fid"));
                            systemParameters.put((Object)VerifyEnum.OPEN_ID, user.get("fopenid"));
                            systemParameters.put((Object)VerifyEnum.ORGNIZATION_ID, user.get("forgid"));
                            systemParameters.put((Object)VerifyEnum.USER_TYPE, user.get("userType"));
                            systemParameters.put((Object)VerifyEnum.TRUE_NAME, user.get("ftruename"));
                            systemParameters.put((Object)VerifyEnum.PHONE, user.get("fphone"));
                            String appNumber = request.getParameter("appNumber");
                            systemParameters.put((Object)VerifyEnum.APP_ID, appNumber);
                            this.logger.info("appNumber=" + appNumber);
                            boolean isSuccess = false;
                            String errorMessage = "";
                            this.logger.info("LOGIN_VERIFY=" + allVerifies);
                            for (String verify : verifiers = allVerifies.split(",")) {
                                BaseVerifier verifier = (BaseVerifier)Class.forName(verify).newInstance();
                                try {
                                    VerifyResult result = verifier.verify(systemParameters, request.getParameterMap(), currentCenter);
                                    isSuccess = result.isSucceed();
                                    errorMessage = result.getErrorMessage();
                                    if (isSuccess) continue;
                                }
                                catch (Exception e) {
                                    this.logger.error((Throwable)e);
                                    errorMessage = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"YunzhijiaLightAppLoginImpl_0", (String)BOS_LOGIN, (Object[])new Object[0]);
                                }
                                break;
                            }
                            if (!isSuccess) {
                                HttpUtils.webAlert(response, errorMessage);
                                return;
                            }
                            this.logger.info("verified result=" + isSuccess);
                        }
                        HashMap<String, String> YzjAppInfo = new HashMap<String, String>();
                        YzjAppInfo.put("yzjAppId", appId);
                        YzjAppInfo.put("yzjAppTicket", ticket);
                        String accountId = request.getParameter(ACCOUNT_ID);
                        SessionUtils.createNewSession(request, response, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, YzjAppInfo, LoginClientEnum.MOBILE);
                        String redirectMe = URLUtils.buildRedirectUrl((ServletRequest)request);
                        String encodedUrl = response.encodeRedirectURL(response.encodeRedirectURL(redirectMe));
                        response.sendRedirect(encodedUrl);
                    } else {
                        String sMsg = ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u3002", (String)"YunzhijiaLightAppLoginImpl_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                        HttpUtils.webAlert(response, sMsg);
                    }
                } else {
                    String sMsg = ResManager.loadKDString((String)"\u8be5\u79df\u6237\u6ca1\u6709\u5f00\u901a\u5de5\u4f5c\u5708\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"YunzhijiaLightAppLoginImpl_2", (String)BOS_LOGIN, (Object[])new Object[0]);
                    HttpUtils.webAlert(response, sMsg);
                }
                return;
            }
        }
        catch (Exception ex) {
            this.logger.info(ex.getMessage());
            try {
                this.loginManage.showLoginPage(request, response);
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
            return;
        }
    }
}

