/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yunzhijia.qrcode;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.OAuth2Encrypter;
import kd.bos.login.utils.StringUtils;
import kd.bos.util.HttpClientUtils;

public class YzjQRCodeService {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(YzjQRCodeService.class);

    public static String getQRCodeInfo(String sCallbackURL) {
        String sYunzhijiaHost = System.getProperty("YunZhiJiaAppHost");
        String sAppID = System.getProperty("YZJAppID");
        String sAppSecret = System.getProperty("YZJAppSecret");
        String sQRURL = sYunzhijiaHost + "/openapi/third/v1/space/c/public/getloginercode";
        try {
            HashMap<String, String> mpBody = new HashMap<String, String>();
            String sCallBackEncodeURL = URLEncoder.encode(sCallbackURL, "UTF-8");
            mpBody.put("callback", sCallBackEncodeURL);
            String oauth_signature_method = null;
            long oauth_timestamp = System.currentTimeMillis() / 1000L;
            String oauth_nonce = String.valueOf(oauth_timestamp + (long)StringUtils.getRandom().nextInt());
            float oauth_version = 1.0f;
            OAuth2Encrypter oauth2Encrypter = (OAuth2Encrypter)BeanUtils.getBean("kd.bos.login.utils.oauth2.OAuth2EncrypterImpl");
            String sAuthorization = oauth2Encrypter.generateAuthorizationHeader(sAppID, sAppSecret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, null, null, null, sQRURL, mpBody, "POST");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", sAuthorization);
            header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            JSONObject jsonQR = JSONObject.parseObject((String)HttpClientUtils.post((String)sQRURL, header, mpBody));
            logger.info("\u83b7\u53d6\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801\u6210\u529f\u3002");
            return jsonQR.toJSONString();
        }
        catch (UnsupportedEncodingException e) {
            throw new KDException(BosErrorCode.canNotCast, new Object[]{ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801\u56de\u8c03\u5730\u5740\u8f6c\u6362\u9519\u8bef\u3002", (String)"YzjQRCodeService_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        catch (URISyntaxException | GeneralSecurityException e) {
            throw new KDException(BosErrorCode.oAuthSecurity, new Object[]{ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801oAuth\u9a8c\u8bc1\u5931\u8d25\u3002", (String)"YzjQRCodeService_1", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801JSON\u8f6c\u6362\u5931\u8d25\u3002", (String)"YzjQRCodeService_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }
}

