/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yzjprivate.lightapp;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.yzjprivate.lightapp.AppContext;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class YunzhijiaPcdTicketService {
    private static final String BOS_LOGIN = "bos-login";
    private static final String OPENID = "openid";
    private static Log logger = LogFactory.getLog(YunzhijiaPcdTicketService.class);
    private static final String API_GET_TOKEN_AUTH2 = "/gateway/oauth2/token/getAccessToken";
    private static final String API_GET_TICKET_AUTH2 = "/gateway/ticket/user/acquirecontext";
    private static final String API_GET_TOKEN = "/openauth2/api/token";
    private static final String API_GET_TICKET = "/openauth2/api/getcontext";
    private static final String YZJ_SYY_XTHOST = ".XtHost";
    private static final String YZJ_SYY_APP = ".AppSecrest.";

    public static AppContext getContextByTicket(String tenantId, String appId, String ticket) {
        return YunzhijiaPcdTicketService.getContextByTicket(tenantId, appId, ticket, "mobile");
    }

    public static AppContext getContextByTicket(String tenantId, String appId, String ticket, String columnName) {
        String secret;
        String yzjpcdHost = "";
        if (StringUtils.isEmpty((CharSequence)yzjpcdHost)) {
            yzjpcdHost = kd.bos.login.utils.StringUtils.getTrimedBlank(System.getProperty(tenantId + YZJ_SYY_XTHOST));
        }
        if (StringUtils.isEmpty((CharSequence)(secret = kd.bos.login.utils.StringUtils.getTrimedBlank(System.getProperty(tenantId + YZJ_SYY_APP + appId))))) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u5bc6\u94a5\u5931\u8d25\uff0c\u5e94\u7528ID=%s\u3002", (String)"YunzhijiaPcdTicketService_0", (String)BOS_LOGIN, (Object[])new Object[0]), appId)});
        }
        try {
            String jsToken = HttpClientUtils.get((String)(yzjpcdHost + API_GET_TOKEN + "?grant_type=client_credential&appid=" + appId + "&secret=" + secret));
            logger.info(String.format("url to=%s", yzjpcdHost + API_GET_TOKEN + "?grant_type=client_credential&appid=" + appId));
            if (StringUtils.isEmpty((CharSequence)jsToken)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6Accesstoken\u5931\u8d25\uff0c\u5e94\u7528ID\uff1a%1$s\uff0c\u5e94\u7528\u5bc6\u94a5\uff1a%2$s\u3002", (String)"YunzhijiaPcdTicketService_1", (String)BOS_LOGIN, (Object[])new Object[]{appId, secret}), new Object[0])});
            }
            Map mpToken = (Map)JSONUtils.cast((String)jsToken, HashMap.class, (boolean)true);
            String token = (String)mpToken.get("access_token");
            String jsTicket = HttpClientUtils.get((String)(yzjpcdHost + API_GET_TICKET + "?ticket=" + ticket + "&access_token=" + token));
            if (StringUtils.isNotEmpty((CharSequence)jsTicket)) {
                Map user = (Map)JSONUtils.cast((String)jsTicket, HashMap.class, (boolean)true);
                AppContext ctx = new AppContext();
                ctx.setEid((String)user.get("eid"));
                ctx.setOpenid((String)user.get(OPENID));
                ctx.setMobile((String)user.get(columnName));
                ctx.setOrgId((String)user.get("orgId"));
                return ctx;
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79c1\u6709\u4e91\u8f7b\u5e94\u7528\u767b\u5f55\u5931\u8d25\uff0cappid=%s", (String)"YunzhijiaPcdTicketService_2", (String)BOS_LOGIN, (Object[])new Object[0]), appId)});
        }
        return null;
    }

    public static AppContext getContextByTicketAuth2(String tenantId, String appId, String ticket) {
        return YunzhijiaPcdTicketService.getContextByTicketAuth2(tenantId, appId, ticket, "mobile");
    }

    public static AppContext getContextByTicketAuth2(String tenantId, String appId, String ticket, String columnName) {
        String secret;
        String yzjpcdHost = "";
        if (StringUtils.isEmpty((CharSequence)yzjpcdHost)) {
            yzjpcdHost = kd.bos.login.utils.StringUtils.getTrimedBlank(System.getProperty(tenantId + YZJ_SYY_XTHOST));
        }
        if (StringUtils.isEmpty((CharSequence)(secret = kd.bos.login.utils.StringUtils.getTrimedBlank(System.getProperty(tenantId + YZJ_SYY_APP + appId))))) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u5bc6\u94a5\u5931\u8d25\uff0c\u5e94\u7528ID=%s\u3002", (String)"YunzhijiaPcdTicketService_0", (String)BOS_LOGIN, (Object[])new Object[0]), appId)});
        }
        try {
            HashMap<String, Object> body = new HashMap<String, Object>(8);
            body.put("appId", appId);
            body.put("secret", secret);
            body.put("timestamp", System.currentTimeMillis());
            body.put("scope", "app");
            String jsToken = HttpClientUtils.postAppJson((String)(yzjpcdHost + API_GET_TOKEN_AUTH2), null, body);
            if (StringUtils.isEmpty((CharSequence)jsToken)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6Accesstoken\u5931\u8d25\uff0c\u5e94\u7528ID\uff1a%1$s\uff0c\u5e94\u7528\u5bc6\u94a5\uff1a%2$s\u3002", (String)"YunzhijiaPcdTicketService_1", (String)BOS_LOGIN, (Object[])new Object[]{appId, secret}), new Object[0])});
            }
            Map mpToken = (Map)JSONUtils.cast((String)jsToken, HashMap.class, (boolean)true);
            if (mpToken.get("data") == null || StringUtils.isBlank((CharSequence)mpToken.get("data").toString())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{jsToken});
            }
            Map data = (Map)mpToken.get("data");
            String accessToken = (String)data.get("accessToken");
            body = new HashMap(4);
            body.put("appid", appId);
            body.put("ticket", ticket);
            body.put("disposable", true);
            String jsTicket = HttpClientUtils.postAppJson((String)(yzjpcdHost + API_GET_TICKET_AUTH2 + "?accessToken=" + accessToken), null, body);
            if (StringUtils.isNotEmpty((CharSequence)jsTicket)) {
                Map result = (Map)JSONUtils.cast((String)jsTicket, HashMap.class, (boolean)true);
                Map user = (Map)result.get("data");
                AppContext ctx = new AppContext();
                ctx.setEid((String)user.get("eid"));
                ctx.setOpenid((String)user.get(OPENID));
                ctx.setOrgId((String)user.get("orgId"));
                return ctx;
            }
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79c1\u6709\u4e91\u8f7b\u5e94\u7528\u767b\u5f55\u5931\u8d25\uff0cappid=%s", (String)"YunzhijiaPcdTicketService_2", (String)BOS_LOGIN, (Object[])new Object[0]), appId)});
        }
        return null;
    }
}

