/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.yzjprivate.lightapp.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.yunzhijia.LightAppLogin;
import kd.bos.login.yzjprivate.lightapp.AppContext;
import kd.bos.login.yzjprivate.lightapp.YunzhijiaPcdTicketService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.NetAddressUtils;

public class YzjpcdLightAppLoginImpl
implements LightAppLogin {
    private static Log logger = LogFactory.getLog(YzjpcdLightAppLoginImpl.class);
    private LoginManage loginManage = new LoginManage();

    @Override
    public void lightAppLogin(HttpServletRequest request, HttpServletResponse response, String reqTenantNo, String appId, String ticket) {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.of(reqTenantNo)).getAccount();
            AppContext appCtx = YunzhijiaPcdTicketService.getContextByTicket(currentCenter.getTenantId(), appId, ticket);
            if (appCtx != null) {
                String tenantId = currentCenter.getTenantId();
                Map<String, String> user = null;
                String mobileNo = appCtx.getMobile();
                user = ValidationUtils.isPhone(mobileNo) ? LoginUserService.getErpUserInfoByPhone(currentCenter, mobileNo, lang.name()) : LoginUserService.getErpUserInfoByUserName(currentCenter, mobileNo, lang.name());
                if (user != null && user.size() > 0) {
                    HashMap<String, String> YzjAppInfo = new HashMap<String, String>();
                    YzjAppInfo.put("yzjAppId", appId);
                    YzjAppInfo.put("yzjAppTicket", ticket);
                    SessionUtils.createNewSession(request, response, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, YzjAppInfo, LoginClientEnum.MOBILE);
                    String redirectMe = URLUtils.buildRedirectUrl((ServletRequest)request);
                    String encodedUrl = response.encodeRedirectURL(response.encodeRedirectURL(redirectMe));
                    if (LoginUtils.isSelfEnvironment(encodedUrl, request, response)) {
                        response.sendRedirect(encodedUrl);
                    }
                } else {
                    String sMsg = ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u3002", (String)"YzjpcdLightAppLoginImpl_0", (String)"bos-login", (Object[])new Object[0]);
                    HttpUtils.webAlert(response, sMsg);
                }
                return;
            }
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
            try {
                this.loginManage.showLoginPage(request, response);
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
            return;
        }
    }
}

