/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.share.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.share.NoCodeShare;
import kd.bos.share.service.ShareSerivce;

public class NoCodeShareSerivce
implements ShareSerivce<NoCodeShare> {
    private static final String SHARE_ENTITY_NAME = "bos_svc_share";
    private static final String NO_CODE_SHARE_PREFIX = "/share/";
    private static final String UNDER_LINE = "_";

    @Override
    public String share(NoCodeShare share) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)SHARE_ENTITY_NAME);
        record.set("url", (Object)share.getUrl());
        record.set("name", (Object)share.getName());
        record.set("expiretime", (Object)share.getExpireTime());
        record.set("sharetime", (Object)share.getShareTime());
        record.set("state", (Object)"0");
        record.set("sharetype", (Object)"0");
        record.set("sharecontext", (Object)"");
        record.set("sharecontext_tag", (Object)share.getContext());
        RequestContext rc = RequestContext.get();
        DynamicObject dynamicObject = this.insertOne(record);
        if (dynamicObject != null) {
            Long pk = (Long)dynamicObject.getPkValue();
            StringBuffer sb = new StringBuffer(share.getUrl());
            sb.append(NO_CODE_SHARE_PREFIX);
            sb.append(String.valueOf(pk));
            sb.append(UNDER_LINE);
            sb.append(rc.getAccountId());
            sb.append(UNDER_LINE);
            sb.append(rc.getOrgId());
            return sb.toString();
        }
        return null;
    }

    @Override
    public void cancelShareById(String id) {
    }

    @Override
    public void cancelShareByUrl(String url) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NoCodeShare getShareById(String id, String acid) {
        NoCodeShare noCodeShare;
        String returnValue = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Account currentCenter = AccountUtils.getAccountById((String)acid);
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "select  url,expiretime  from T_BAS_SHARE_URL where  fid=?";
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, Long.valueOf(id));
            rs = stmt.executeQuery();
            NoCodeShare noCodeShare2 = new NoCodeShare();
            if (rs.next()) {
                noCodeShare2.setUrl(rs.getString("url"));
                Timestamp expireDate = rs.getTimestamp("expiretime");
                noCodeShare2.setExpireTime(((Date)expireDate).getTime());
            }
            noCodeShare = noCodeShare2;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return noCodeShare;
    }

    @Override
    public NoCodeShare getShareByUrl(String url) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DynamicObject insertOne(DynamicObject record) {
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] dynamicObjects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            DynamicObject dynamicObject = dynamicObjects[0];
            return dynamicObject;
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

