/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.share.session;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.session.SessionManager;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;

public class ShareSession {
    public static String getShareSessionId(HttpServletRequest request, HttpServletResponse response, String shareId, String acid, String orig) {
        String globalSessionId = null;
        if (globalSessionId == null) {
            globalSessionId = ShareSession.createSessionByShareId(request, response, shareId, acid, orig);
            CacheLoginData.setAttribute((String)"share", (String)shareId, (String)globalSessionId);
            CacheLoginData.setAttribute((String)"nocode_share", (String)globalSessionId, (String)shareId, (int)3600);
            return globalSessionId;
        }
        SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, globalSessionId);
        return globalSessionId;
    }

    private static String createSessionByShareId(HttpServletRequest request, HttpServletResponse response, String shareId, String acid, String orig) {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        Account currentCenter = AccountUtils.getAccountById((String)acid);
        LoginClientEnum lType = LoginClientEnum.WEB;
        Map<String, String> userInfo = ShareSession.getShareUserInfo(tenantId, shareId, orig);
        String shareSessionId = SessionUtils.createNewSession(request, response, currentCenter, LoginLangUtils.getLoginLanguage(request), NetAddressUtils.getRemoteHost((HttpServletRequest)request), userInfo, lType, 5000, true);
        return shareSessionId;
    }

    private static Map<String, String> getShareUserInfo(String tenantId, String shareId, String orig) {
        HashMap<String, String> user = new HashMap<String, String>(8);
        user.put("forgid", orig);
        user.put("fid", shareId);
        user.put("ftruename", "share");
        user.put("fopenid", "");
        user.put("userType", "1");
        user.put("sessionType", "2");
        user.put("tenantId", tenantId);
        return user;
    }
}

