/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.op;

import java.util.Collections;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.notification.AbstractNotificationClick;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.events.ButtonClickEventArgs;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;

public class MsgNoticeClick
extends AbstractNotificationClick {
    private static final String WF_TASKCENTERHOME = "wf_msg_center";
    private static Log logger = LogFactory.getLog(MsgNoticeClick.class);

    public void closeCallBack() {
        super.closeCallBack();
        String msgId = this.getNotificationId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        MessageCenterServiceHelper.setMessagePopup((Long)Long.valueOf(msgId), Collections.singletonList(userId), (boolean)false);
    }

    public void buttonClick(ButtonClickEventArgs e) {
        String key;
        String msgId = this.getNotificationId();
        switch (key = e.getButtonKey()) {
            case "ignore": {
                this.setMsgReadState(msgId);
                break;
            }
            case "detail": {
                this.showDetail(msgId);
                break;
            }
        }
    }

    private void setMsgReadState(String msgId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (msgId != null) {
            MessageCenterServiceHelper.setMsgReadState((Long)Long.valueOf(msgId), Collections.singletonList(userId));
        }
        NotificationServiceHelper.sendIgnoreNotification((String)RequestContext.get().getUserId(), (String)msgId);
        NotificationClientCache.removeNotification((String)RequestContext.get().getUserId(), (String)msgId);
    }

    private void showDetail(String msgId) {
        IFormView formView = this.getFormView();
        if (formView == null) {
            logger.info("MsgNoticeClick--showDetail--formView is null");
            return;
        }
        this.setMsgReadState(msgId);
        String url = MsgCacheUtil.getString((String)("prompteUrl_" + msgId));
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            logger.info(String.format("MsgNoticeClick--showDetail--2 msgId:%s, url:%s", msgId, url));
            formView.openUrl(url);
        } else if (formView.getMainView() == null) {
            formView.openUrl("?formId=wf_msg_center");
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getFormView());
            map.put("appmainnumber", WF_TASKCENTERHOME);
            map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
            HashMap<String, Number> customparameters = new HashMap<String, Number>(2);
            customparameters.put("tabType", 2);
            customparameters.put("messageId", Long.valueOf(msgId));
            map.put("customparameters", customparameters);
            OpenPageUtils.openApp((String)"wftask", null, map, (IFormView)formView);
        }
    }
}

