/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import kd.bos.basmsg.api.IBaseMessageService;
import kd.bos.basmsg.api.MessageInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.enums.ShowPosition;
import kd.bos.message.factory.BaseMessageShowFactory;
import kd.bos.message.service.BaseMessageShow;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.message.utils.BaseMessageUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BaseMessageServiceImpl
implements IBaseMessageService {
    private static Log logger = LogFactory.getLog(BaseMessageServiceImpl.class);

    public void showMessage(MessageInfo message) {
        logger.info("BaseMessageServiceImpl--show message param:" + JSONObject.toJSONString((Object)message));
        BaseMessageUtils.setDefaultLang(message);
        String msgType = message.getMsgType();
        if ("activity".equals(msgType)) {
            return;
        }
        long msgId = message.getId();
        if (msgId == 0L) {
            throw new KDException(new ErrorCode("showMessage error", "msgId:" + msgId), new Object[0]);
        }
        String showType = message.getShowType();
        if (ShowPosition.getShowPosition((String)showType) == null) {
            return;
        }
        List userList = message.getUserList();
        boolean toAll = message.isToAll();
        if (toAll) {
            userList = MsgSessionUtil.getOnLineUserIds();
        } else if (userList.size() > 10000) {
            List onLineUserIds = MsgSessionUtil.getOnLineUserIds();
            userList.retainAll(onLineUserIds);
        }
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return;
        }
        message.setUserList(userList);
        String clickClassName = message.getClickClassName();
        if (StringUtils.isEmpty((String)clickClassName)) {
            message.setClickClassName("kd.bos.message.op.MsgNoticeClick");
        }
        BaseMessageShow baseMessageShow = BaseMessageShowFactory.getImplByShowType(showType);
        baseMessageShow.send(message);
    }
}

