/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.basmsg.api.MessageInfo;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.BaseMessageShow;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.message.utils.BaseMessageUtils;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.NotificationLevel;
import kd.bos.portal.util.ILocalStringUtil;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.util.StringUtils;

public class BaseMessageShowFloat
implements BaseMessageShow {
    private static Log logger = LogFactory.getLog(BaseMessageShowFloat.class);
    private static BaseMessageShow instance = new BaseMessageShowFloat();

    public static BaseMessageShow getInstance() {
        return instance;
    }

    @Override
    public void send(MessageInfo message) {
        List userList = message.getUserList();
        String title = message.getTitle();
        BaseMessageUtils.setDefaultLang(message);
        BaseMessageUtils.initMsgContent(message, message.isNoticeClick());
        ILocaleString messageTitle = message.getMessageTitle();
        ILocaleString messageContent = message.getMessageContent();
        long msgId = message.getId();
        LocaleString ls = ResManager.getLocaleString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BaseMessageServiceImpl_1", (String)"bas-mservice-message");
        String url = message.getUrl();
        if (StringUtils.isNotEmpty((String)url)) {
            this.setUrlCache(msgId, url);
        }
        Integer mode = this.getMode(message.getMsgType());
        int duration = message.getDuration();
        Map us = MsgSessionUtil.getUserSessionLangGroupInfo((List)userList, (boolean)message.isToAll());
        us.forEach((lang, userSessionIdsMap) -> {
            String finalTitle = ILocalStringUtil.getValueByLang((ILocaleString)messageTitle, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)title);
            String finalContent = ILocalStringUtil.getValueByLang((ILocaleString)messageContent, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)message.getContent());
            NotificationBody notificationBody = new NotificationBody();
            notificationBody.setAppId("bos");
            notificationBody.setTitle(finalTitle);
            notificationBody.setContent(finalContent);
            notificationBody.setNotificationId(msgId + "");
            notificationBody.setIconType(IconType.Info.toString());
            notificationBody.setCreateTime(System.currentTimeMillis());
            notificationBody.setLevel(NotificationLevel.normal.getLevel());
            if (mode != null) {
                notificationBody.setMode(mode);
            }
            notificationBody.setClickClassName(message.getClickClassName());
            String buttonName = (String)ls.get(lang);
            NotificationBody.ButtonInfo detailButton = new NotificationBody.ButtonInfo();
            detailButton.setKey("detail");
            detailButton.setText(buttonName);
            notificationBody.addButtonInfo(detailButton);
            NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
            notificationFormInfo.setNotification(notificationBody);
            notificationFormInfo.setDuration(duration);
            NotificationServiceHelper.sendNotificationByLang((Map)userSessionIdsMap, (NotificationFormInfo)notificationFormInfo, (String)lang);
        });
        this.setCache(msgId, userList);
    }

    private void setCache(long msgId, List<Long> userList) {
        String cacheValue = MsgCacheUtil.getString((String)(msgId + ""));
        if (cacheValue == null) {
            String userInfo = SerializationUtils.toJsonString(userList.stream().map(a -> a + "").collect(Collectors.toList()));
            logger.info("BaseMessageShowFloat--msgId:" + msgId + "--userIds:" + userInfo);
            MsgCacheUtil.putCache((String)(msgId + ""), (String)userInfo, (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    private void setUrlCache(long msgId, String url) {
        String urlCache = MsgCacheUtil.getString((String)this.getUrlKey(msgId));
        if (urlCache == null) {
            logger.info("BaseMessageShowFloat--msgId:" + msgId + "--url:" + url);
            MsgCacheUtil.putCache((String)this.getUrlKey(msgId), (String)url, (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    private String getUrlKey(long msgId) {
        return "prompteUrl_" + msgId;
    }

    private Integer getMode(String msgType) {
        Integer mode = null;
        if (StringUtils.isNotEmpty((String)msgType) && "fatvs".equals(msgType)) {
            mode = 2;
        }
        return mode;
    }
}

