/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import java.lang.constant.Constable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.basmsg.api.MessageInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.BaseMessageShow;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgLocalCacheUtils;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.message.utils.BaseMessageUtils;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.ILocalStringUtil;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.session.SessionDAOFactory;

public class BaseMessageShowModal
implements BaseMessageShow {
    private static Log logger = LogFactory.getLog(BaseMessageShowModal.class);
    private static BaseMessageShow instance = new BaseMessageShowModal();

    public static BaseMessageShow getInstance() {
        return instance;
    }

    @Override
    public void send(MessageInfo message) {
        logger.info("sendMsg start");
        List userList = message.getUserList();
        BaseMessageUtils.setDefaultLang(message);
        long msgId = message.getId();
        String accountId = RequestContext.get().getAccountId();
        String msgIdStr = msgId + "";
        MsgLocalCacheUtils.put((String)msgIdStr, (Object)"true");
        FormShowParameter fsp = null;
        boolean isMsgNotice = this.isMsgNotice(msgId);
        String pageId = "";
        if (isMsgNotice) {
            fsp = this.buildNoticeFormShowParameter(msgId);
            pageId = fsp.getPageId();
        }
        for (Long userId : userList) {
            Object data = MsgLocalCacheUtils.get((String)msgIdStr);
            if (data == null) {
                logger.info("send msg interrupt");
                break;
            }
            HashMap<String, String> userFormMap = new HashMap<String, String>(16);
            String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)userId.toString());
            if (sessionIds != null && sessionIds.length > 0) {
                for (int i = 0; i < sessionIds.length; ++i) {
                    String sessionId = sessionIds[i];
                    String lang = SessionDAOFactory.getSessionDAO((String)sessionId).getAttribute("language");
                    if (!isMsgNotice) {
                        fsp = this.buildActivityFormShowParameter(message, lang);
                    } else {
                        fsp.setPageId(String.format("%s_%s_%s", pageId, userId, i));
                    }
                    fsp.setSessionId(sessionId);
                    Map config = FormConfigFactory.createConfig((FormShowParameter)fsp);
                    config.remove("watermark");
                    config.put("sessionId", sessionId);
                    if (StringUtils.isNotEmpty((CharSequence)lang)) {
                        config.put("lang", lang);
                    }
                    String currPageId = (String)config.get("pageId");
                    userFormMap.put(sessionId, currPageId);
                    String msg = MsgSessionUtil.buildWebSocketAction((String)"showForm", (Object)config);
                    PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
                    PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
                }
            }
            if (userFormMap.isEmpty()) continue;
            this.recordAndCloseMessage(userId, msgIdStr, userFormMap);
            MsgCacheUtil.putCache((String)msgIdStr, userFormMap, (int)1, (TimeUnit)TimeUnit.DAYS);
        }
        logger.info("sendMsg end");
        MsgLocalCacheUtils.remove((String)msgIdStr);
    }

    private boolean isMsgNotice(long msgId) {
        QFilter qFilter = new QFilter("messageid", "=", (Object)msgId);
        return QueryServiceHelper.exists((String)"msg_notice", (QFilter[])new QFilter[]{qFilter});
    }

    private FormShowParameter buildNoticeFormShowParameter(long msgId) {
        FormShowParameter fsp = new FormShowParameter();
        String formId = "msg_notice_modal";
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Constable> map = new HashMap<String, Constable>(16);
        map.put("msgId", Long.valueOf(msgId));
        map.put("isMsgNotice", Boolean.valueOf(true));
        fsp.setCustomParams(map);
        fsp.setShowTitle(false);
        fsp.setShowClose(false);
        return fsp;
    }

    private FormShowParameter buildActivityFormShowParameter(MessageInfo message, String lang) {
        long msgId = message.getId();
        String url = message.getUrl();
        String title = message.getTitle();
        String content = message.getContent();
        ILocaleString messageTitle = message.getMessageTitle();
        ILocaleString messageContent = message.getMessageContent();
        String finalTitle = ILocalStringUtil.getValueByLang((ILocaleString)messageTitle, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)title);
        String finalContent = ILocalStringUtil.getValueByLang((ILocaleString)messageContent, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)content);
        FormShowParameter fsp = new FormShowParameter();
        String formId = "msg_notice_modal";
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("message", finalContent);
        map.put("title", finalTitle);
        map.put("msgId", msgId);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            map.put("url", url);
        }
        fsp.setCustomParams(map);
        fsp.setShowTitle(false);
        fsp.setShowClose(false);
        return fsp;
    }

    private void closeForm(Long userId, Map<String, String> formMap) {
        String key = this.getSendRecordKey(userId);
        Map msgFormCache = MsgCacheUtil.getAll((String)key);
        logger.info("BaseMessageShowModal--closeForm sessionInfo:" + SerializationUtils.toJsonString((Object)msgFormCache));
        if (msgFormCache != null) {
            msgFormCache.forEach((sessionId, pageId) -> {
                HashMap<String, String> pageMap = new HashMap<String, String>(16);
                pageMap.put("pageId", (String)pageId);
                String closeMsg = MsgSessionUtil.buildWebSocketAction((String)"closeWindow", pageMap);
                PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)closeMsg);
                PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
            });
        }
        MsgCacheUtil.remove((String)key);
        MsgCacheUtil.putCache((String)key, formMap, (int)1, (TimeUnit)TimeUnit.DAYS);
    }

    private void recordAndCloseMessage(Long userId, String msgId, Map<String, String> formMap) {
        String msgIdCache = MsgCacheUtil.getString((String)this.getMsgRecordKey(userId));
        if (StringUtils.isNotEmpty((CharSequence)msgIdCache) && !msgIdCache.equals(msgId)) {
            MessageCenterServiceHelper.setMessagePopup((Long)Long.valueOf(msgIdCache), Collections.singletonList(userId), (boolean)false);
            logger.info(String.format("BaseMessageShowModal--setMessagePopup, userId:%s, msgId:%s", userId, msgIdCache));
        }
        this.closeForm(userId, formMap);
        MsgCacheUtil.putCache((String)this.getMsgRecordKey(userId), (String)msgId, (int)1, (TimeUnit)TimeUnit.DAYS);
    }

    private String getMsgRecordKey(Long userId) {
        return "SendRecord_CENTER_MSG_" + userId;
    }

    private String getSendRecordKey(Long userId) {
        return "SendRecord_CENTER_" + userId;
    }
}

