/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.basmsg.api.MessageInfo;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.BaseMessageShow;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.message.utils.BaseMessageUtils;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.NotificationLevel;
import kd.bos.portal.util.ILocalStringUtil;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;

public class BaseMessageShowTop
implements BaseMessageShow {
    private static Log logger = LogFactory.getLog(BaseMessageShowTop.class);
    private static BaseMessageShow instance = new BaseMessageShowTop();

    public static BaseMessageShow getInstance() {
        return instance;
    }

    @Override
    public void send(MessageInfo message) {
        List userList = message.getUserList();
        String title = message.getTitle();
        BaseMessageUtils.setDefaultLang(message);
        long msgId = message.getId();
        LocaleString ls = ResManager.getLocaleString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BaseMessageServiceImpl_1", (String)"bas-mservice-message");
        String url = message.getUrl();
        if (StringUtils.isNotEmpty((String)url)) {
            this.setUrlCache(msgId, url);
        }
        int duration = message.getDuration();
        BaseMessageUtils.initMsgContent(message, true);
        Map userSessionMap = MsgSessionUtil.getUserSessionLangGroupInfo((List)userList, (boolean)message.isToAll());
        userSessionMap.forEach((lang, userSessionIdsMap) -> {
            NotificationBody notificationBody = new NotificationBody();
            notificationBody.setAppId("bos");
            notificationBody.setTitle(ILocalStringUtil.getValueByLang((ILocaleString)message.getMessageTitle(), (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)title));
            notificationBody.setContent(ILocalStringUtil.getValueByLang((ILocaleString)message.getMessageContent(), (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)message.getContent()));
            notificationBody.setNotificationId(msgId + "");
            notificationBody.setIconType(IconType.Info.toString());
            notificationBody.setLevel(NotificationLevel.important.getLevel());
            notificationBody.setDuration(duration);
            notificationBody.setClickClassName(message.getClickClassName());
            String buttonName = (String)ls.get(lang);
            NotificationBody.ButtonInfo detailButton = new NotificationBody.ButtonInfo();
            detailButton.setKey("detail");
            detailButton.setText(buttonName);
            notificationBody.addButtonInfo(detailButton);
            NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
            notificationFormInfo.setNotification(notificationBody);
            NotificationServiceHelper.sendNotificationByLang((Map)userSessionIdsMap, (NotificationFormInfo)notificationFormInfo, (String)lang);
        });
        this.recordAndCloseMessage(userList, msgId);
    }

    private void setUrlCache(long msgId, String url) {
        String urlCache = MsgCacheUtil.getString((String)this.getUrlKey(msgId));
        if (urlCache == null) {
            logger.info("BaseMessageShowTop--msgId:" + msgId + "--url:" + url);
            MsgCacheUtil.putCache((String)this.getUrlKey(msgId), (String)url, (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    private String getUrlKey(long msgId) {
        return "prompteUrl_" + msgId;
    }

    private void recordAndCloseMessage(List<Long> userList, long msgId) {
        for (Long userId : userList) {
            String msgIdCache = MsgCacheUtil.getString((String)this.getSendRecordKey(userId));
            if (StringUtils.isNotEmpty((String)msgIdCache) && !msgIdCache.equals(msgId + "")) {
                MessageCenterServiceHelper.setMessagePopup((Long)Long.valueOf(msgIdCache), Collections.singletonList(userId), (boolean)false);
            }
            MsgCacheUtil.putCache((String)this.getSendRecordKey(userId), (String)(msgId + ""), (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    private String getSendRecordKey(Long userId) {
        return "SendRecord_TOP_" + userId;
    }
}

