/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.session.SystemPropertyUtils;

public class DelTagsUtil {
    private static final List<String> HTML_EVENT_BLACKLIST = Arrays.asList("onafterprint", "onbeforeprint", "onbeforeonload", "onblur", "onerror", "onfocus", "onhashchange", "onload", "onmessage", "onoffline", "ononline", "onpagehide", "onpageshow", "onpopstate", "onredo", "onresize", "onstorage", "onundo", "onunload", "onblur", "onchange", "oncontextmenu", "onfocus", "onformchange", "onforminput", "oninput", "oninvalid", "onreset", "onselect", "onsubmit", "onkeydown", "onkeypress", "onkeyup", "onclick", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop\t", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup\t", "onmousewheel", "onscroll", "onabort", "oncanplay", "oncanplaythrough", "ondurationchange", "onemptied", "onended", "onloadeddata", "onloadedmetadata", "onloadstart", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onseeked", "onseeking", "onstalled", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting", "onshow", "ontoggle", "onmouseenter", "onmouseleave", "onpointerdown", "onpointerup", "onpointermove", "onpointerover", "onpointerout", "onpointerenter", "onpointerleave", "onpointercancel", "ongotpointercapture", "onlostpointercapture", "ontouchstart", "ontouchmove", "ontouchend", "ontouchcancel", "onfocusin", "onfocusout", "onbeforecopy", "onbeforecut", "onbeforepaste", "ondragexit", "onsearch", "onwheel", "onanimationstart", "onanimationend", "onanimationiteration", "ontransitionend", "onfullscreenchange", "onfullscreenerror", "onbeforeunload", "onlanguagechange", "onmessageerror", "onrejectionhandled", "onunhandledrejection", "onvrdisplayconnect", "onvrdisplaydisconnect", "onvrdisplayactivate", "onvrdisplaydeactivate", "onvrdisplaypresentchange", "onauxclick", "onpointerlockchange", "onpointerlockerror", "onbeforeinput", "ongamepadconnected", "ongamepaddisconnected", "ondeviceorientation", "ondevicemotion", "onbeforeinstallprompt", "ondevicechange", "onuserproximity", "ondevicelight", "onbeforexrselect", "oncopy", "oncut", "javascript", "onfinish", "onpaste");

    public static String delHtmlTags(String htmlStr) {
        String scriptRegex = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String styleRegex = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String htmlRegex = "<[^>]+>";
        String spaceRegex = "\\s*|\t|\r|\n";
        htmlStr = htmlStr.replaceAll(scriptRegex, "");
        htmlStr = htmlStr.replaceAll(styleRegex, "");
        htmlStr = htmlStr.replaceAll(htmlRegex, "");
        htmlStr = htmlStr.replaceAll(spaceRegex, "");
        return htmlStr.trim();
    }

    public static String getTextFromHtml(String htmlStr) {
        htmlStr = DelTagsUtil.delHtmlTags(htmlStr);
        htmlStr = htmlStr.replaceAll(" ", "");
        htmlStr = htmlStr.replaceAll("\\u00A0", "");
        htmlStr = htmlStr.replaceAll("&nbsp;", "");
        return htmlStr;
    }

    public static boolean validHtmlContent(String content) {
        Boolean enableCheck = SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"enable_check_html", (Boolean)Boolean.TRUE);
        if (enableCheck.booleanValue()) {
            String eventList = String.join((CharSequence)"|", HTML_EVENT_BLACKLIST);
            String rex = String.format("<([^<>]*(%s)[^<>]*)>", eventList);
            Pattern p = Pattern.compile(rex, 2);
            Matcher m = p.matcher(content);
            return !m.find();
        }
        return true;
    }
}

