/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.enums.SendStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageUtils {
    public static final String SYS_BASE_SEND_MESSAGE = "sys.base.sendMessage";
    public static final String NUMBER = "number";
    private static final String BAS_MESSAGE_COMMON = "bas-message-common";
    private static final Log logger = LogFactory.getLog(MessageUtils.class);
    public static final String MSG_NOTICE_CONTENT_LANG = "msg_notice_content_lang";
    private static final long CONTENT_SIZE_LIMIT = 0x100000L;

    public static long sendMessage(DynamicObject data) {
        MessageInfo messageInfo = MessageUtils.data2MessageInfo(data);
        try {
            long msgIdResult = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            return msgIdResult;
        }
        catch (Exception e) {
            logger.info("MessageUtils--sendMessage error", (Object)e);
            throw new KDException(new ErrorCode(SYS_BASE_SEND_MESSAGE, String.format(ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c%s", (String)"MessageUtils_0", (String)BAS_MESSAGE_COMMON, (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    private static MessageInfo data2MessageInfo(DynamicObject data) {
        DynamicObject msgChannelObj;
        long msgId = data.getLong("messageid");
        Integer sendstatus = data.getInt("sendstatus");
        if (msgId != 0L && SendStatus.SENT.getCode().equals(sendstatus)) {
            throw new KDException(new ErrorCode(SYS_BASE_SEND_MESSAGE, ResManager.loadKDString((String)"\u6d88\u606f\u5df2\u53d1\u9001\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MessageUtils_1", (String)BAS_MESSAGE_COMMON, (Object[])new Object[0])), new Object[0]);
        }
        MessageInfo messageInfo = new MessageInfo();
        ILocaleString localeString = data.getLocaleString("title");
        LocaleString noticeContent = MessageUtils.wrapNoticeContent((Long)data.getPkValue());
        messageInfo.setMessageContent((ILocaleString)noticeContent);
        messageInfo.setMessageTitle(localeString);
        DynamicObject msgTypeObj = data.getDynamicObject("msgtype");
        if (msgTypeObj != null) {
            String msgType = msgTypeObj.getString(NUMBER);
            messageInfo.setType(msgType);
        }
        if ((msgChannelObj = data.getDynamicObject("msgchannel")) != null) {
            String msgChannel = msgChannelObj.getString(NUMBER);
            messageInfo.setNotifyType(msgChannel);
        }
        Integer showType = data.getInt("showType");
        long timeOut = data.getLong("validTime");
        HashMap params = new HashMap();
        HashMap<String, Number> systemNotice = new HashMap<String, Number>();
        systemNotice.put("showType", showType);
        systemNotice.put("timeOut", timeOut * 60L * 1000L);
        params.put("systemNotice", systemNotice);
        messageInfo.setParams(params);
        boolean toall = data.getBoolean("toall");
        if (toall) {
            messageInfo.setToAll(true);
        } else {
            List<Long> userIds = MessageUtils.getSendUserIds(data);
            if (CollectionUtils.isEmpty(userIds)) {
                throw new KDException(new ErrorCode(SYS_BASE_SEND_MESSAGE, ResManager.loadKDString((String)"\u65e0\u53ef\u63a8\u9001\u4eba\u5458\u3002", (String)"MessageUtils_2", (String)BAS_MESSAGE_COMMON, (Object[])new Object[0])), new Object[0]);
            }
            messageInfo.setUserIds(userIds);
        }
        String url = UrlService.getDomainContextUrl() + "/index.html?formId=msg_notice_detail&msgNoticeId=" + data.getPkValue();
        messageInfo.setContentUrl(url);
        return messageInfo;
    }

    public static LocaleString wrapNoticeContent(Long pkValue) {
        LocaleString localeString = new LocaleString();
        Map<Object, DynamicObject> noticeContent = MessageUtils.getNoticeContent(pkValue);
        for (Map.Entry<Object, DynamicObject> objectEntry : noticeContent.entrySet()) {
            DynamicObject value = objectEntry.getValue();
            localeString.setItem(value.getString("localeid"), (Object)value.getString("content"));
        }
        return localeString;
    }

    public static Map<Object, DynamicObject> getNoticeContent(Long id) {
        return BusinessDataServiceHelper.loadFromCache((String)MSG_NOTICE_CONTENT_LANG, (QFilter[])new QFilter[]{new QFilter("notice_id", "=", (Object)id)});
    }

    private static List<Long> getSendUserIds(DynamicObject data) {
        DynamicObjectCollection userTypes;
        DynamicObjectCollection users = data.getDynamicObjectCollection("user");
        List userIds = users.stream().map(dynamicObject -> Long.valueOf(dynamicObject.get(2).toString())).collect(Collectors.toList());
        DynamicObjectCollection adminOrgs = data.getDynamicObjectCollection("adminorg");
        if (!CollectionUtils.isEmpty((Collection)adminOrgs)) {
            List orgIds = adminOrgs.stream().map(dynamicObject -> Long.valueOf(dynamicObject.get(2).toString())).collect(Collectors.toList());
            Set orgUserIds = UserServiceHelper.getAllUsersOfOrg((int)0, orgIds, (boolean)false, (boolean)false);
            userIds.addAll(orgUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(userTypes = data.getDynamicObjectCollection("usertype")))) {
            List<String> userTypeIds = userTypes.stream().map(dynamicObject -> dynamicObject.getString(2)).collect(Collectors.toList());
            userIds.addAll(MessageUtils.getUserIdsByUserTypes(userTypeIds));
        }
        return userIds.stream().distinct().collect(Collectors.toList());
    }

    public static List<Long> getUserIdsByUserTypes(List<String> userTypeIds) {
        QFilter userTypeFilter = new QFilter("usertype", "in", userTypeIds);
        DynamicObject[] userType = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{userTypeFilter});
        return Arrays.asList(userType).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getUserIdsByPhones(List<String> phones) {
        QFilter phoneFilter = new QFilter("phone", "in", phones);
        DynamicObject[] userIds = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{phoneFilter});
        return Arrays.asList(userIds).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static long sendMessage(MessageInfo messageInfo) {
        try {
            long msgIdResult = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            return msgIdResult;
        }
        catch (Exception e) {
            logger.info("MessageUtils--sendMessage error", (Object)e);
            throw new KDException(new ErrorCode(SYS_BASE_SEND_MESSAGE, String.format(ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c%s", (String)"MessageUtils_0", (String)BAS_MESSAGE_COMMON, (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    public static boolean isMessageContentBeyondLimit(String content) {
        return content != null && (long)content.length() > 524288L;
    }
}

