/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;

public class MsgCacheUtil {
    private static DistributeSessionlessCache msgNoticeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("messagenotice", new DistributeCacheHAPolicy(true, true));

    public static void putCache(String msgId, Map<String, String> value, int timeOut, TimeUnit timeUnit) {
        msgNoticeCache.put(MsgCacheUtil.getMsgModalFormCacheKey(msgId + ""), value, timeOut, timeUnit);
    }

    private static String getMsgModalFormCacheKey(String msgId) {
        return "msg_notice_" + RequestContext.get().getAccountId() + "_msgId_" + msgId;
    }

    public static Map<String, String> getAll(String msgId) {
        return msgNoticeCache.getAll(MsgCacheUtil.getMsgModalFormCacheKey(msgId));
    }

    public static void remove(String msgId, String key) {
        msgNoticeCache.remove(MsgCacheUtil.getMsgModalFormCacheKey(msgId + ""), key);
    }

    public static void remove(String msgId) {
        msgNoticeCache.remove(MsgCacheUtil.getMsgModalFormCacheKey(msgId + ""));
    }

    public static void putCache(String key, String value, int timeOut, TimeUnit timeUnit) {
        msgNoticeCache.put(MsgCacheUtil.getMsgModalFormCacheKey(key + ""), (Object)value, timeOut, timeUnit);
    }

    public static String getString(String key) {
        return (String)msgNoticeCache.get(MsgCacheUtil.getMsgModalFormCacheKey(key));
    }
}

