/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class MsgSessionUtil {
    private static Log logger = LogFactory.getLog(MsgSessionUtil.class);

    public static String buildWebSocketAction(String actionName, Object param) {
        ArrayList acts = new ArrayList(10);
        HashMap<String, Object> action = new HashMap<String, Object>(16);
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>(10);
        action.put("p", paras);
        if (param instanceof List) {
            List p = (List)param;
            paras.addAll(p);
        } else {
            paras.add(param);
        }
        acts.add(action);
        return SerializationUtils.toJsonString(acts);
    }

    public static List<Long> getOnLineUserIds() {
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter useridFilter = new QFilter("userid", ">", (Object)0);
        QFilter logoutTimeFilter = new QFilter("logouttime", "is null", null);
        QFilter[] qFilters = new QFilter[]{useridFilter, logoutTimeFilter};
        try (DataSet ds = ORM.create().queryDataSet("getOnlineUserIds", "bos_smc_onlinesession_his", "userid", qFilters, null, -1, (Distinctable)WithDistinctable.get());){
            while (ds.hasNext()) {
                Row row = ds.next();
                userIds.add(row.getLong("userid"));
            }
        }
        logger.info("getOnlineUserIds size:" + userIds.size());
        return userIds;
    }

    public static Map<String, Map<String, List<String>>> getUserSessionLangGroupInfo(List<Long> userList, boolean isToAll) {
        ArrayList<UserSessionInfo> sessionList = new ArrayList<UserSessionInfo>(10);
        String accountId = RequestContext.get().getAccountId();
        for (Long userId : userList) {
            String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)userId.toString());
            if (sessionIds == null || sessionIds.length <= 0) continue;
            for (String sessionId : sessionIds) {
                SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
                String lang = sessionDAO.getAttribute("language");
                if (lang == null) {
                    lang = Lang.defaultLang().name();
                }
                UserSessionInfo sessionInfo = new UserSessionInfo(userId + "", sessionId, lang);
                sessionList.add(sessionInfo);
            }
        }
        Map<String, Map<String, List<String>>> userSessionMap = sessionList.stream().collect(Collectors.groupingBy(UserSessionInfo::getLang, Collectors.groupingBy(UserSessionInfo::getUserId, Collectors.mapping(UserSessionInfo::getSessionId, Collectors.toList()))));
        return userSessionMap;
    }

    private static class UserSessionInfo {
        private String userId;
        private String sessionId;
        private String lang;

        UserSessionInfo(String userId, String sessionId, String lang) {
            this.userId = userId;
            this.sessionId = sessionId;
            this.lang = lang;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getLang() {
            return this.lang;
        }
    }
}

