/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.id.ID;
import kd.bos.license.NextCloud;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.dto.PromoteMsg;
import kd.bos.message.dto.ShowPositionInfo;
import kd.bos.message.enums.MsgShowType;
import kd.bos.message.service.IPromoteMsgService;
import kd.bos.message.service.factory.PromoteMsgServiceFactory;
import kd.bos.message.util.MessageUtils;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class PromoteMsgUtils {
    private static final String ALL_USER = "allUser";
    public static final String PROMOTEMSG = "promotemsg";
    private static Log logger = LogFactory.getLog(PromoteMsgUtils.class);
    private static final String DEFAULT_HOST = "https://api.kingdee.com/";
    private static final String CLIENT_ID = NextCloud.CLIENT_ID;
    private static final String CLIENT_SECRET = NextCloud.CLIENT_SECRET;
    private static final String CATEGORY_CODE = "C05";
    private static final String MSG_KEY = "promoteMsg";
    private static Map<String, List<Long>> userIdsCache = new HashMap<String, List<Long>>();
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"promoteMsg");

    private static String getYptHost(String tenant) {
        String host = SystemPropertyUtils.getProptyByTenant((String)"ypt.host", (String)tenant);
        if (StringUtils.isEmpty((CharSequence)host)) {
            host = DEFAULT_HOST;
        }
        return RevProxyUtil.addSlash((String)host);
    }

    private static boolean isReceiveMessage() {
        boolean isReceive = true;
        String tenantId = RequestContext.get().getTenantId();
        String isReceiveStr = SystemPropertyUtils.getProptyByTenant((String)"is_receive_operation_message", (String)tenantId);
        if (isReceiveStr != null && "false".equalsIgnoreCase(isReceiveStr.trim())) {
            isReceive = false;
        }
        return isReceive;
    }

    public static void sendPromoteMsg() {
        if (!PromoteMsgUtils.isReceiveMessage()) {
            return;
        }
        LinkedHashMap<String, PromoteMsg> mapData = new LinkedHashMap<String, PromoteMsg>();
        IPromoteMsgService promoteMsgService = PromoteMsgServiceFactory.getPromoteMsgService();
        List<ShowPositionInfo> showPositionInfos = null;
        try {
            showPositionInfos = promoteMsgService.getShowPositionInfos();
        }
        catch (Exception e) {
            logger.info("getShowPositionInfos error", (Object)e);
        }
        if (CollectionUtils.isEmpty(showPositionInfos)) {
            return;
        }
        for (ShowPositionInfo position : showPositionInfos) {
            List<PromoteMsg> data = PromoteMsgUtils.getPromoteMsg(position.getLocationCode(), position.getVisitSource(), position.getCategoryCode());
            if (data == null || CollectionUtils.isEmpty(data)) continue;
            data.forEach(msg -> {
                msg.setMsgShowType(position.getMsgShowType());
                mapData.put(msg.getId(), (PromoteMsg)msg);
            });
        }
        PromoteMsgUtils.sendMsg(mapData);
    }

    private static List<PromoteMsg> getPromoteMsg(String locationCode, String visitSource, String categoryCode) {
        String tenantId = RequestContext.get().getTenantId();
        StringBuilder sb = new StringBuilder(PromoteMsgUtils.getYptHost(tenantId));
        String path = String.format("pushplatform/location/%s/content", locationCode);
        sb.append(path).append("?client_id=").append(CLIENT_ID);
        sb.append("&client_secret=").append(CLIENT_SECRET);
        sb.append("&category_code=").append(categoryCode);
        sb.append("&visit_source=").append(visitSource);
        sb.append("&limit=10");
        String url = sb.toString();
        String response = "";
        try {
            response = HttpClientUtils.get((String)url, PromoteMsgUtils.getHeader(), null);
            logger.info("ProductMsgUtils--result : " + response);
        }
        catch (Exception e) {
            logger.info("getPromoteMsg error", (Object)e);
        }
        return PromoteMsgUtils.wrapResult(response);
    }

    private static Map<String, String> getHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        String yptHost = PromoteMsgUtils.getYptHost(RequestContext.get().getTenantId());
        if (!DEFAULT_HOST.equals(yptHost)) {
            header.put("X-Gw", "api-gateway");
            header.put("X-Gw-Sign", "05c5ea841669df87ff4cb7553ec79d8ead2ea500");
            header.put("X-Gw-Time", "1628234624827");
        }
        return header;
    }

    private static List<PromoteMsg> wrapResult(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        try {
            JSONObject jason = (JSONObject)JSON.parse((String)data);
            Integer errcode = jason.getInteger("errcode");
            if (errcode != null && "200".equals(errcode.toString())) {
                JSONObject dataJson = jason.getJSONObject("data");
                Integer count = dataJson.getInteger("count");
                if (count == null || count == 0) {
                    return null;
                }
                JSONArray dataList = dataJson.getJSONArray("list");
                ArrayList<PromoteMsg> msgList = new ArrayList<PromoteMsg>(count);
                for (Object eachData : dataList.toArray()) {
                    JSONObject eachDataJson = (JSONObject)eachData;
                    String id = eachDataJson.getString("id");
                    String title = eachDataJson.getString("title");
                    String content = eachDataJson.getString("content");
                    String userDefinedParameter = eachDataJson.getString("userDefinedParameter");
                    JSONObject urlJson = eachDataJson.getJSONObject("url");
                    String url = urlJson.getString("value");
                    Long startTime = eachDataJson.getLong("startTime");
                    Long endTime = eachDataJson.getLong("endTime");
                    PromoteMsg msg = new PromoteMsg();
                    msg.setId(id);
                    msg.setTitle(title);
                    msg.setContent(content);
                    msg.setUrl(url);
                    msg.setStartTime(startTime);
                    msg.setEndTime(endTime);
                    PromoteMsgUtils.parseJsonParam(userDefinedParameter, msg);
                    msgList.add(msg);
                }
                Collections.reverse(msgList);
                return msgList;
            }
        }
        catch (Exception e) {
            logger.info("PromoteMsgUtils--wrapResult error", (Object)e);
        }
        return null;
    }

    private static void parseJsonParam(String userDefinedParameter, PromoteMsg msg) {
        if (userDefinedParameter != null) {
            try {
                Object duration;
                Object cloudType;
                Map map = (Map)SerializationUtils.fromJsonString((String)userDefinedParameter, Map.class);
                Object appNums = map.get("appNum");
                if (appNums != null) {
                    msg.setAppNums(appNums.toString());
                }
                if ((cloudType = map.get("cloudType")) != null) {
                    msg.setCloudType(cloudType.toString());
                }
                if ((duration = map.get("duration")) != null && StringUtils.isNumeric((CharSequence)duration.toString())) {
                    msg.setDuration(Integer.parseInt(duration.toString()) * 1000);
                }
            }
            catch (Exception e) {
                logger.info("parseJsonParam error", (Object)e);
            }
        }
    }

    private static void sendMsg(Map<String, PromoteMsg> mapData) {
        ArrayList<String> msgIds = new ArrayList<String>(mapData.keySet());
        List<String> msgIdRecords = PromoteMsgUtils.getAllRecord();
        logger.info(String.format("msgIdRecords:%s", msgIdRecords));
        ArrayList<String> msgIdRecordsCopy = new ArrayList<String>(msgIdRecords);
        msgIdRecordsCopy.removeAll(msgIds);
        if (!CollectionUtils.isEmpty(msgIdRecordsCopy)) {
            PromoteMsgUtils.deleteRecord(msgIdRecordsCopy);
        }
        ArrayList<String> msgIdsCopy = new ArrayList<String>(msgIds);
        msgIdsCopy.removeAll(msgIdRecords);
        if (!CollectionUtils.isEmpty(msgIdsCopy)) {
            logger.info("send msgIds:" + String.format("[%s]", String.join((CharSequence)",", msgIdsCopy)));
            for (String msgId : msgIdsCopy) {
                PromoteMsg msg = mapData.get(msgId);
                String localId = PromoteMsgUtils.doSendMessage(msg);
                if (localId == null) continue;
                PromoteMsgUtils.insertRecord(msgId, localId, msg.getEndTime());
            }
            userIdsCache.clear();
        }
    }

    private static String doSendMessage(PromoteMsg msg) {
        String appNum;
        boolean isSend = PromoteMsgUtils.isSendCloudType(msg.getCloudType());
        if (!isSend) {
            return null;
        }
        String appNums = msg.getAppNums();
        MsgShowType msgShowType = msg.getMsgShowType();
        List<Long> userIds = PromoteMsgUtils.getSendUserIds(appNums);
        if (userIds == null || CollectionUtils.isEmpty(userIds)) {
            logger.info("no user to send");
            return null;
        }
        if (MsgShowType.CENTER != msgShowType) {
            List<Long> notRecvUserIds = PromoteMsgUtils.getNotRecvUserIds();
            userIds.removeAll(notRecvUserIds);
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("activity");
        messageInfo.setNotifyType("sysnotice");
        messageInfo.setTitle(msg.getTitle());
        messageInfo.setContent(msg.getContent());
        HashMap params = new HashMap();
        HashMap<String, Object> systemNotice = new HashMap<String, Object>();
        systemNotice.put("showType", msgShowType.getValue());
        systemNotice.put("url", msg.getUrl());
        Long startTime = msg.getStartTime();
        Long endTime = msg.getEndTime();
        if (startTime != null && endTime != null) {
            Long timeOut = endTime - startTime;
            systemNotice.put("timeOut", timeOut);
        } else {
            systemNotice.put("timeOut", 86400000);
        }
        Integer duration = msg.getDuration();
        if (duration != null) {
            systemNotice.put("duration", duration);
        }
        if ((appNum = msg.getAppNums()) != null) {
            systemNotice.put("appNum", appNum);
        }
        params.put("systemNotice", systemNotice);
        messageInfo.setParams(params);
        messageInfo.setUserIds(userIds);
        long msgId = MessageUtils.sendMessage(messageInfo);
        return String.valueOf(msgId);
    }

    private static boolean isSendCloudType(String cloudType) {
        if (StringUtils.isEmpty((CharSequence)cloudType)) {
            return true;
        }
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        logger.info("isPublicTenant:" + pubTenantType);
        String tenantType = "private";
        if (Boolean.parseBoolean(pubTenantType)) {
            tenantType = "public";
        }
        tenantType = PromoteMsgUtils.getCloudTypeProp(tenantType);
        String[] type = cloudType.split(",");
        return Arrays.asList(type).contains(tenantType);
    }

    private static String getCloudTypeProp(String tenantType) {
        String tenantId = RequestContext.get().getTenantId();
        String cloudTypeProp = SystemPropertyUtils.getProptyByTenant((String)"promote.portal.cloudtype", (String)tenantId);
        if (cloudTypeProp != null) {
            tenantType = cloudTypeProp;
        }
        return tenantType;
    }

    private static List<Long> getNotRecvUserIds() {
        QFilter filter = new QFilter("receivemessage", "=", (Object)Boolean.FALSE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_user_params_config", (String)"userid", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> notRecvUserIds = new ArrayList<Long>(10);
        for (DynamicObject dy : dynamicObjects) {
            DynamicObject userdy = dy.getDynamicObject("userid");
            if (userdy == null) continue;
            notRecvUserIds.add(userdy.getLong("id"));
        }
        return notRecvUserIds;
    }

    private static List<Long> getSendUserIds(String appNums) {
        List allUserApps;
        if (StringUtils.isEmpty((CharSequence)appNums)) {
            return PromoteMsgUtils.getAllUserIds();
        }
        String[] appNumArr = appNums.split(",");
        List availableApps = Arrays.stream(appNumArr).map(appNum -> {
            try {
                return AppMetadataCache.getAppInfo((String)appNum);
            }
            catch (Exception e) {
                logger.info("getAppInfo error, appNum:" + appNum, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (PromoteMsgUtils.onlyShowBuyApp()) {
            Set apps = LicenseServiceHelper.getAvailableApps();
            if (apps == null || apps.size() == 0) {
                return null;
            }
            logger.info("PromoteMsgUtils--LicenseServiceHelper--getAvailableApps:" + SerializationUtils.toJsonString((Object)apps));
            availableApps = availableApps.stream().filter(appInfo -> apps.contains(appInfo.getId())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(allUserApps = availableApps.stream().filter(AppInfo::isAllUserApp).collect(Collectors.toList()))) {
            return PromoteMsgUtils.getAllUserIds();
        }
        List<String> appNumList = availableApps.stream().map(AppInfo::getAppId).collect(Collectors.toList());
        return PromoteMsgUtils.getUserIdsByApp(appNumList);
    }

    private static boolean onlyShowBuyApp() {
        boolean onlyShowBuyApp = false;
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object only_show_buy_app = systemParamService.loadPublicParameterFromCache("only_show_buy_app");
            if (only_show_buy_app != null && Boolean.parseBoolean(only_show_buy_app.toString())) {
                onlyShowBuyApp = true;
            }
        }
        catch (Exception e) {
            logger.info("onlyShowBuyApp error", (Object)e);
        }
        return onlyShowBuyApp;
    }

    private static List<Long> getAllUserIds() {
        List<Long> userIdsCacheData = userIdsCache.get(ALL_USER);
        if (userIdsCacheData != null) {
            return userIdsCacheData;
        }
        String sql = "select fid from t_sec_user where fenable='1'";
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        try (DataSet dataSet = DB.queryDataSet((String)"promote_msg", (DBRoute)DBRoute.base, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                userIds.add(row.getLong("fid"));
            }
        }
        userIdsCache.put(ALL_USER, userIds);
        return userIds;
    }

    private static List<Long> getUserIdsByApp(List<String> appNumList) {
        HashSet userIdSet = new HashSet();
        HashMap<String, Future> futureMap = new HashMap<String, Future>();
        appNumList.forEach(appNum -> {
            List<Long> userIdsCacheData = userIdsCache.get(appNum);
            if (userIdsCacheData != null) {
                userIdSet.addAll(userIdsCacheData);
            } else {
                AppInfo appInfo = null;
                try {
                    appInfo = AppMetadataCache.getAppInfo((String)appNum);
                }
                catch (Exception e) {
                    logger.info("getAppInfo error", (Object)e);
                }
                if (appInfo != null) {
                    String appId = appInfo.getId();
                    Future future = threadPool.submit(() -> PermissionServiceHelper.getAppUser((String)appId));
                    futureMap.put((String)appNum, future);
                }
            }
        });
        futureMap.forEach((appNum, future) -> {
            try {
                Set appUsers = (Set)future.get();
                if (appUsers != null) {
                    userIdsCache.put((String)appNum, new ArrayList(appUsers));
                    logger.info(String.format("PromoteMsgUtils--getSendUserIdByApp:%s, size:%s", appNum, appUsers.size()));
                    userIdSet.addAll(appUsers);
                }
            }
            catch (Exception e) {
                logger.info("get appUser error", (Object)e);
            }
        });
        return new ArrayList<Long>(userIdSet);
    }

    private static void insertRecord(String msgId, String localId, Long validTime) {
        String insertSql = "insert into T_MSG_PROMOTE (FID, FMESSAGEID, FLOCALID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, fvalidatetime) values(?,?,?,?,?,?,?,?)";
        Date date = new Date();
        Object[] param = new Object[]{ID.genLongId(), msgId, Long.valueOf(localId), 1, date, 1, date, new Date(validTime)};
        DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])param);
    }

    private static void deleteRecord(List<String> msgIds) {
        String placeholder = PromoteMsgUtils.buildPlaceholder(msgIds.size());
        String deleteSql = String.format("delete from T_MSG_PROMOTE where FMESSAGEID in (%s) and fValidateTime < ?", placeholder);
        Object[] params = msgIds.toArray(new Object[msgIds.size() + 1]);
        params[msgIds.size()] = new Date();
        DB.execute((DBRoute)DBRoute.base, (String)deleteSql, (Object[])params);
    }

    private static List<String> getAllRecord() {
        String selectSql = "select FMESSAGEID from T_MSG_PROMOTE";
        return (List)DB.query((DBRoute)DBRoute.base, (String)selectSql, rs -> {
            ArrayList<String> msgIds = new ArrayList<String>(10);
            while (rs.next()) {
                msgIds.add(rs.getString("fmessageid"));
            }
            return msgIds;
        });
    }

    private static String buildPlaceholder(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("?,");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }
}

