/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.notification.NotificationClientCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;

public class MsgNoticeDeleteWebApiPlugin
implements IBillWebApiPlugin {
    public static final String BAS_MESSAGE_FORMPLUGIN = "bas-message-formplugin";
    private static Log logger = LogFactory.getLog(MsgNoticeDeleteWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("MsgNoticeDeleteWebApiPlugin--params:" + SerializationUtils.toJsonString(params));
        if (CollectionUtils.isEmpty(params)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"MsgNoticeDeleteWebApiPlugin_0", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
        Object msgId = params.get("msgId");
        if (msgId == null || StringUtils.isBlank((String)msgId.toString())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MsgNoticeDeleteWebApiPlugin_1", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
        if (!StringUtils.isNumeric((String)msgId.toString())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6d88\u606fID\u9700\u8981\u4e3a\u6570\u5b57\u3002", (String)"MsgNoticeDeleteWebApiPlugin_4", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
        try {
            Object resultCode;
            Map data = MessageCenterServiceHelper.deleteMessage(Collections.singletonList(msgId));
            if (data != null && (resultCode = data.get("code")) != null && "0".equals(resultCode.toString())) {
                this.closeForm(msgId + "");
                return ApiResult.success((Object)msgId);
            }
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u6d88\u606fID\u4e0d\u5b58\u5728\u3002", (String)"MsgNoticeDeleteWebApiPlugin_3", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
        catch (Exception e) {
            logger.info("MsgNoticeDeleteWebApiPlugin--error", (Object)e);
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25", (String)"MsgNoticeDeleteWebApiPlugin_2", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
    }

    private void closeForm(String msgId) {
        Map msgFormCache = MsgCacheUtil.getAll((String)msgId);
        logger.info("MsgNoticeDeleteWebApiPlugin--closeForm sessionInfo:" + SerializationUtils.toJsonString((Object)msgFormCache));
        if (!CollectionUtils.isEmpty((Map)msgFormCache)) {
            msgFormCache.forEach((k, v) -> {
                PushMessage pushMessage = new PushMessage(PushMessageRange.Session, k, v);
                PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
            });
            MsgCacheUtil.remove((String)msgId);
        } else {
            List list = MsgSessionUtil.getOnLineUserIds();
            logger.info("MsgNoticeDeleteWebApiPlugin--closeForm getOnLineUserIds" + SerializationUtils.toJsonString((Object)list));
            list.forEach(userId -> {
                NotificationServiceHelper.sendIgnoreNotification((String)(userId + ""), (String)msgId);
                NotificationClientCache.removeNotification((String)(userId + ""), (String)msgId);
            });
        }
    }
}

