/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.enums.SendStatus;
import kd.bos.message.util.DelTagsUtil;
import kd.bos.message.util.MessageUtils;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MsgNoticeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BAS_MESSAGE_FORMPLUGIN = "bas-message-formplugin";
    private static final String TOALL = "toall";
    private static final String TITLE = "title";
    private static final String ADMINORG = "adminorg";
    private static final String USERTYPE = "usertype";
    private static final String USER = "user";
    private static final String PREVIEW = "preview";
    private static final String INTE_SYSLANG = "inte_syslang";
    private static final String INTE_SYSLANG_CACHE = "inte_syslang_cache";
    private static Log logger = LogFactory.getLog(MsgNoticeEditPlugin.class);
    private static final String KEY_MAINBAR = "tbmain";
    private static final String BTN_SEND = "bar_send";
    private static final String BTN_SAVE = "bar_save";
    private static final String CONTENT_EDITOR = "contenteditor";
    private static final String CONTENT = "content";
    private static final String PROPERTY_CACHE = "property_cache";
    private static final String CONTENT_CACHE = "content_cache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl(ADMINORG);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit userEdit = (MulBasedataEdit)this.getControl(USER);
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit usertypeEdit = (MulBasedataEdit)this.getControl(USERTYPE);
        usertypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object sendstatus = this.getModel().getValue("sendstatus");
        if (sendstatus != null && SendStatus.SENT.getCode().toString().equals(sendstatus.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SEND, BTN_SAVE});
        }
        String defaultLang = this.getIntLang();
        this.setContext(defaultLang);
        this.controlMsgRange();
        this.hideSendMsgRange();
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (parameter != null) {
            Object pkId = parameter.getPkId();
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"msg_notice_content_lang", (QFilter[])new QFilter[]{new QFilter("notice_id", "=", pkId)});
            String defaultLang = this.getDefaultLang();
            for (Map.Entry objectEntry : dynamicObjectMap.entrySet()) {
                DynamicObject value = (DynamicObject)objectEntry.getValue();
                this.initContentValue(defaultLang, value);
            }
        }
    }

    private void setContext(String defaultLang) {
        Long id = (Long)this.getModel().getValue("id");
        if (null != id && id > 0L) {
            Map objectMap = MessageUtils.getNoticeContent((Long)id);
            for (Map.Entry objectEntry : objectMap.entrySet()) {
                DynamicObject value = (DynamicObject)objectEntry.getValue();
                this.initContentValue(defaultLang, value);
            }
        }
    }

    private void initContentValue(String defaultLang, DynamicObject value) {
        this.saveMutLangContentCache(value.getString("localeid"), value.getString("localeid"), value.getString(CONTENT));
        if (defaultLang.equals(value.getString("localeid"))) {
            this.setTextValueByDB(value.getString(CONTENT));
        }
    }

    private String getIntLang() {
        ComboEdit sysLangEdit = (ComboEdit)this.getControl(INTE_SYSLANG);
        List enabledLangs = InteServiceHelper.getEnabledLang();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(enabledLangs.size());
        String defValue = "zh_CN";
        for (EnabledLang enabledLang : enabledLangs) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(enabledLang.getNumber());
            comboItem.setCaption(new LocaleString(enabledLang.getName()));
            if (enabledLang.isDefault.booleanValue()) {
                defValue = enabledLang.getNumber();
            }
            comboItemList.add(comboItem);
        }
        this.getModel().setValue("INTE_SYSLANG", (Object)defValue);
        sysLangEdit.setComboItems(comboItemList);
        return defValue;
    }

    private String getDefaultLang() {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        String defValue = "zh_CN";
        for (EnabledLang enabledLang : enabledLangs) {
            if (!enabledLang.isDefault.booleanValue()) continue;
            defValue = enabledLang.getNumber();
        }
        return defValue;
    }

    private void hideSendMsgRange() {
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        boolean isSubAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"20");
        if (isSubAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TOALL, USERTYPE});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (INTE_SYSLANG.equals(propName)) {
            if ("0".equals(this.getPageCache().get("change_sys_lang"))) {
                this.getPageCache().remove("change_sys_lang");
                return;
            }
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (StringUtils.isBlank((CharSequence)oldValue)) {
                return;
            }
            String content = this.getTextValue();
            this.saveChangeContentCache(oldValue, content);
            this.setTextValue(newValue);
            this.getModel().setDataChanged(false);
            return;
        }
        this.putCacheSet(PROPERTY_CACHE, e.getProperty().getDisplayName().getLocaleValue());
        if (TOALL.equals(propName)) {
            this.controlMsgRange();
        }
    }

    private void setTextValue(String newValue) {
        String bigObject = this.getPageCache().getBigObject(newValue + CONTENT_CACHE);
        this.setTextValueByDB(bigObject);
    }

    private void setTextValueByDB(String value) {
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(CONTENT_EDITOR);
        richTextEditor.setText(value);
    }

    private void saveMutLangContentCache(String oldValue, String newValue, String contentFromPage) {
        this.putCacheSet(INTE_SYSLANG_CACHE, newValue);
        if (StringUtils.isNotBlank((CharSequence)contentFromPage)) {
            this.getPageCache().putBigObject(oldValue + CONTENT_CACHE, contentFromPage);
        }
    }

    private void saveChangeContentCache(String key, String contentFromPage) {
        this.putCacheSet(INTE_SYSLANG_CACHE, key);
        this.getPageCache().putBigObject(key + CONTENT_CACHE, contentFromPage);
    }

    private void putCacheSet(String key, String value) {
        String propertyCache = this.getPageCache().get(key);
        Set property = propertyCache != null ? (Set)SerializationUtils.fromJsonString((String)propertyCache, Set.class) : new HashSet();
        property.add(value);
        this.getPageCache().put(key, SerializationUtils.toJsonString(property));
    }

    private Set<String> getCacheSet(String key) {
        String propertyCache = this.getPageCache().get(key);
        if (propertyCache != null) {
            return (Set)SerializationUtils.fromJsonString((String)propertyCache, Set.class);
        }
        return Collections.emptySet();
    }

    private void controlMsgRange() {
        Object toall = this.getModel().getValue(TOALL);
        if (toall != null && Boolean.parseBoolean(toall.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADMINORG, USERTYPE, USER});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{ADMINORG, USERTYPE, USER});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        boolean isSend;
        super.afterDoOperation(a);
        String opKey = a.getOperateKey();
        OperationResult opResult = a.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if ("send".equals(opKey) && (isSend = this.sendMsg())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE, BTN_SEND});
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "showtype", "validtime", TOALL, ADMINORG, USERTYPE, USER, TITLE, CONTENT_EDITOR});
        }
        if (a.getSource() instanceof Save) {
            Long id = (Long)this.getModel().getValue("id");
            Set<String> cacheSet = this.getCacheSet(INTE_SYSLANG_CACHE);
            ArrayList datas = new ArrayList(cacheSet.size());
            cacheSet.forEach(key -> {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"msg_notice_content_lang");
                object.set("notice_id", (Object)id);
                object.set("localeid", key);
                String bigObject = this.getPageCache().getBigObject(key + CONTENT_CACHE);
                if (StringUtils.isNotBlank((CharSequence)bigObject)) {
                    object.set(CONTENT, (Object)bigObject);
                    datas.add(object);
                }
            });
            DeleteServiceHelper.delete((String)"msg_notice_content_lang", (QFilter[])new QFilter[]{new QFilter("notice_id", "=", (Object)id)});
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            this.getPageCache().remove(PROPERTY_CACHE);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (PREVIEW.equals(key) || BTN_SEND.equals(key)) {
            this.copyRichtextedit2Content();
        }
        if (BTN_SAVE.equals(key)) {
            this.copyRichtextedit2Content();
            this.setTextValueToContentBeforeSave();
            if (!this.validate()) {
                evt.setCancel(true);
            }
        }
    }

    private void setTextValueToContentBeforeSave() {
        String text = this.getTextValue();
        if (StringUtils.isBlank((CharSequence)text)) {
            Set<String> cacheSet = this.getCacheSet(INTE_SYSLANG_CACHE);
            Iterator<String> iterator = cacheSet.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                String bigObject = this.getPageCache().getBigObject(key + CONTENT_CACHE);
                if (!StringUtils.isNotBlank((CharSequence)bigObject)) continue;
                this.getPageCache().put("change_sys_lang", "0");
                iterator.remove();
                this.getPageCache().put(INTE_SYSLANG_CACHE, SerializationUtils.toJsonString(cacheSet));
                this.setTextValue(key);
                this.changeSysLang(key);
                text = bigObject;
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            text = "";
        }
        String textFromHtml = StringUtils.isBlank((CharSequence)text) ? "" : DelTagsUtil.getTextFromHtml((String)text);
        text = textFromHtml.length() > 0 || text.contains("<img") ? text : textFromHtml;
        this.getModel().setValue(CONTENT, (Object)text);
        this.getModel().setValue("content_tag", (Object)text);
    }

    private void changeSysLang(String key) {
        this.getModel().setValue(INTE_SYSLANG, (Object)key);
    }

    private boolean validate() {
        String text;
        OrmLocaleValue title = (OrmLocaleValue)this.getModel().getValue(TITLE);
        if (title == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6d88\u606f\u6807\u9898\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MsgNoticeEditPlugin_4", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        String titleErrMsg = this.checkTitleAndContent(title);
        if (StringUtils.isNotBlank((CharSequence)titleErrMsg)) {
            this.getView().showTipNotification(titleErrMsg);
            return false;
        }
        Object validTime = this.getModel().getValue("validtime");
        if (validTime == null || Integer.parseInt(validTime.toString()) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6709\u6548\u65f6\u95f4\uff08\u5206\u949f\uff09\u201d\u3002", (String)"MsgNoticeEditPlugin_5", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        Boolean toall = (Boolean)this.getModel().getValue(TOALL);
        if (!toall.booleanValue()) {
            DynamicObjectCollection adminorg = (DynamicObjectCollection)this.getModel().getValue(ADMINORG);
            DynamicObjectCollection usertype = (DynamicObjectCollection)this.getModel().getValue(USERTYPE);
            DynamicObjectCollection user = (DynamicObjectCollection)this.getModel().getValue(USER);
            if (CollectionUtils.isEmpty((Collection)adminorg) && CollectionUtils.isEmpty((Collection)usertype) && CollectionUtils.isEmpty((Collection)user)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u9879\u53d1\u5e03\u8303\u56f4\u3002", (String)"MsgNoticeEditPlugin_2", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        if ((text = this.getTextValue()) != null && !DelTagsUtil.validHtmlContent((String)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6cd5\u653b\u51fb\u3002", (String)"MsgNoticeEditPlugin_11", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String checkTitleAndContent(OrmLocaleValue title) {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangs) {
            String bigObject = this.getPageCache().getBigObject(enabledLang.getNumber() + CONTENT_CACHE);
            if (StringUtils.isNotBlank((CharSequence)bigObject) && StringUtils.isBlank((CharSequence)title.get((Object)enabledLang.getNumber()))) {
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1s\u7684\u201c\u6d88\u606f\u6807\u9898\u201d\u3002", (String)"MsgNoticeEditPlugin_12", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), enabledLang.getName());
            }
            if (!MessageUtils.isMessageContentBeyondLimit((String)bigObject)) continue;
            return String.format(ResManager.loadKDString((String)"%1s\u8bed\u8a00\u4e0b\u7684\u201c\u6d88\u606f\u5185\u5bb9\u201d\u5927\u5c0f\u8d85\u8fc71M\u9650\u5236\u3002", (String)"MsgNoticeEditPlugin_13", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), enabledLang.getName());
        }
        return null;
    }

    private void copyRichtextedit2Content() {
        String value = (String)this.getModel().getValue(INTE_SYSLANG);
        this.saveChangeContentCache(value, this.getTextValue());
    }

    private String getTextValue() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(CONTENT_EDITOR);
        String text = richTextEditor.getText();
        return text;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (PREVIEW.equals(key)) {
            this.previewMsg();
        }
    }

    private boolean sendMsg() {
        if (this.checkValueChange()) {
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)"msg_notice");
            try {
                long msgId = MessageUtils.sendMessage((DynamicObject)data);
                data.set("messageid", (Object)msgId);
                data.set("sendstatus", (Object)SendStatus.SENT.getCode());
                data.set("sendtime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f\u3002", (String)"MsgNoticeEditPlugin_7", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            catch (Exception e) {
                logger.info("MsgNoticeEditPlugin--sendMsg", (Object)e);
                this.getView().showTipNotification(e.getMessage());
                return false;
            }
        }
        return false;
    }

    private boolean checkValueChange() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"MsgNoticeEditPlugin_3", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        String property = this.getPageCache().get(PROPERTY_CACHE);
        if (property != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"MsgNoticeEditPlugin_6", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void previewMsg() {
        if (this.checkValueChange()) {
            Long id = (Long)this.getModel().getValue("id");
            Map noticeContent = MessageUtils.getNoticeContent((Long)id);
            String lang = (String)this.getModel().getValue(INTE_SYSLANG);
            Optional<DynamicObject> dynamicObject = noticeContent.entrySet().stream().map(v -> (DynamicObject)v.getValue()).filter(v -> v.getString("localeid") != null && v.getString("localeid").equals(lang)).findFirst();
            if (!dynamicObject.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6d88\u606f\u8bed\u8a00\u4e0b\u6ca1\u6709\u6d88\u606f\u5185\u5bb9\u3002", (String)"MsgNoticeEditPlugin_9", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            DynamicObject dyObject = dynamicObject.get();
            String content = dyObject.getString(CONTENT);
            if (StringUtils.isBlank((CharSequence)content)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6d88\u606f\u8bed\u8a00\u4e0b\u6ca1\u6709\u6d88\u606f\u5185\u5bb9\u3002", (String)"MsgNoticeEditPlugin_9", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String showType = (String)this.getModel().getValue("showtype");
            if ("3".equals(showType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9884\u89c8\u2018\u5217\u8868\u63d0\u793a\u2019\u5c55\u73b0\u5f62\u5f0f\u3002", (String)"MsgNoticeEditPlugin_8", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String title = ((OrmLocaleValue)this.getModel().getValue(TITLE)).get((Object)lang);
            if ("2".equals(showType)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                NotificationBody notificationBody = new NotificationBody();
                notificationBody.setAppId("bos");
                notificationBody.setTitle(title);
                notificationBody.setContent(DelTagsUtil.getTextFromHtml((String)content));
                notificationBody.setNotificationId(String.valueOf(System.currentTimeMillis()));
                notificationBody.setIconType(IconType.Info.toString());
                NotificationBody.ButtonInfo ignoreButton = new NotificationBody.ButtonInfo();
                ignoreButton.setKey("ignore");
                ignoreButton.setText(ResManager.loadKDString((String)"\u5ffd\u7565", (String)"MsgNoticeEditPlugin_10", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                notificationBody.addButtonInfo(ignoreButton);
                ArrayList<NotificationBody> msgList = new ArrayList<NotificationBody>();
                msgList.add(notificationBody);
                HashMap<String, ArrayList<NotificationBody>> data = new HashMap<String, ArrayList<NotificationBody>>(16);
                data.put("notification", msgList);
                proxy.addAction("showNotification", data);
            } else {
                FormShowParameter fsp2 = new FormShowParameter();
                String formId = "msg_notice_modal";
                fsp2.setFormId(formId);
                fsp2.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("message", content);
                map.put(TITLE, title);
                fsp2.setCustomParams(map);
                fsp2.setShowTitle(false);
                fsp2.setShowClose(false);
                this.getView().showForm(fsp2);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        FormShowParameter fsp = evt.getFormShowParameter();
        if (fsp instanceof ListShowParameter) {
            ListShowParameter lsp = (ListShowParameter)fsp;
            String formId = lsp.getBillFormId();
            if ("bos_user".equals(formId)) {
                ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>(1);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                long userId = Long.parseLong(RequestContext.get().getUserId());
                UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
                if (!userScopeResult.isAllUser()) {
                    List userIds = userScopeResult.getUserIDs();
                    rangeFilterList.add(enableFilter.and(new QFilter("id", "in", (Object)userIds)));
                }
                lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
            } else if ("bos_usertype".equals(formId)) {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
                QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
                filterList.add(visibleFilter);
                lsp.setListFilterParameter(new ListFilterParameter(filterList, null));
            }
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            lsp.setCustomParam("externalUserType", (Object)"all");
        }
    }
}

