/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.enums.MsgShowType;
import kd.bos.message.enums.SendStatus;
import kd.bos.message.util.MessageUtils;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgLocalCacheUtils;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.notification.NotificationClientCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;

public class MsgNoticeListPlugin
extends AbstractListPlugin {
    public static final String MSG_NOTICE = "msg_notice";
    public static final String SENDSTATUS = "sendstatus";
    public static final String BAS_MESSAGE_FORMPLUGIN = "bas-message-formplugin";
    private static Log logger = LogFactory.getLog(MsgNoticeListPlugin.class);
    private static final String KEY_MAINBAR = "tbmain";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        long userId = RequestContext.get().getCurrUserId();
        Set adminGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)userId, (boolean)true, (String)"1");
        Set adminGroupIds = adminGroupIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
        Map admGrpUserIdSetMap = AdminGroupHelper.getAdmGrpUserIdSetMap(adminGroupIds, (boolean)false);
        Set userIds = admGrpUserIdSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (!isAdmin) {
            QFilter userFilter = new QFilter("creator", "in", userIds);
            qFilters.add(userFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        Object iscopy = param.getCustomParam("iscopy");
        Long id = (Long)param.getPkId();
        if (id != null) {
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)MSG_NOTICE);
            Integer sendstatus = data.getInt(SENDSTATUS);
            if (iscopy == null && SendStatus.SENT.getCode().equals(sendstatus)) {
                param.setBillStatus(BillOperationStatus.VIEW);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "send": {
                this.sendMsg();
                break;
            }
            case "rollback": {
                this.deleteMsg();
                break;
            }
        }
    }

    private void sendMsg() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        for (ListSelectedRow row : rows) {
            long id = (Long)row.getPrimaryKeyValue();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)MSG_NOTICE);
            this.doSendMessage(data);
        }
    }

    private void doSendMessage(DynamicObject data) {
        try {
            long msgId = MessageUtils.sendMessage((DynamicObject)data);
            data.set("messageid", (Object)msgId);
            data.set(SENDSTATUS, (Object)SendStatus.SENT.getCode());
            data.set("sendtime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)data);
            ((IListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f\u3002", (String)"MsgNoticeListPlugin_1", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void deleteMsg() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        for (ListSelectedRow row : rows) {
            long id = (Long)row.getPrimaryKeyValue();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)MSG_NOTICE);
            this.doDeleteMessage(data);
        }
    }

    private void doDeleteMessage(DynamicObject data) {
        try {
            Integer sendstatus = data.getInt(SENDSTATUS);
            if (SendStatus.RECALL.getCode().equals(sendstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5df2\u64a4\u56de\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MsgNoticeListPlugin_2", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (SendStatus.UNSENT.getCode().equals(sendstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u672a\u53d1\u9001\u3002", (String)"MsgNoticeListPlugin_5", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            long msgId = data.getLong("messageid");
            MessageCenterServiceHelper.deleteMessage(Collections.singletonList(msgId));
            data.set(SENDSTATUS, (Object)SendStatus.RECALL.getCode());
            SaveServiceHelper.update((DynamicObject)data);
            int showType = data.getInt("showtype");
            ThreadPools.executeOnce((String)(((Object)((Object)this)).getClass().getName() + ":closeForm"), () -> this.closeForm(showType + "", msgId + ""));
            ((IListView)this.getView()).refresh();
            MsgLocalCacheUtils.remove((String)(msgId + ""));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\u3002", (String)"MsgNoticeListPlugin_3", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.info("MsgNoticeListPlugin--doDeleteMessage--error", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void closeForm(String showType, String msgId) {
        if (MsgShowType.CENTER.getValue().equals(showType)) {
            Map msgFormCache = MsgCacheUtil.getAll((String)msgId);
            if (msgFormCache != null) {
                logger.info("MsgNoticeListPlugin--closeForm sessionInfo:" + msgFormCache.size());
                msgFormCache.forEach((sessionId, pageId) -> {
                    HashMap<String, String> pageMap = new HashMap<String, String>(16);
                    pageMap.put("pageId", (String)pageId);
                    String closeMsg = MsgSessionUtil.buildWebSocketAction((String)"closeWindow", pageMap);
                    PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)closeMsg);
                    PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
                });
            }
        } else if (MsgShowType.BOTTOM_RIGHT.getValue().equals(showType)) {
            String cacheValue = MsgCacheUtil.getString((String)(msgId + ""));
            if (cacheValue == null) {
                return;
            }
            List list = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            logger.info("MsgNoticeListPlugin--closeForm getUserIds:" + cacheValue);
            list.forEach(userId -> {
                NotificationServiceHelper.sendIgnoreNotification((String)userId, (String)msgId);
                NotificationClientCache.removeNotification((String)userId, (String)msgId);
            });
        }
        MsgCacheUtil.remove((String)msgId);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String isAdminParam = (String)e.getFormShowParameter().getCustomParam("isAdmin");
        if (Boolean.parseBoolean(isAdminParam)) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"MsgNoticeListPlugin_4", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }
}

