/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.plugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.util.MessageUtils;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.ILocalStringUtil;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;

public class MsgNoticePagePlugin
extends AbstractFormPlugin {
    private static final String BTN_DETAIL = "bar_detail";
    private static final String BTN_IGNORE = "bar_ignore";
    private static final String BTN_OK = "bar_ok";
    private static final String BTN_CLOSE = "bar_close";
    private static final String MSG_ID = "msgId";
    private static final String MSG_MODAL = "msg_notice_modal";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DETAIL, BTN_IGNORE, BTN_OK, BTN_CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        String formId = formShowParameter.getFormId();
        Object msgId = params.get(MSG_ID);
        if (msgId != null) {
            this.getPageCache().put(MSG_ID, msgId.toString());
        }
        Button buttonDe = (Button)this.getView().getControl(BTN_DETAIL);
        Button buttonOk = (Button)this.getView().getControl(BTN_OK);
        Object url = params.get("url");
        if (url != null) {
            buttonOk.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK});
            this.getPageCache().put("url", url.toString());
        } else {
            buttonDe.getView().setVisible(Boolean.FALSE, new String[]{BTN_DETAIL});
        }
        Object isMsgNotice = params.get("isMsgNotice");
        if (msgId != null && isMsgNotice != null && Boolean.parseBoolean(isMsgNotice.toString())) {
            this.initMsgNotice(Long.parseLong(msgId.toString()));
        } else {
            Object title;
            Object message = params.get("message");
            if (MSG_MODAL.equals(formId) && (title = params.get("title")) != null) {
                this.getModel().setValue("title", title);
            }
            if (message != null) {
                Html htmlMsg = (Html)this.getView().getControl("message");
                htmlMsg.setConent(message.toString());
            }
        }
    }

    private void initMsgNotice(long msgId) {
        QFilter qFilter = new QFilter("messageid", "=", (Object)msgId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"msg_notice", (QFilter[])new QFilter[]{qFilter});
        ILocaleString noticeTitle = dynamicObject.getLocaleString("title");
        LocaleString noticeContent = MessageUtils.wrapNoticeContent((Long)((Long)dynamicObject.getPkValue()));
        String lang = RequestContext.get().getLang().name();
        String finalTitle = ILocalStringUtil.getValueByLang((ILocaleString)noticeTitle, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)"");
        String fnialContent = ILocalStringUtil.getValueByLang((ILocaleString)noticeContent, (String)lang, (ILocalStringUtil.LangSort)ILocalStringUtil.DEFAULT_SORT, (String)"");
        this.getModel().setValue("title", (Object)finalTitle);
        Html htmlMsg = (Html)this.getView().getControl("message");
        htmlMsg.setConent(fnialContent);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "bar_detail": {
                this.openUrl();
                this.getView().close();
                break;
            }
            case "bar_ignore": 
            case "bar_ok": {
                this.setMsgReadState();
                break;
            }
            case "bar_close": {
                this.setMsgPopup();
                break;
            }
        }
    }

    private void openUrl() {
        String url = this.getPageCache().get("url");
        if (StringUtils.isNotEmpty((String)url)) {
            this.getView().openUrl(url);
        }
        this.setMsgReadState();
    }

    private void setMsgReadState() {
        String msgId = this.getPageCache().get(MSG_ID);
        Long userId = RequestContext.get().getCurrUserId();
        if (msgId != null) {
            MessageCenterServiceHelper.setMsgReadState((Long)Long.valueOf(msgId), Collections.singletonList(userId));
            this.closeForm(msgId, userId);
        }
    }

    private void setMsgPopup() {
        String msgId = this.getPageCache().get(MSG_ID);
        Long userId = RequestContext.get().getCurrUserId();
        if (msgId != null) {
            MessageCenterServiceHelper.setMessagePopup((Long)Long.valueOf(msgId), Collections.singletonList(userId), (boolean)false);
            this.closeForm(msgId, userId);
        }
    }

    private void closeForm(String msgId, Long userId) {
        FormShowParameter fsp2 = this.getView().getFormShowParameter();
        String sessionId = RequestContext.get().getGlobalSessionId();
        HashMap<String, String> config = new HashMap<String, String>(16);
        config.put("pageId", fsp2.getPageId());
        String msg = MsgSessionUtil.buildWebSocketAction((String)"closeWindow", config);
        PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
        PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        MsgCacheUtil.remove((String)msgId, (String)sessionId);
        MsgCacheUtil.remove((String)this.getMsgRecordKey(userId));
        MsgCacheUtil.remove((String)this.getSendRecordKey(userId));
    }

    private String getMsgRecordKey(Long userId) {
        return "SendRecord_CENTER_MSG_" + userId;
    }

    private String getSendRecordKey(Long userId) {
        return "SendRecord_CENTER_" + userId;
    }
}

