/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.ILocalStringUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MsgNoticeWebApiPlugin
implements IBillWebApiPlugin {
    public static final String BAS_MESSAGE_FORMPLUGIN = "bas-message-formplugin";
    private static Log logger = LogFactory.getLog(MsgNoticeWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("MsgNoticeWebApiPlugin--params:" + SerializationUtils.toJsonString(params));
        if (CollectionUtils.isEmpty(params)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"MsgNoticeWebApiPlugin_0", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
        }
        MessageInfo messageInfo = new MessageInfo();
        List<String> msgs = this.valid(params);
        if (!CollectionUtils.isEmpty(msgs)) {
            return ApiResult.fail((String)StringUtils.join((Object[])msgs.toArray(), (String)","), (String)"500");
        }
        Object showType = params.get("showType");
        Object validTime = params.get("validTime");
        Object title = params.get("title");
        Object content = params.get("content");
        messageInfo.setTitle(title.toString());
        messageInfo.setContent(content.toString());
        Object messageTitle = params.get("messageTitle");
        Object messageContent = params.get("messageContent");
        if (messageContent instanceof Map) {
            Map contentValue = (Map)messageContent;
            messageInfo.setMessageContent(ILocalStringUtil.mapValueToLocaleString((Map)contentValue));
        }
        if (messageTitle instanceof Map) {
            Map titleValue = (Map)messageTitle;
            messageInfo.setMessageTitle(ILocalStringUtil.mapValueToLocaleString((Map)titleValue));
        }
        HashMap messageParams = new HashMap();
        HashMap<String, Object> systemNotice = new HashMap<String, Object>();
        systemNotice.put("showType", showType);
        systemNotice.put("timeOut", Long.parseLong(validTime.toString()));
        messageParams.put("systemNotice", systemNotice);
        messageInfo.setParams(messageParams);
        messageInfo.setType("notice");
        messageInfo.setNotifyType("sysnotice");
        try {
            Object toAll = params.get("toAll");
            if (StringUtils.isNotBlank((Object)toAll) && Boolean.parseBoolean(toAll.toString())) {
                messageInfo.setToAll(true);
            } else {
                List<Long> sendUserIds = this.getSendUserIds(params);
                if (CollectionUtils.isEmpty(sendUserIds)) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u65e0\u53ef\u53d1\u9001\u7684\u4eba\u5458\u5bf9\u8c61", (String)"MsgNoticeWebApiPlugin_5", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]), (String)"500");
                }
                messageInfo.setUserIds(sendUserIds);
            }
            long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            return ApiResult.success((Object)msgId);
        }
        catch (Exception e) {
            logger.info("MsgNoticeWebApiPlugin--error", (Object)e);
            return ApiResult.fail((String)e.getMessage(), (String)"500");
        }
    }

    private List<Long> getSendUserIds(Map<String, Object> params) {
        ArrayList sendUserIds = new ArrayList();
        List userIds = (List)params.get("userIds");
        List userTypeIds = (List)params.get("userTypeIds");
        List orgIds = (List)params.get("orgIds");
        List phone = (List)params.get("phones");
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            try {
                List userIdList = userIds.stream().map(a -> Long.valueOf(a.toString())).collect(Collectors.toList());
                QFilter userIdFilter = new QFilter("id", "in", userIdList);
                boolean isExist = QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{userIdFilter});
                if (isExist) {
                    sendUserIds.addAll(userIdList);
                }
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("userIds type error", ResManager.loadKDString((String)"\u4eba\u5458ID\u96c6\u5408\u53c2\u6570\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_14", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)userTypeIds)) {
            List userIdsByUserTypes = MessageUtils.getUserIdsByUserTypes(userTypeIds.stream().map(Object::toString).collect(Collectors.toList()));
            sendUserIds.addAll(userIdsByUserTypes);
        }
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            List orgIdList;
            try {
                orgIdList = orgIds.stream().map(a -> Long.valueOf(a.toString())).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("orgIds type error", ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u96c6\u5408\u53c2\u6570\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_15", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
            }
            Set orgUserIds = UserServiceHelper.getAllUsersOfOrg((int)0, orgIdList, (boolean)false, (boolean)false);
            sendUserIds.addAll(orgUserIds);
        }
        if (!CollectionUtils.isEmpty((Collection)phone)) {
            List phoneStr = phone.stream().map(Object::toString).collect(Collectors.toList());
            List phoneUserIds = MessageUtils.getUserIdsByPhones(phoneStr);
            sendUserIds.addAll(phoneUserIds);
        }
        return sendUserIds.stream().distinct().collect(Collectors.toList());
    }

    private List<String> valid(Map<String, Object> params) {
        ArrayList<String> msgs = new ArrayList<String>(0);
        Object showType = params.get("showType");
        Object validTime = params.get("validTime");
        Object title = params.get("title");
        Object content = params.get("content");
        Object userIds = params.get("userIds");
        Object userTypeIds = params.get("userTypeIds");
        Object orgIds = params.get("orgIds");
        Object phones = params.get("phones");
        try {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            if (StringUtils.isBlank((Object)title)) {
                msgs.add(ResManager.loadKDString((String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgNoticeWebApiPlugin_7", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)content)) {
                msgs.add(ResManager.loadKDString((String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgNoticeWebApiPlugin_8", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)validTime)) {
                msgs.add(ResManager.loadKDString((String)"\u6709\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgNoticeWebApiPlugin_9", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)showType)) {
                msgs.add(ResManager.loadKDString((String)"\u5c55\u793a\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgNoticeWebApiPlugin_10", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (title.toString().getBytes("GBK").length > 32) {
                msgs.add(ResManager.loadKDString((String)"\u6807\u9898\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e32\u4e2a\u5b57\u8282\u3002", (String)"MsgNoticeWebApiPlugin_11", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (!pattern.matcher(validTime.toString()).matches()) {
                msgs.add(ResManager.loadKDString((String)"\u6709\u6548\u65f6\u95f4\u5fc5\u987b\u662f\u6b63\u6574\u6570\u3002", (String)"MsgNoticeWebApiPlugin_12", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (!("1".equals(showType.toString()) || "2".equals(showType.toString()) || "3".equals(showType.toString()))) {
                msgs.add(ResManager.loadKDString((String)"\u5c55\u793a\u5f62\u5f0f\u53c2\u6570\u9519\u8bef", (String)"MsgNoticeWebApiPlugin_13", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (userIds != null && !(userIds instanceof List)) {
                msgs.add(ResManager.loadKDString((String)"\u4eba\u5458ID\u96c6\u5408\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_1", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (userTypeIds != null && !(userTypeIds instanceof List)) {
                msgs.add(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578bID\u96c6\u5408\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_2", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (orgIds != null && !(orgIds instanceof List)) {
                msgs.add(ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u96c6\u5408\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_3", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (phones != null && !(phones instanceof List)) {
                msgs.add(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u96c6\u5408\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"MsgNoticeWebApiPlugin_4", (String)BAS_MESSAGE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.info("MsgNoticeWebApiPlugin--valid--error", (Object)e);
            msgs.add(e.getMessage());
        }
        return msgs;
    }
}

