/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dd.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dd.service.DDConfig;
import kd.bos.dlock.DLock;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.dingding.DDUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class DingDingServiceHelper {
    private static final String SUCCESS = "0";
    private static Log logger = LogFactory.getLog(DingDingServiceHelper.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("DINGDING_DATA", new DistributeCacheHAPolicy(true, true));

    public static Map<String, List<String>> getAuthScope(String token) {
        String ddHost = DingDingServiceHelper.getDDHost();
        StringBuilder url = new StringBuilder(ddHost).append("/auth/scopes?access_token=");
        url.append(token);
        try {
            String data = HttpClientUtils.get((String)url.toString());
            HashMap map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            Map authOrgScopes = (Map)map.get("auth_org_scopes");
            JSONArray authed_user = (JSONArray)authOrgScopes.get("authed_user");
            JSONArray authed_dept = (JSONArray)authOrgScopes.get("authed_dept");
            HashMap<String, List<String>> dataMap = new HashMap<String, List<String>>(2);
            if (authed_user != null) {
                List userList = authed_user.toJavaList(String.class);
                dataMap.put("authed_user", userList);
            }
            if (authed_dept != null) {
                List deptList = authed_dept.toJavaList(String.class);
                dataMap.put("authed_dept", deptList);
            }
            return dataMap;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static List<Map<String, String>> getAuthScopeUsers(List<String> authedUser, String accessToken) {
        ArrayList<Map<String, String>> userList = new ArrayList<Map<String, String>>(16);
        String ddHost = DingDingServiceHelper.getDDHost();
        StringBuilder url = new StringBuilder(ddHost).append("/topapi/v2/user/get?access_token=");
        url.append(accessToken);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("language", Lang.get().name());
        try {
            for (String userId : authedUser) {
                params.put("userid", userId);
                String data = HttpClientUtils.post((String)url.toString(), null, params);
                Map map = (Map)JSON.parseObject((String)data, Map.class);
                if (SUCCESS.equals(map.get("errcode").toString())) {
                    Map result = (Map)map.get("result");
                    String mobile = DingDingServiceHelper.getMobileAndState(result);
                    result.put("mobile", mobile);
                    userList.add(result);
                    continue;
                }
                logger.info(map.get("errmsg").toString());
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return userList;
    }

    public static String getMobileAndState(Map<String, String> result) {
        String state = DingDingServiceHelper.getStateCode(result);
        String mobile = result.get("mobile");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)state) || "86".equals(state)) {
            return mobile;
        }
        return state + "-" + mobile;
    }

    private static String getStateCode(Map<String, String> result) {
        if (StringUtils.isNotEmpty((CharSequence)result.get("state_code"))) {
            return result.get("state_code");
        }
        if (StringUtils.isNotEmpty((CharSequence)result.get("stateCode"))) {
            return result.get("stateCode");
        }
        if (StringUtils.isNotEmpty((CharSequence)result.get("statecode"))) {
            return result.get("statecode");
        }
        return null;
    }

    public static DDConfig getConfig() {
        DDConfig config = new DDConfig();
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap != null) {
            Object corpId;
            Object appSecret;
            Object appKey;
            Object isenableding = paramMap.get("isenableding");
            if (StringUtils.isNotBlank(isenableding)) {
                config.setEnable(Boolean.parseBoolean(isenableding.toString()));
            }
            if (StringUtils.isNotBlank(appKey = paramMap.get("appkey"))) {
                config.setAppKey(appKey.toString().trim());
            }
            if (StringUtils.isNotBlank(appSecret = paramMap.get("appsecret"))) {
                config.setAppSecret(appSecret.toString().trim());
            }
            if (StringUtils.isNotBlank(corpId = paramMap.get("ddcorpid"))) {
                config.setCorpId(corpId.toString().trim());
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccess_token() {
        DDConfig config = DingDingServiceHelper.getConfig();
        String appkey = config.getAppKey();
        String appsecret = config.getAppSecret();
        if (null == appkey || appkey.trim().isEmpty()) {
            return null;
        }
        if (null == appsecret || appsecret.trim().isEmpty()) {
            return null;
        }
        String key = appkey + appsecret;
        String access_token = (String)cache.get(key);
        if (null != access_token) {
            return access_token;
        }
        dl.lock();
        try (DLock dl = DLock.create((String)"DingDingServiceHelper#getAccess_token");){
            String string;
            access_token = (String)cache.get(key);
            if (null != access_token) {
                String string2 = access_token;
                return string2;
            }
            String ddHost = DingDingServiceHelper.getDDHost();
            StringBuilder access_token_url = new StringBuilder(ddHost).append("/gettoken?appkey=");
            access_token_url.append(appkey).append("&appsecret=").append(appsecret);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                string = null;
                return string;
            }
            if (SUCCESS.equals(map.get("errcode").toString())) {
                access_token = map.get("access_token").toString();
                cache.put(key, (Object)access_token, 3600);
                string = access_token;
                return string;
            }
            logger.info(map.get("errmsg").toString());
            string = null;
            return string;
        }
    }

    private static String getDDHost() {
        String ddHost = "https://oapi.dingtalk.com";
        try {
            String accountId = RequestContext.get().getAccountId();
            String tenantId = RequestContext.get().getTenantId();
            if (kd.bos.util.StringUtils.isEmpty((String)accountId) && kd.bos.util.StringUtils.isEmpty((String)tenantId)) {
                ddHost = DDUtils.getDDHost((String)"");
            } else {
                Account account = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
                ddHost = DDUtils.getDDHost((Account)account, (String)tenantId);
            }
        }
        catch (Exception e) {
            logger.info("getDDHost", (Object)e);
        }
        return ddHost;
    }

    public static List<String> getDeptList(String accesstoken, String deptId) {
        if (null == accesstoken || accesstoken.trim().isEmpty()) {
            return null;
        }
        StringBuilder getDeptList_url = new StringBuilder(DingDingServiceHelper.getDDHost()).append("/department/list?access_token=");
        getDeptList_url.append(accesstoken).append("&fetch_child=true");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)deptId)) {
            getDeptList_url.append("&id=").append(deptId);
        }
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getDeptList_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            logger.info("getUserId_url response: " + data);
        }
        catch (Exception e) {
            logger.info("getDeptList", (Object)e);
        }
        if (map == null) {
            return null;
        }
        if (SUCCESS.equals(map.get("errcode").toString())) {
            String department = map.get("department").toString();
            List deptList = (List)JSON.parseObject((String)department, List.class);
            ArrayList<String> deptIds = new ArrayList<String>(deptList.size());
            for (Map dept : deptList) {
                deptIds.add(dept.get("id").toString());
            }
            return deptIds;
        }
        logger.info(map.get("errmsg").toString());
        return null;
    }

    public static List<String> getDeptList(String accesstoken) {
        return DingDingServiceHelper.getDeptList(accesstoken, "");
    }

    public static List<Map<String, String>> getDeptUserList(String access_token, long department_id, long offset, long size, String order) {
        if (null == access_token || access_token.trim().isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder getDeptUserList_url = new StringBuilder(DingDingServiceHelper.getDDHost()).append("topapi/v2/user/list?access_token=");
        getDeptUserList_url.append(access_token);
        HashMap<String, Long> body = new HashMap<String, Long>(4);
        body.put("dept_id", department_id);
        body.put("cursor", offset);
        body.put("size", size);
        HashMap map = null;
        try {
            String data = HttpClientUtils.post((String)getDeptUserList_url.toString(), null, body);
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.info("getDeptUserList", (Object)e);
        }
        if (map == null) {
            return Collections.emptyList();
        }
        if (SUCCESS.equals(map.get("errcode").toString())) {
            ArrayList<Map<String, String>> userList = new ArrayList();
            JSONObject result = (JSONObject)map.get("result");
            if (ObjectUtils.isEmpty((Object)result)) {
                return Collections.emptyList();
            }
            JSONArray userListStr = (JSONArray)result.get((Object)"list");
            userList = DingDingServiceHelper.changeStateMobile(userListStr);
            return userList;
        }
        logger.info(map.get("errmsg").toString());
        return Collections.emptyList();
    }

    private static List<Map<String, String>> changeStateMobile(JSONArray userList) {
        ArrayList<Map<String, String>> userListMap = new ArrayList<Map<String, String>>(userList.size());
        for (Object o : userList) {
            if (ObjectUtils.isEmpty(o)) continue;
            JSONObject jsonObject = (JSONObject)o;
            Map hashMap = (Map)jsonObject.toJavaObject(Map.class);
            String mobileAndState = DingDingServiceHelper.getMobileAndState(hashMap);
            hashMap.put("mobile", mobileAndState);
            userListMap.add(hashMap);
        }
        return userListMap;
    }

    public static String getCorpId() {
        DDConfig config = DingDingServiceHelper.getConfig();
        return config.getCorpId();
    }

    public static boolean isEnable() {
        DDConfig config = DingDingServiceHelper.getConfig();
        return config.isEnable();
    }

    public static Map<Long, String> getDDUserIdByUserId(List<Long> ids) {
        DynamicObject[] mapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"openid,userid", (QFilter[])new QFilter[]{new QFilter("userid", "in", ids), new QFilter("imtype", "=", (Object)2)});
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (null != mapping && mapping.length > 0) {
            for (DynamicObject dynamicObject : mapping) {
                map.put(dynamicObject.getLong("userid"), dynamicObject.getString("openid"));
            }
        }
        return map;
    }
}

