/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.welink.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.welink.TicketResp;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.welink.service.WeLinkConfig;

public class WeLinkServiceHelper {
    private static final Log logger = LogFactory.getLog(WeLinkServiceHelper.class);
    private static final String LOGIN_WELINKHOST = "login_welinkhost";
    private static final String WELINKHOST = "welinkhost";
    private static ConcurrentHashMap<String, TicketResp> TicketRespMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenExpiresMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenTimeMap = new ConcurrentHashMap();

    public static WeLinkConfig getConfig() {
        WeLinkConfig config = new WeLinkConfig();
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap != null) {
            Object clientSecret;
            Object clientid;
            Object isenable = paramMap.get("isenablewelink");
            if (StringUtils.isNotBlank(isenable)) {
                config.setEnable(Boolean.parseBoolean(isenable.toString()));
            }
            if (StringUtils.isNotBlank(clientid = paramMap.get("clientid"))) {
                config.setClientId(clientid.toString().trim());
            }
            if (StringUtils.isNotBlank(clientSecret = paramMap.get("clientsecret"))) {
                config.setClientsecret(clientSecret.toString().trim());
            }
        }
        return config;
    }

    public static TicketResp getAccessToken() {
        WeLinkConfig config = WeLinkServiceHelper.getConfig();
        String clientId = config.getClientId();
        String clientSecret = config.getClientsecret();
        long currentTime = System.currentTimeMillis();
        TicketResp ticketResp = null;
        String key = clientId + clientSecret;
        ticketResp = TicketRespMap.get(key);
        Long accessTokenExpires = accessTokenExpiresMap.get(key);
        Long accessTokenTime = accessTokenTimeMap.get(key);
        if (Objects.isNull(accessTokenExpires)) {
            accessTokenExpires = 0L;
        }
        if (Objects.isNull(accessTokenTime)) {
            accessTokenTime = 0L;
        }
        if (Objects.nonNull(ticketResp) && currentTime - accessTokenTime < accessTokenExpires) {
            return TicketRespMap.get(key);
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json");
        HashMap<String, String> ticketBodyParams = new HashMap<String, String>();
        ticketBodyParams.put("client_id", clientId);
        ticketBodyParams.put("client_secret", clientSecret);
        String accessTokenUrl = WeLinkServiceHelper.getWeLinkHost() + "/api/auth/v2/tickets";
        StringBuilder sb = new StringBuilder(accessTokenUrl);
        try {
            String ticketResult = HttpClientUtils.postjson((String)sb.toString(), header, (String)JSON.toJSONString(ticketBodyParams));
            if (StringUtils.isEmpty((CharSequence)ticketResult)) {
                return null;
            }
            ticketResp = (TicketResp)JSON.parseObject((String)ticketResult, TicketResp.class);
        }
        catch (Exception e) {
            logger.info("weLinkUtil getAccessToken", (Object)e);
        }
        if (ticketResp != null) {
            TicketRespMap.put(key, ticketResp);
            if (Objects.nonNull(ticketResp.getAccess_token()) && Objects.nonNull(ticketResp.getExpires_in())) {
                accessTokenExpiresMap.put(key, ticketResp.getExpires_in().longValue());
                accessTokenTimeMap.put(key, System.currentTimeMillis());
            }
        }
        return ticketResp;
    }

    private static String getWeLinkHost() {
        String host = "https://open.welink.huaweicloud.com";
        try {
            Map parameters = ParametersUtils.getCommonParameters((Account)WeLinkServiceHelper.getAccount());
            String pathString = System.getProperty(LOGIN_WELINKHOST);
            if (null == parameters && kd.bos.util.StringUtils.isNotEmpty((String)pathString)) {
                host = pathString;
            }
            if (null != parameters && null != parameters.get(WELINKHOST) && !"".equals(parameters.get(WELINKHOST))) {
                host = String.valueOf(parameters.get(WELINKHOST));
            } else if (kd.bos.util.StringUtils.isNotEmpty((String)pathString)) {
                host = pathString;
            }
        }
        catch (Exception e) {
            logger.info("getWeLinkHost", (Object)e);
        }
        String weLinkhost = LoginUtils.getPathString((String)host);
        return weLinkhost;
    }

    private static Account getAccount() {
        Account account = null;
        try {
            String accountId = RequestContext.get().getAccountId();
            String tenantId = RequestContext.get().getTenantId();
            account = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        }
        catch (Exception e) {
            logger.info("getAccount", (Object)e);
        }
        return account;
    }

    public static Map<String, Object> getSubDeptMap(String access_token, String deptCode, Integer recursiveflag, Integer pageNo, Integer limit) {
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("x-wlk-Authorization", access_token);
        HashMap<String, Object> userBodyParams = new HashMap<String, Object>();
        userBodyParams.put("deptCode", deptCode);
        userBodyParams.put("recursiveflag", recursiveflag);
        userBodyParams.put("offset", pageNo);
        userBodyParams.put("limit", limit);
        StringBuilder sb = new StringBuilder(WeLinkServiceHelper.getWeLinkHost()).append("/api/contact/v2/departments/list");
        String subDeptListResult = "";
        HashMap subDeptMap = new HashMap();
        try {
            subDeptListResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, userBodyParams);
            subDeptMap = (HashMap)JSON.parseObject((String)subDeptListResult, HashMap.class);
        }
        catch (Exception e) {
            logger.info("weLinkUtil.getSubDeptList.http req", (Object)e);
            return subDeptMap;
        }
        return subDeptMap;
    }

    public static Map<String, Object> getDeptUserList(String access_token, String deptCode, Integer pageNo, Integer pageSize) {
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("Accept-Charset", "UTF-8");
        userHeaderParams.put("Content-Type", "application/json");
        userHeaderParams.put("x-wlk-Authorization", access_token);
        HashMap<String, Object> userBodyParams = new HashMap<String, Object>();
        userBodyParams.put("deptCode", deptCode);
        userBodyParams.put("pageNo", pageNo);
        userBodyParams.put("pageSize", pageSize);
        StringBuilder sb = new StringBuilder(WeLinkServiceHelper.getWeLinkHost()).append("/api/contact/v1/user/users");
        try {
            String deptUserResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, userBodyParams);
            return (Map)JSON.parseObject((String)deptUserResult, HashMap.class);
        }
        catch (Exception e) {
            logger.info("weLinkUtil getUserResp", (Object)e);
            return null;
        }
    }

    public static Map<String, String> getWeLinkInBosUserIds(ArrayList mobileNumber) {
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter[]{new QFilter("phone", "in", (Object)mobileNumber)});
        HashMap<String, String> phoneUserMap = new HashMap<String, String>(users.length);
        for (DynamicObject user : users) {
            String phone = user.get("phone").toString();
            phoneUserMap.put(user.getPkValue().toString(), phone);
        }
        return phoneUserMap;
    }

    public static boolean saveImMapping(Map<String, String> weLinkPhoneOpenIdMap, ArrayList<Object> ids, Map<String, String> bosUserIdPhoneMap) {
        if (Objects.isNull(weLinkPhoneOpenIdMap)) {
            return false;
        }
        if (Objects.isNull(bosUserIdPhoneMap)) {
            return false;
        }
        ArrayList<Long> userids = new ArrayList<Long>(16);
        for (Object id : ids) {
            if (id == null) continue;
            userids.add(Long.parseLong(id.toString()));
        }
        DynamicObject[] imMapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,openid", (QFilter[])new QFilter[]{new QFilter("userid", "in", userids), new QFilter("imtype", "=", (Object)4)});
        if (imMapping != null && imMapping.length > 0) {
            ArrayList<DynamicObject> updateMapping = new ArrayList<DynamicObject>(imMapping.length);
            String userid = "";
            String phone = "";
            String openId = "";
            for (DynamicObject dynamicObject : imMapping) {
                userid = dynamicObject.getString("userid");
                phone = bosUserIdPhoneMap.get(userid);
                if (StringUtils.isBlank((CharSequence)phone) || StringUtils.isBlank((CharSequence)(openId = weLinkPhoneOpenIdMap.get(phone)))) continue;
                dynamicObject.set("openid", (Object)openId);
                updateMapping.add(dynamicObject);
                bosUserIdPhoneMap.remove(userid);
            }
            if (updateMapping.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateMapping.toArray(new DynamicObject[1]));
            }
        }
        ArrayList<DynamicObject> insertMapping = new ArrayList<DynamicObject>(bosUserIdPhoneMap.size());
        String phone = "";
        String bosUserId = "";
        for (Map.Entry<String, String> entry : bosUserIdPhoneMap.entrySet()) {
            String openid;
            phone = entry.getValue();
            bosUserId = entry.getKey();
            if (StringUtils.isBlank((CharSequence)phone) || StringUtils.isBlank((CharSequence)bosUserId) || (openid = weLinkPhoneOpenIdMap.get(phone)) == null) continue;
            MainEntityType imMappingType = EntityMetadataCache.getDataEntityType((String)"bas_immapping");
            DynamicObject mapping = new DynamicObject((DynamicObjectType)imMappingType);
            mapping.set("userid", (Object)Long.parseLong(bosUserId));
            mapping.set("user", (Object)Long.parseLong(bosUserId));
            mapping.set("imtype", (Object)4);
            mapping.set("openid", (Object)openid);
            insertMapping.add(mapping);
            if (insertMapping.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])insertMapping.toArray(new DynamicObject[1]));
        }
        return true;
    }

    public static String getMobile(String mobileNumber) {
        String mobil = "";
        if (kd.bos.util.StringUtils.isEmpty((String)mobileNumber)) {
            return mobil;
        }
        if (mobileNumber.startsWith("+86-")) {
            return mobileNumber.substring(4);
        }
        return mobileNumber;
    }
}

