/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.wxqyh.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.dto.AppTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.wxqyh.service.WxqyhConfig;
import org.apache.commons.lang3.StringUtils;

public class WxqyhServiceHelper {
    private static Log logger = LogFactory.getLog(WxqyhServiceHelper.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("WXQYH_DATA", new DistributeCacheHAPolicy(true, true));

    public static WxqyhConfig getConfig() {
        WxqyhConfig config = new WxqyhConfig();
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap != null) {
            Object corpId;
            Object corpSecret;
            Object isenable = paramMap.get("isenablewxqyh");
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(isenable))) {
                config.setEnable(Boolean.parseBoolean(isenable.toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(corpSecret = paramMap.get("corpsecret")))) {
                config.setCorpsecret(corpSecret.toString().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(corpId = paramMap.get("corpid")))) {
                config.setCorpId(corpId.toString().trim());
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccess_token(String corpid, String corpSecret) {
        if (null == corpid || corpid.trim().isEmpty()) {
            return null;
        }
        if (null == corpSecret || corpSecret.trim().isEmpty()) {
            return null;
        }
        String key = corpid + corpSecret;
        String access_token = (String)cache.get(key);
        if (null != access_token) {
            return access_token;
        }
        dl.lock();
        try (DLock dl = DLock.create((String)"WxqyhServiceHelper#getAccess_token");){
            String string;
            access_token = (String)cache.get(key);
            if (null != access_token) {
                String string2 = access_token;
                return string2;
            }
            StringBuffer access_token_url = new StringBuffer(WxqyhServiceHelper.getQywxhHost()).append("cgi-bin/gettoken?corpid=");
            access_token_url.append(corpid).append("&corpsecret=").append(corpSecret);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.info("parseObject error", (Object)e);
            }
            if (map == null) {
                string = null;
                return string;
            }
            if ("0".equals(map.get("errcode").toString())) {
                access_token = map.get("access_token").toString();
                cache.put(key, (Object)access_token, 3600);
                string = access_token;
                return string;
            }
            logger.info(map.get("errmsg").toString());
            string = null;
            return string;
        }
    }

    public static List<Map<String, String>> getDeptUserList(String access_token, long department_id, String fetch_child) {
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        StringBuilder getDeptUserList_url = new StringBuilder(WxqyhServiceHelper.getQywxhHost()).append("cgi-bin/user/list?access_token=");
        getDeptUserList_url.append(access_token).append("&department_id=").append(department_id).append("&fetch_child=").append(fetch_child);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getDeptUserList_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.info("parseObject error", (Object)e);
        }
        if (map == null) {
            return null;
        }
        if ("0".equals(map.get("errcode").toString())) {
            ArrayList<Map<String, String>> userList = new ArrayList();
            String userListStr = map.get("userlist").toString();
            userList = (List)JSON.parseObject((String)userListStr, List.class);
            return userList;
        }
        logger.info(map.get("errmsg").toString());
        return null;
    }

    public static String getCorpId() {
        WxqyhConfig config = WxqyhServiceHelper.getConfig();
        return config.getCorpId();
    }

    public static boolean isEnable() {
        WxqyhConfig config = WxqyhServiceHelper.getConfig();
        return config.isEnable();
    }

    public static Map<Long, String> getOpenIdByUserId(List<Long> ids) {
        DynamicObject[] mapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"openid,userid,encryopenid", (QFilter[])new QFilter[]{new QFilter("userid", "in", ids), new QFilter("imtype", "=", (Object)3)});
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (null != mapping && mapping.length > 0) {
            for (DynamicObject dynamicObject : mapping) {
                if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("openid"))) {
                    map.put(dynamicObject.getLong("userid"), dynamicObject.getString("openid"));
                    continue;
                }
                map.put(dynamicObject.getLong("userid"), dynamicObject.getString("encryopenid"));
            }
        }
        return map;
    }

    public static Map<String, Object> getCompanyInfoByName(String type, String agentname) {
        QFilter filter = new QFilter("agentname", "=", (Object)agentname);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)AppTypeEnum.getEntityName(type), (String)"id,corpid,corpname,resultcode,agentid,agentname,corpsecret", (QFilter[])new QFilter[]{filter});
        if (object == null) {
            return null;
        }
        String corpid = object.getString("corpid");
        String agentid = object.getString("agentid");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corpid", corpid);
        map.put("agentid", agentid);
        return map;
    }

    public static String getQywxhHost() {
        String host = "https://qyapi.weixin.qq.com/";
        String hostString = WxqyhServiceHelper.getProptyByTenant("qywxh_host", RequestContext.get().getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)hostString)) {
            host = hostString;
        }
        return host;
    }

    private static String getProptyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((CharSequence)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    public static List<String> getDeptList(String accessToken) {
        ArrayList<String> deptList = new ArrayList<String>(8);
        if (null == accessToken || accessToken.trim().isEmpty()) {
            return null;
        }
        StringBuilder url = new StringBuilder(WxqyhServiceHelper.getQywxhHost()).append("cgi-bin/department/list?access_token=");
        url.append(accessToken);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            if (ObjectUtils.isEmpty((Object)map)) {
                return deptList;
            }
            if ("0".equals(map.get("errcode").toString())) {
                String deptListStr = map.get("department").toString();
                List list = (List)JSON.parseObject((String)deptListStr, List.class);
                for (Map dept : list) {
                    deptList.add(dept.get("id").toString());
                }
            } else {
                logger.info(map.get("errmsg").toString());
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return deptList;
    }
}

