/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.auth.plugin.SecondConfirmPluginService;
import kd.bos.auth.pojo.OperateConfirmScheme;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.plugin.AbstractListPlugin;

public class OpConfirmListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_SCHEME = "searchap";
    private static final String KEY_SEARCH_TREE_NODE = "treenodesearch";
    private static final String CURR_NODE = "currnode";
    private SecondConfirmPluginService confirmPluginService;

    public void initialize() {
        this.confirmPluginService = new SecondConfirmPluginService(this.getView(), this.getModel(), this.getPageCache());
        TreeView tView = (TreeView)this.getControl(KEY_TREE_VIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_SCHEME);
        search.addEnterListener((SearchEnterListener)this);
        Search searchTreeNode = (Search)this.getControl(KEY_SEARCH_TREE_NODE);
        searchTreeNode.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.confirmPluginService.confirmListRefreshPage("");
    }

    public void afterBindData(EventObject e) {
        TreeNode rootNode = this.confirmPluginService.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(KEY_TREE_VIEW);
        tView.addNode(rootNode);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            String opKey = e.getOperateKey();
            this.confirmPluginService.confirmListDo(opKey, this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        this.confirmPluginService.confirmListClosed(closedCallBackEvent, actionId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.confirmPluginService.doDelete();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (!newNodeId.equals(currNodeId = this.getPageCache().get(CURR_NODE))) {
            List<OperateConfirmScheme> allSchemes = this.confirmPluginService.getSchemeCache();
            this.confirmPluginService.searchByNodeId(allSchemes, newNodeId);
            this.getPageCache().put(CURR_NODE, newNodeId);
        }
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        return this.confirmPluginService.getSearchList(e, search.getKey());
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        this.confirmPluginService.confirmListSearch(e, search);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (this.confirmPluginService.checkPerm().booleanValue()) {
            this.confirmPluginService.doModify(this);
        }
    }
}

