/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.auth.plugin.SecondConfirmPluginService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.tree.BizAppTreeBuilder;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class OpSchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORM_OBJECT = "bizobj";
    private static final String VERIFY_OPERATE = "verifyoperate";
    private static final String FORM_NUMBER = "formNumber";
    private static final String BTN_OK = "btnok";
    public static final String CONTINUE_SAVE = "continue_save";
    public static final String CONTINUE_CLOSE = "continue_close";
    private String number = null;
    private SecondConfirmPluginService confirmPluginService;

    public void initialize() {
        this.confirmPluginService = new SecondConfirmPluginService(this.getView(), this.getModel(), this.getPageCache());
        this.addClickListeners(new String[]{BTN_OK, "btncancel"});
        BasedataEdit formObject = (BasedataEdit)this.getView().getControl(FORM_OBJECT);
        this.setBizObjFilter(formObject);
        formObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{VERIFY_OPERATE});
    }

    private void setBizObjFilter(BasedataEdit formObject) {
        String treeNodeId = (String)this.getView().getFormShowParameter().getCustomParam("treeNodeId");
        if (!StringUtils.isEmpty((CharSequence)treeNodeId) && !"0".equals(treeNodeId)) {
            List<String> appIds = this.isObject(treeNodeId);
            formObject.setQFilter(new QFilter("bizappid", "in", appIds));
        }
    }

    private List<String> isObject(String treeNodeId) {
        BizAppTreeBuilder bizAppTreeBuilder;
        TreeNode rootNode;
        TreeNode treeNode;
        String nodes;
        ArrayList<String> appIds = new ArrayList<String>(8);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotEmpty((CharSequence)(nodes = parentView.getPageCache().getBigObject("nodes"))) && (treeNode = (rootNode = (bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)nodes, BizAppTreeBuilder.class)).getRootNode()).getTreeNode(treeNodeId)).getChildren() != null) {
            for (TreeNode child : treeNode.getChildren()) {
                appIds.add(child.getId());
            }
        }
        if (appIds.size() < 1) {
            appIds.add(treeNodeId);
        }
        return appIds;
    }

    public void afterCreateNewData(EventObject e) {
        this.confirmPluginService.opSchemeInitValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String treeNodeId = (String)this.getView().getFormShowParameter().getCustomParam("treeNodeId");
        if (!StringUtils.isEmpty((CharSequence)treeNodeId)) {
            arg0.getFormShowParameter().setCustomParam("treeRootNodeId", (Object)treeNodeId);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (FORM_OBJECT.equals(e.getProperty().getName())) {
            this.getModel().setValue(VERIFY_OPERATE, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.confirmPluginService.showClosedForm(e, this);
    }

    public void click(EventObject evt) {
        this.confirmPluginService.opSchemeClick(evt, this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if (CONTINUE_SAVE.equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.confirmPluginService.returnDataAndClose();
        } else if (CONTINUE_CLOSE.equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("close", "1");
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            this.confirmPluginService.opSchemeClosed(closedCallBackEvent);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty obj = e.getProperty();
        String propName = obj.getName();
        if (obj instanceof BasedataProp && FORM_OBJECT.equalsIgnoreCase(propName)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newVal = (DynamicObject)changeSet[0].getNewValue();
            String newValue = newVal == null ? "" : newVal.getString("number");
            this.getModel().setValue(FORM_OBJECT, (Object)newValue);
            this.getPageCache().put(FORM_NUMBER, newValue);
        }
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}

