/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;

public class OperationSelectPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        String operates = (String)this.getView().getFormShowParameter().getCustomParam("operates");
        List<String> selectedOperats = this.operateString2List(operates);
        ArrayList<Integer> selectRows = new ArrayList<Integer>(8);
        List ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        if (!ObjectUtils.isEmpty((Object)ops)) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("entryentity", ops.size());
            int i = 0;
            for (Map op : ops) {
                String name = op.get("name") == null ? "" : (String)((Map)op.get("name")).get(Lang.get().toString());
                model.setValue("ftype", op.get("type"), i);
                model.setValue("fcode", op.get("key"), i);
                model.setValue("fname", (Object)name, i);
                if (selectedOperats.contains(op.get("key"))) {
                    selectRows.add(i);
                }
                ++i;
            }
            this.getPageCache().put("value", SerializationUtils.toJsonString((Object)ops));
            this.getPageCache().put("selectRows", SerializationUtils.toJsonString(selectRows));
        }
    }

    public void afterBindData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = this.getSelectRows();
        if (selectRows != null) {
            grid.selectRows(selectRows, 0);
        }
    }

    private int[] getSelectRows() {
        String selectRows = this.getPageCache().get("selectRows");
        if (StringUtils.isNotEmpty((CharSequence)selectRows)) {
            List objects = SerializationUtils.fromJsonStringToList((String)selectRows, Integer.class);
            int[] rows = new int[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                rows[i] = (Integer)objects.get(i);
            }
            return rows;
        }
        return null;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnData();
        }
    }

    private List<Map<String, Object>> getSelectedOperation() {
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>(10);
        HashMap<String, String> op = null;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rowIndexs = entryGrid.getEntryState().getSelectedRows();
        if (rowIndexs.length > 0) {
            for (int rowIndex : rowIndexs) {
                op = new HashMap<String, String>();
                op.put("_Type_", "verifyoperate");
                op.put("OpCode", this.getModel().getValue("FCode", rowIndex).toString());
                op.put("OpName", this.getModel().getValue("FName", rowIndex).toString());
                op.put("OpType", this.getModel().getValue("Ftype", rowIndex).toString());
                ops.add(op);
            }
        }
        return ops;
    }

    private void returnData() {
        List<Map<String, Object>> data = this.getSelectedOperation();
        HashMap<String, List<Map<String, Object>>> returnData = new HashMap<String, List<Map<String, Object>>>(2);
        returnData.put("verifyoperate", data);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private List<String> operateString2List(String operats) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)operats)) {
            Collections.addAll(list, operats.split(","));
        }
        return list;
    }
}

