/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.auth.pojo.OperateConfirmScheme;
import kd.bos.base.param.utils.CaptchaGeneratorUtils;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.designer.tree.BizAppTreeBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CountDown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.auth.OpSecondConfirmService;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.SmsService;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.login.utils.log.OperateConfirmLog;
import kd.bos.login.utils.sms.LoginMessageUtils;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.IMessageService;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.portal.util.LeftTreeSearchUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.PasswordEncryptUtil;
import org.apache.commons.lang3.StringUtils;

public class SecondConfirmPluginService {
    private static final String BTN_OK = "btnok";
    private static final String BTN_GET_CODE = "btn_getcode";
    public static final String BTN_ADD_LINE = "addline";
    public static final String BTN_DELETE_LINE = "btndeleteline";
    private static final String KEY_ADD_ORG = "addorg";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_NEW = "new";
    private static final String PHONE = "phone";
    private static final String EMAIL = "email";
    private static final String PHONE_NEWCOUNTDOWN_AP = "phone_newcountdownap";
    private static final String IMG_COUNTDOWN_AP = "img_countdownap";
    private static final String PHONE_NEWLABEL_AP = "phone_newlabelap";
    private static final String EMAIL_NEWCOUNTDOWN_AP = "email_newcountdownap";
    private static final String EMAIL_NEWLABEL_AP = "email_newlabelap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_TREE_VIEW = "treeviewap";
    protected static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String KEY_SEARCH_SCHEME = "searchap";
    private static final String KEY_SEARCH_TREE_NODE = "treenodesearch";
    private static final String FORM_OBJECT = "bizobj";
    private static final String VERIFY_OPERATE = "verifyoperate";
    private static final String FORM_NUMBER = "formNumber";
    private static final String VALUE = "value";
    private static final String VERIFY_MODE = "verifymode";
    private static final String META_CONTEXT = "MetaContext";
    private static final String AUTH_ONCE = "authonce";
    private static final String STATUS = "status";
    protected static final String KEY_FORMNUMBER = "formnumber";
    protected static final String KEY_FID = "fid";
    private static final String KEY_FORM_NAME = "formname";
    private static final String CURR_NODE = "currnode";
    private static final String OPERATE_SCHEME = "operate_scheme";
    private static final String FORM_ID_ORG = "bos_confirmscheme_org";
    private static final String CONFIRM_BINDUSERINFO = "bos_confirm_binduserinfo";
    private static final String OPERATION_SCHEMES = "OperationSchemes";
    private static final String GETCODETIMES = "getcodetimes";
    public static final String CODENUMBER = "codenumber";
    public static final String PERM_MODIFY = "4715a0df000000ac";
    public static final String NEW = "new";
    private List<OperateConfirmScheme> allScheme;
    private static final String CACHE_ID_TREE_NODES = "nodes";
    private static final int IMG_CODE_TIMEOUT = 60;
    private static final String USER_BIND_CONFIRM_TEXT = "userBindConfirmText";
    private static final String USER_BIND_PATH_TEXT = "userBindPathText";
    private static final String ENTITY_ORG = "orgentity";
    private static final String ORG_ID = "orgid";
    private static final String ORG_F7 = "orgf7";
    private static final String BIZOBJECTID = "bizobjectid";
    private static final String DEFAULT_ORGFUNCID = "15";
    private static final String BTN_SAVE = "savedata";
    private static final String SIGN_SCHEMEID = "signSchemeId";
    private static final String SIGNENTITY_ORG = "bos_confirm_orgentity";
    private static final String SCHEME_ID = "schemeid";
    private static final String IS_INCLUDE_SUB_ORG = "isincludesuborg";
    private static final String TABLE_ORG = "t_bd_signconfirmorg";
    private static final Log LOG = LogFactory.getLog(SecondConfirmPluginService.class);
    private LoginCacheService cacheService = new LoginCacheService("VERIFYINFO");
    private OpSecondConfirmService confirmService = new OpSecondConfirmService();
    private IFormView formView;
    private IDataModel dataModel;
    private IPageCache pageCache;

    public SecondConfirmPluginService(IFormView formView, IDataModel dataModel, IPageCache pageCache) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
    }

    public void loadPhone() {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        String phone = user.getString(PHONE);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)PHONE)) {
            this.dataModel.setValue(PHONE, (Object)phone);
            this.pageCache.put("phoneCache", phone);
        }
    }

    public void loadEmail() {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        String phone = user.getString(EMAIL);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)EMAIL)) {
            this.dataModel.setValue(EMAIL, (Object)phone);
            this.pageCache.put("emailCache", phone);
        }
    }

    public void verifyCodeClick(EventObject evt, AbstractFormPlugin formPlugin) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_getcode": {
                this.getPhoneCode();
                break;
            }
            case "btnok": {
                this.checkPhoneCode(formPlugin);
                break;
            }
            case "imageap": {
                this.generatorCaptcha("imageap");
                break;
            }
        }
    }

    private void checkPhoneCode(AbstractFormPlugin formPlugin) {
        OperateConfirmLog operateConfirmLog = this.initLogInfo(formPlugin.getView().getFormShowParameter().getCustomParams());
        operateConfirmLog.setVerifyMode(1);
        try {
            String phoneNum = (String)this.dataModel.getValue(PHONE);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)phoneNum)) {
                this.pageCache.put(PHONE, phoneNum);
            }
            phoneNum = this.pageCache.get(PHONE);
            String verifyCode = (String)this.dataModel.getValue("verifycode");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)phoneNum) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)verifyCode)) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u77ed\u4fe1\u9a8c\u8bc1\u7801\u3002", (String)"VerifyCodePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                if (this.verifyCode(phoneNum, verifyCode, PHONE)) {
                    this.doContinueOperate(formPlugin, operateConfirmLog);
                } else {
                    operateConfirmLog.setOpResult("2");
                }
                LoginLogUtils.addAuthOpLog((String)RequestContext.get().getGlobalSessionId(), (OperateConfirmLog)operateConfirmLog);
            }
        }
        catch (Exception e) {
            LOG.info("checkPhoneCode", (Object)e);
        }
    }

    private boolean verifyCode(String phone, String code, String type) {
        int totalTimes = 0;
        String times = this.cacheService.get(this.getVerifyTimeKey(phone));
        if (times != null && (totalTimes = Integer.parseInt(times)) >= 3) {
            this.formView.showTipNotification(this.getErrorTimesMsg(), Integer.valueOf(2000));
            return false;
        }
        String codeCache = this.cacheService.get(phone + "portal_code_numbercode");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)codeCache)) {
            this.formView.showTipNotification(this.getSendCodeMsg(), Integer.valueOf(2000));
            return false;
        }
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)code)) {
            String typeStr = PHONE.equals(type) ? ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u77ed\u4fe1\u9a8c\u8bc1\u7801\u3002", (String)"VerifyCodePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u7bb1\u9a8c\u8bc1\u7801\u3002", (String)"VerifyCodePlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.formView.showTipNotification(typeStr, Integer.valueOf(2000));
            return false;
        }
        if (code.equals(codeCache)) {
            this.cacheService.remove(this.getVerifyTimeKey(phone));
            this.cacheService.remove(phone + CODENUMBER);
            return true;
        }
        this.cacheService.put(this.getVerifyTimeKey(phone), ++totalTimes + "");
        this.formView.showTipNotification(this.getErrorCodeMsg(type), Integer.valueOf(2000));
        return false;
    }

    private void doContinueOperate(AbstractFormPlugin formPlugin, OperateConfirmLog operateConfirmLog) {
        boolean fromPlugin = this.checkFromPlugin();
        if (fromPlugin) {
            this.formView.setReturnData((Object)true);
        } else {
            SecondConfirmPluginService.switch2OriginOp(formPlugin, operateConfirmLog);
        }
    }

    private boolean checkFromPlugin() {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        Object fromPlugin = customParams.get("fromPlugin");
        if (null != fromPlugin && fromPlugin instanceof Boolean) {
            return (Boolean)fromPlugin;
        }
        return false;
    }

    private void getPhoneCode() {
        Object phone = this.dataModel.getValue(PHONE);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)phone)) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7\u3002", (String)"PersonInformationPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            PhoneValidator phoneValidator = new PhoneValidator(phone.toString(), false);
            String errorMsg = phoneValidator.getErrorMsg();
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.formView.showErrorNotification(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PersonInformationPlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            RequestContext requestContext = RequestContext.get();
            Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
            int msgTimeout = LoginMessageUtils.getMsgTimeout((Account)account);
            boolean imgCodeFlag = this.checkImgCode();
            if (imgCodeFlag && this.sendMessage(phone.toString(), msgTimeout)) {
                this.formView.showSuccessNotification(this.getSendSuccessMsg(), Integer.valueOf(2000));
                this.startProgressAndCountDown("progressbarap", BTN_GET_CODE, PHONE_NEWCOUNTDOWN_AP, PHONE_NEWLABEL_AP, msgTimeout);
            }
        }
    }

    private boolean checkImgCode() {
        Object imageCode = this.dataModel.getValue("imagecode");
        if (null == imageCode || "".equals(imageCode)) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u56fe\u5f62\u9a8c\u8bc1\u7801\u3002", (String)"VerifyCodePlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        long captchaTime = Long.parseLong(this.pageCache.get("captcha_time"));
        long imageTime = System.currentTimeMillis() - captchaTime;
        if (60000L < imageTime) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"VerifyCodePlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!this.pageCache.get("captcha").equalsIgnoreCase((String)imageCode)) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"VerifyCodePlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean sendMessage(String phone, int msgTimeout) {
        RequestContext requestContext = RequestContext.get();
        Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
        if (!SmsService.isSmsEnable((Account)account)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u77ed\u4fe1\u901a\u77e5\u3002", (String)"PersonInformationPlugin_69", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        String phoneCodeCache = this.cacheService.get(phone + "portal_code_number");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)phoneCodeCache)) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u77ed\u4fe1\u5df2\u53d1\u9001\uff0c\u6709\u6548\u671f%s\u79d2\u3002", (String)"VerifyCodePlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), msgTimeout), Integer.valueOf(2000));
            return false;
        }
        IMessageService service = (IMessageService)ServiceFactory.getService((String)"IMessageService");
        ShortMessageInfo msgInfo = new ShortMessageInfo();
        msgInfo.setCountryCode("86");
        SecureRandom random = new SecureRandom();
        int pCode = random.nextInt(1000000);
        String pCodeStr = "00000" + pCode;
        pCodeStr = pCodeStr.substring(pCodeStr.length() - 6);
        pCodeStr = this.modifyPhoneCode(pCodeStr);
        String message = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%s\uff0c\u6765\u81ea\u77ed\u4fe1\u4e8c\u6b21\u8eab\u4efd\u8ba4\u8bc1\uff0c\u4e94\u5206\u949f\u6709\u5185\u6548\u3002", (String)"SecondConfirmPluginService_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), pCodeStr);
        msgInfo.setMessage(message);
        this.cacheService.put(phone + "portal_code_number", pCodeStr);
        this.cacheService.expireAfter(phone + "portal_code_number", msgTimeout);
        this.cacheService.put(phone + "portal_code_numbercode", pCodeStr, 300);
        this.cacheService.remove(this.getVerifyTimeKey(phone));
        ArrayList<String> phones = new ArrayList<String>();
        phones.add(phone);
        msgInfo.setPhone(phones);
        msgInfo.setSignature(ResManager.loadKDString((String)"\u91d1\u8776\u4e91", (String)"PersonInformationPlugin_51", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        service.sendShortMessage(msgInfo, Boolean.FALSE);
        return true;
    }

    private int getSecondsNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        Long seconds = (cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
        return seconds.intValue();
    }

    private String modifyPhoneCode(String msg) {
        char[] chars = msg.toCharArray();
        for (int i = 0; i < msg.length() - 1; ++i) {
            if (chars[i] != chars[i + 1]) continue;
            int n = i + 1;
            chars[n] = (char)(chars[n] + '\u0001');
            if (chars[i + 1] != ':') continue;
            chars[i + 1] = 48;
        }
        return new String(chars);
    }

    private void startProgressAndCountDown(String progressbarap, String btnKey, String countdownap, String lableap, int msgTimeout) {
        this.startProgress(progressbarap, btnKey);
        this.startCountDown(btnKey, countdownap, lableap, msgTimeout);
    }

    private void startProgress(String progressbarap, String btnKey) {
        ProgressBar progressBar = (ProgressBar)this.formView.getControl(progressbarap);
        progressBar.start();
    }

    private void startCountDown(String btnKey, String countdownap, String lableap, int msgTimeout) {
        this.countDown(countdownap, msgTimeout);
        this.formView.setVisible(Boolean.FALSE, new String[]{btnKey});
        this.formView.setVisible(Boolean.TRUE, new String[]{countdownap});
        this.formView.setVisible(Boolean.TRUE, new String[]{lableap});
    }

    private void countDown(String countdownap, int msgTimeout) {
        CountDown countDown = (CountDown)this.formView.getControl(countdownap);
        countDown.setDuration(msgTimeout - 1);
    }

    private String getVerifyTimeKey(String key) {
        return key + "verifyTimes";
    }

    private String getSendSuccessMsg() {
        return ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f\u3002", (String)"PersonInformationPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getSendCodeMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801\u3002", (String)"PersonInformationPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getErrorCodeMsg(String type) {
        String msg = PHONE.equals(type) ? ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"VerifyCodePlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"VerifyCodePlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        return msg;
    }

    private String getErrorTimesMsg() {
        return ResManager.loadKDString((String)"\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u3002", (String)"PersonInformationPlugin_28", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public void orgDoOperation(String operateKey) {
        switch (operateKey) {
            case "addline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgF7();
                break;
            }
            case "savedata": {
                String signSchemeId = (String)this.formView.getFormShowParameter().getCustomParam(SIGN_SCHEMEID);
                this.deleteEntry(signSchemeId);
                this.saveData(signSchemeId);
                break;
            }
        }
    }

    private void deleteEntry(String signSchemeId) {
        try (TXHandle h = TX.required();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":fschemeid", -5, (Object)Long.parseLong(signSchemeId))};
                String SQL = String.format("delete from %s where fschemeid = ?;", TABLE_ORG);
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void saveData(String signSchemeId) {
        DynamicObjectCollection list = this.dataModel.getEntryEntity(ENTITY_ORG);
        DynamicObject[] orgArr = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)SIGNENTITY_ORG);
            DynamicObject schemeOrg = new DynamicObject((DynamicObjectType)dt);
            schemeOrg.set(SCHEME_ID, (Object)signSchemeId);
            schemeOrg.set(ORG_ID, this.dataModel.getValue(ORG_ID, i));
            schemeOrg.set(IS_INCLUDE_SUB_ORG, this.dataModel.getValue(IS_INCLUDE_SUB_ORG, i));
            orgArr[i] = schemeOrg;
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PersonInformationPlugin_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.formView.close();
    }

    private void refreshOrgF7() {
        DynamicObjectCollection curOrgList = this.dataModel.getEntryEntity(ENTITY_ORG);
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject obj : curOrgList) {
            ids.add(Long.parseLong(String.valueOf(obj.getDynamicObject(ORG_ID).getPkValue())));
        }
        this.dataModel.setValue(ORG_F7, (Object)ids.toArray());
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.formView.getControl(ORG_F7);
        base.setOrgFuncId(this.getOrgFuncId(this.dataModel.getValue(BIZOBJECTID)));
        base.click();
    }

    private String getOrgFuncId(Object bizObject) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)bizObject)) {
            return DEFAULT_ORGFUNCID;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return DEFAULT_ORGFUNCID;
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)mainOrg)) {
            return DEFAULT_ORGFUNCID;
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return DEFAULT_ORGFUNCID;
        }
        String orgfuncid = org.getOrgFunc();
        return kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orgfuncid) ? DEFAULT_ORGFUNCID : orgfuncid;
    }

    public void orgLoadData() {
        String signSchemeId = (String)this.formView.getFormShowParameter().getCustomParam(SIGN_SCHEMEID);
        signSchemeId = signSchemeId == null ? "" : signSchemeId;
        Long signSchemePkId = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)signSchemeId) ? 0L : Long.parseLong(signSchemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)SIGNENTITY_ORG, (String)"orgid,isincludesuborg", (QFilter[])new QFilter[]{new QFilter(SCHEME_ID, "=", (Object)signSchemePkId)});
        HashSet<Long> orgSet = new HashSet<Long>();
        int size = query.size();
        if (size > 0) {
            int i = 0;
            this.dataModel.batchCreateNewEntryRow(ENTITY_ORG, size);
            for (DynamicObject dynamicObject : query) {
                this.dataModel.setValue(ORG_ID, dynamicObject.get(ORG_ID), i);
                this.dataModel.setValue(IS_INCLUDE_SUB_ORG, dynamicObject.get(IS_INCLUDE_SUB_ORG), i);
                orgSet.add(dynamicObject.getLong(ORG_ID));
                ++i;
            }
        }
        this.dataModel.setValue(ORG_F7, (Object)orgSet.toArray());
    }

    public OperateConfirmLog initLogInfo(Map<String, Object> showParameter) {
        OperateConfirmLog confirmLog = new OperateConfirmLog();
        confirmLog.setFormNumber((String)showParameter.get("entityId"));
        confirmLog.setVerifyOperate((String)showParameter.get("operationkey"));
        confirmLog.setOpUser(RequestContext.get().getUserId());
        confirmLog.setOpDate(new Date());
        confirmLog.setLogType(3);
        return confirmLog;
    }

    public void userPdConfirmClick(EventObject evt, AbstractFormPlugin userPdConfirmPlugin) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.checkUserAuth(userPdConfirmPlugin);
                break;
            }
            default: {
                this.formView.close();
            }
        }
    }

    private void checkUserAuth(AbstractFormPlugin userPdConfirmPlugin) {
        OperateConfirmLog operateConfirmLog = this.initLogInfo(this.formView.getFormShowParameter().getCustomParams());
        operateConfirmLog.setVerifyMode(0);
        try {
            String userpdStr = (String)this.dataModel.getValue("userpd");
            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)userpdStr)) {
                this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5bc6\u7801\u3002", (String)"UserPdConfirmPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), new Object[0]));
                return;
            }
            if (!this.authPasswordById(RequestContext.get().getCurrUserId(), userpdStr)) {
                this.formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bc6\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"UserPdConfirmPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), new Object[0]));
                operateConfirmLog.setOpResult("3");
            } else {
                SecondConfirmPluginService.switch2OriginOp(userPdConfirmPlugin, operateConfirmLog);
            }
        }
        catch (Exception e) {
            LOG.info("checkUserAuth", (Object)e);
            operateConfirmLog.setOpResult("0");
        }
        LoginLogUtils.addAuthOpLog((String)RequestContext.get().getGlobalSessionId(), (OperateConfirmLog)operateConfirmLog);
    }

    private boolean authPasswordById(long currUserId, String userpdStr) {
        DynamicObject[] userList = LoginUserService.getUserList((String)String.valueOf(currUserId), (UserProperType)UserProperType.UserId, (String)"id,truename,password", (Boolean)false);
        if (userList != null && userList.length > 0) {
            DynamicObject user = userList[0];
            boolean password = PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)String.valueOf(currUserId)), (String)userpdStr, (String)user.getString("password"));
            return password;
        }
        return false;
    }

    protected static void switch2OriginOp(AbstractFormPlugin formPlugin, OperateConfirmLog operateConfirmLog) {
        Map showParameter = formPlugin.getView().getFormShowParameter().getCustomParams();
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank(showParameter.get("authCallBackClass")) && kd.bos.dataentity.utils.StringUtils.isNotBlank(showParameter.get("authCallBackMethod"))) {
            SecondConfirmPluginService.invokeRpcOperation(showParameter, formPlugin);
            operateConfirmLog.setOpResult("1");
            return;
        }
        String operationKey = (String)showParameter.get("operationkey");
        OperateOption option = OperateOption.create();
        String operateJsonStr = (String)showParameter.get("operateoption");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)operateJsonStr)) {
            Map operateMap = (Map)SerializationUtils.fromJsonString((String)operateJsonStr, Map.class);
            Map map = (Map)operateMap.get("variables");
            for (Map.Entry entry : map.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
            option.setVariableValue("confirmsource", formPlugin.getClass().getSimpleName());
        }
        String pageId = (String)showParameter.get("pageid");
        IFormView sourceView = formPlugin.getView().getView(pageId);
        sourceView.invokeOperation(operationKey, option);
        formPlugin.getView().sendFormAction(formPlugin.getView().getParentView());
        formPlugin.getView().close();
        SecondConfirmPluginService.cacheSaveOp(operationKey, (String)showParameter.get("entityId"));
        operateConfirmLog.setOpResult("1");
    }

    private static void invokeRpcOperation(Map<String, Object> showParameter, AbstractFormPlugin formPlugin) {
        try {
            Map callBackParams = (Map)JSONObject.parseObject((String)showParameter.get("authCallBackParams").toString(), Map.class);
            String billPageId = (String)showParameter.get("billPageId");
            String appId = formPlugin.getView().getServiceAppId(billPageId);
            DispatchServiceHelper.invokeBOSService((String)appId, (String)((String)showParameter.get("authCallBackClass")), (String)((String)showParameter.get("authCallBackMethod")), (Object[])new Object[]{callBackParams});
        }
        catch (Exception e) {
            LOG.error("invokeRpcOperation error", (Throwable)e);
        }
        formPlugin.getView().close();
    }

    private static void cacheSaveOp(String operationKey, String entityId) {
        CacheLoginUtils.setAttribute((String)(entityId + operationKey), (String)RequestContext.get().getGlobalSessionId(), (String)operationKey, (int)28800);
    }

    public String getVerifyOperateName(String formNumber, String operate) {
        if (StringUtils.isBlank((CharSequence)operate)) {
            return null;
        }
        List ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        String[] operations = operate.split(",");
        ArrayList nameList = new ArrayList(8);
        for (String operation : operations) {
            List collect = ops.stream().filter(v -> operation.equals(v.get("key"))).map(v -> {
                Map name = (Map)v.get("name");
                String s = (String)name.get(Lang.get().name());
                return s;
            }).collect(Collectors.toList());
            nameList.addAll(collect);
        }
        return String.join((CharSequence)",", nameList);
    }

    public void opSchemeInitValue() {
        Map paraMap = this.formView.getFormShowParameter().getCustomParams();
        String opentype = (String)paraMap.get("opentype");
        String formNumber = (String)paraMap.get(FORM_NUMBER);
        this.pageCache.put(FORM_NUMBER, formNumber);
        List result = (List)paraMap.get(VALUE);
        this.pageCache.put(VALUE, SerializationUtils.toJsonString((Object)result));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)result)) {
            String OperateName = ((Map)result.get(0)).get(VERIFY_OPERATE) + "";
            this.dataModel.setValue(VERIFY_OPERATE, (Object)OperateName);
        }
        if ("new".equals(opentype)) {
            return;
        }
        this.dataModel.setValue(FORM_OBJECT, (Object)formNumber);
        this.dataModel.setValue(AUTH_ONCE, paraMap.get(AUTH_ONCE));
        this.dataModel.setValue(VERIFY_MODE, paraMap.get(VERIFY_MODE));
        this.dataModel.setValue(STATUS, paraMap.get("enable"));
    }

    public void opSchemeClick(EventObject evt, AbstractFormPlugin plugin) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "verifyoperate": {
                this.getVerifyOperate(plugin);
                break;
            }
            case "btnok": {
                this.returnDataAndClose();
                break;
            }
        }
    }

    public void returnDataAndClose() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        FormShowParameter showParameter = this.formView.getFormShowParameter();
        this.appendOperations("Id", showParameter.getParentFormId());
        this.appendOperations("_Type_", "CertRule");
        List<Map<String, Object>> verifyOperations = this.getOperations();
        para.put(VALUE, verifyOperations);
        para.put(FORM_OBJECT, this.dataModel.getValue(FORM_OBJECT));
        para.put(VERIFY_MODE, this.dataModel.getValue(VERIFY_MODE));
        para.put(AUTH_ONCE, this.dataModel.getValue(AUTH_ONCE));
        para.put(STATUS, this.dataModel.getValue(STATUS));
        if (this.dataModel.getValue(FORM_OBJECT) == null) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"OpSchemePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            DynamicObject value = (DynamicObject)this.dataModel.getValue(FORM_OBJECT);
            if (null == showParameter.getCustomParam(KEY_FID) && this.existScheme(value.getString("number"))) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5b58\u5728\u65b9\u6848\u3002", (String)"OpConfirmListPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            para.put(KEY_FID, showParameter.getCustomParam(KEY_FID));
            String message = this.checkData();
            this.pageCache.put("close", "1");
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)message)) {
                this.formView.showTipNotification(message);
            } else {
                this.formView.returnDataToParent(para);
                this.formView.close();
            }
        }
    }

    private String checkData() {
        String verifyOperate = (String)this.formView.getModel().getValue(VERIFY_OPERATE);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)verifyOperate.trim())) {
            return ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpSchemePlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        return "";
    }

    private void getVerifyOperate(AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_operationselect");
        List context = (List)this.formView.getFormShowParameter().getCustomParams().get("context");
        parameter.setCustomParam(META_CONTEXT, (Object)context);
        Object bizObj = this.dataModel.getValue(FORM_OBJECT);
        if (bizObj instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)bizObj;
            this.pageCache.put(FORM_NUMBER, obj.getString("number"));
        }
        String formNumber = this.pageCache.get(FORM_NUMBER);
        parameter.setCustomParam(FORM_NUMBER, (Object)formNumber);
        List<Map<String, Object>> operations = this.getOperations();
        if (operations != null && operations.size() > 0) {
            parameter.setCustomParam("operates", operations.get(0).get(VERIFY_OPERATE));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, VERIFY_OPERATE));
        this.formView.showForm(parameter);
    }

    private void appendOperations(String key, Object value) {
        List<Map<String, Object>> operations = this.getOperations();
        if (org.apache.commons.lang3.ObjectUtils.isEmpty(operations)) {
            operations.add(new HashMap());
        }
        operations.get(0).put(key, value);
        this.pageCache.put(VALUE, SerializationUtils.toJsonString(operations));
    }

    private List<Map<String, Object>> getOperations() {
        List ops = SerializationUtils.fromJsonStringToList((String)this.pageCache.get(VALUE), Map.class);
        return ops == null ? new ArrayList() : ops;
    }

    public void opSchemeClosed(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returenData = closedCallBackEvent.getReturnData();
        if (returenData instanceof Map) {
            Map data = (Map)returenData;
            if (VERIFY_OPERATE.equalsIgnoreCase(actionId) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)data)) {
                List operations = (List)data.get(VERIFY_OPERATE);
                String operationsString = this.getOperationsString(operations, "OpCode");
                String operationsName = this.getOperationsString(operations, "OpName");
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)operationsString) && operationsString.length() > 600) {
                    this.formView.showTipNotification(ResManager.loadKDString((String)"\u52a0\u7b7e\u64cd\u4f5c\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OpSchemePlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.dataModel.setValue(VERIFY_OPERATE, (Object)operationsName);
                this.appendOperations(VERIFY_OPERATE, operationsString);
            }
        }
    }

    private String getOperationsString(List<Map<String, Object>> operations, String opCode) {
        StringBuilder builder = new StringBuilder();
        int size = operations.size();
        for (int i = 0; i < size; ++i) {
            builder.append(operations.get(i).get(opCode));
            if (i >= size - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public void generatorCaptcha(String key) {
        try {
            Map map = CaptchaGeneratorUtils.generatorCaptcha();
            if (!ObjectUtils.isEmpty((Object)map)) {
                Image image = (Image)this.formView.getControl(key);
                image.setUrl(map.get("content").toString());
                this.pageCache.put("captcha", map.get("verifycode").toString());
                this.pageCache.put("captcha_time", System.currentTimeMillis() + "");
                this.countDown(IMG_COUNTDOWN_AP, 60);
                this.formView.setVisible(Boolean.FALSE, new String[]{IMG_COUNTDOWN_AP});
            }
        }
        catch (IOException var3) {
            LOG.error("\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\u3002", (Throwable)var3);
        }
    }

    public void verifyEmailClick(EventObject evt, AbstractFormPlugin formPlugin) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_getcode": {
                this.getEmailCode();
                break;
            }
            case "btnok": {
                this.checkEmailCode(formPlugin);
                break;
            }
            case "imageap": {
                this.generatorCaptcha("imageap");
                break;
            }
        }
    }

    private void checkEmailCode(AbstractFormPlugin formPlugin) {
        OperateConfirmLog operateConfirmLog = this.initLogInfo(formPlugin.getView().getFormShowParameter().getCustomParams());
        operateConfirmLog.setVerifyMode(2);
        try {
            String emailNum = (String)this.dataModel.getValue(EMAIL);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)emailNum)) {
                this.pageCache.put(EMAIL, emailNum);
            }
            emailNum = this.pageCache.get(EMAIL);
            String verifyCode = (String)this.dataModel.getValue("verifycode");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)emailNum) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)verifyCode)) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u7bb1\u9a8c\u8bc1\u7801\u3002", (String)"VerifyCodePlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                if (this.verifyCode(emailNum, verifyCode, EMAIL)) {
                    this.doContinueOperate(formPlugin, operateConfirmLog);
                } else {
                    operateConfirmLog.setOpResult("2");
                }
                LoginLogUtils.addAuthOpLog((String)RequestContext.get().getGlobalSessionId(), (OperateConfirmLog)operateConfirmLog);
            }
        }
        catch (Exception e) {
            LOG.info("checkEmailCode", (Object)e);
        }
    }

    private void getEmailCode() {
        Object email = this.dataModel.getValue(EMAIL);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)email)) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b0\u90ae\u7bb1\u8d26\u53f7\u3002", (String)"PersonInformationPlugin_100", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            boolean isEmail = kd.bos.dataentity.utils.StringUtils.isEmail((String)email.toString());
            if (!isEmail) {
                this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u683c\u5f0f\u3002", (String)"PersonInformationPlugin_101", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                RequestContext requestContext = RequestContext.get();
                Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
                int msgTimeout = LoginMessageUtils.getMsgTimeout((Account)account);
                boolean imgCodeFlag = this.checkImgCode();
                if (imgCodeFlag && this.sendEmail(email.toString(), msgTimeout)) {
                    this.formView.showSuccessNotification(this.getSendSuccessMsg(), Integer.valueOf(2000));
                    this.startCountDown(BTN_GET_CODE, EMAIL_NEWCOUNTDOWN_AP, EMAIL_NEWLABEL_AP, msgTimeout);
                }
            }
        }
    }

    private boolean sendEmail(String email, int msgTimeout) {
        RequestContext requestContext = RequestContext.get();
        Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
        if (!SmsService.isMsgChannelEnable((Account)account, (String)EMAIL)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u7535\u5b50\u90ae\u4ef6\u901a\u77e5\u3002", (String)"PersonInformationPlugin_74", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        String titleValue = "portal_code_number";
        String phoneCodeCache = this.cacheService.get(email + titleValue);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)phoneCodeCache)) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001\u9a8c\u8bc1\u7801\u3002", (String)"PersonInformationPlugin_123", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), msgTimeout), Integer.valueOf(2000));
            return false;
        }
        this.cacheService.remove(this.getVerifyTimeKey(email));
        IMessageService service = (IMessageService)ServiceFactory.getService((String)"IMessageService");
        SecureRandom random = new SecureRandom();
        int pCode = random.nextInt(1000000);
        String pCodeStr = "00000" + pCode;
        pCodeStr = pCodeStr.substring(pCodeStr.length() - 6);
        pCodeStr = this.modifyPhoneCode(pCodeStr);
        this.cacheService.put(email + titleValue, pCodeStr);
        this.cacheService.expireAfter(email + titleValue, msgTimeout);
        this.cacheService.put(email + titleValue + "code", pCodeStr, 300);
        EmailInfo emailInfo = new EmailInfo();
        emailInfo.setContentMimeType("TEXT");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(email);
        emailInfo.setReceiver(receivers);
        emailInfo.setTitle(ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1", (String)"VerifyCodePlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        String message = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%s\uff0c\u6765\u81ea\u77ed\u4fe1\u4e8c\u6b21\u8eab\u4efd\u8ba4\u8bc1\uff0c\u4e94\u5206\u949f\u6709\u5185\u6548\u3002", (String)"SecondConfirmPluginService_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), pCodeStr);
        emailInfo.setContent(message);
        service.sendEmail(emailInfo);
        return true;
    }

    public boolean existScheme(String formNumber) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)OPERATE_SCHEME, (String)"id", (QFilter[])new QFilter[]{new QFilter(KEY_FORMNUMBER, "=", (Object)formNumber)});
        return query != null && query.size() > 0;
    }

    public void confirmListRefreshPage(String bizAppId) {
        List<OperateConfirmScheme> allSchemes = this.loadAllScheme();
        this.putSchemeCache(allSchemes);
        this.searchByNodeId(allSchemes, bizAppId);
    }

    public void searchByNodeId(List<OperateConfirmScheme> allSchemes, String nodedId) {
        ArrayList<OperateConfirmScheme> mySchemes = new ArrayList<OperateConfirmScheme>();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)nodedId)) {
            mySchemes.addAll(allSchemes);
        } else {
            String rootNodeJson = this.pageCache.getBigObject(CACHE_ID_TREE_NODES);
            BizAppTreeBuilder bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)rootNodeJson, BizAppTreeBuilder.class);
            TreeNode rootNode = bizAppTreeBuilder.getRootNode();
            if (rootNode.getId().equals(nodedId)) {
                mySchemes.addAll(allSchemes);
            } else {
                this.treeNodeSearch(rootNode, nodedId, bizAppTreeBuilder, allSchemes, mySchemes);
            }
        }
        this.refreshEntryGrid(mySchemes);
    }

    private void treeNodeSearch(TreeNode rootNode, String nodedId, BizAppTreeBuilder bizAppTreeBuilder, List<OperateConfirmScheme> allSchemes, List<OperateConfirmScheme> mySchemes) {
        TreeNode cloudNode = null;
        for (TreeNode node : rootNode.getChildren()) {
            if (!node.getId().equals(nodedId)) continue;
            cloudNode = node;
            break;
        }
        HashSet<String> bizAppIds = new HashSet<String>();
        if (cloudNode != null) {
            bizAppIds.add(nodedId);
            if (cloudNode.getChildren() != null) {
                for (TreeNode bizAppNode : cloudNode.getChildren()) {
                    bizAppIds.add(bizAppNode.getId());
                    bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                }
            }
        } else {
            bizAppIds.add(nodedId);
            bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
        }
        for (OperateConfirmScheme scheme : allSchemes) {
            if (!bizAppIds.contains(scheme.getBizAppId())) continue;
            mySchemes.add(scheme);
        }
    }

    private void refreshEntryGrid(List<OperateConfirmScheme> schemes) {
        this.dataModel.deleteEntryData(KEY_ENTRY_ENTITY);
        if (schemes.size() > 0) {
            this.dataModel.beginInit();
            this.dataModel.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, schemes.size());
            for (int index = 0; index < schemes.size(); ++index) {
                OperateConfirmScheme scheme = schemes.get(index);
                this.renderRow(scheme, index);
            }
            this.dataModel.endInit();
        }
        this.formView.updateView(KEY_ENTRY_ENTITY);
    }

    private List<OperateConfirmScheme> loadAllScheme() {
        DynamicObjectCollection operateScheme = QueryServiceHelper.query((String)OPERATE_SCHEME, (String)"id,formnumber,verifyoperate,verifymode,bizappid,enable,authonce", (QFilter[])new QFilter[0]);
        ArrayList<OperateConfirmScheme> allScheme = new ArrayList<OperateConfirmScheme>(10);
        for (DynamicObject dynamicObject : operateScheme) {
            OperateConfirmScheme scheme = new OperateConfirmScheme();
            scheme.setId(dynamicObject.getLong("id"));
            scheme.setFormNumber(dynamicObject.getString(1));
            scheme.setVerifyOperate(dynamicObject.getString(2));
            scheme.setVerifyMode(dynamicObject.getInt(3));
            scheme.setBizAppId(dynamicObject.getString(4));
            scheme.setEnable(dynamicObject.getInt(5));
            scheme.setFormName(this.getFormName(scheme.getFormNumber()));
            scheme.setVerifyOperateDesc(this.getOperationsString(scheme.getVerifyOperate(), scheme.getFormNumber()));
            scheme.setAuthOnce(this.getInt(dynamicObject.getBoolean(6)));
            allScheme.add(scheme);
        }
        return allScheme;
    }

    private void renderRow(OperateConfirmScheme scheme, int rowIndex) {
        DynamicObject dynamicObject = this.getAppInfo(scheme.getBizAppId());
        if (dynamicObject != null) {
            ILocaleString name = dynamicObject.getLocaleString("name");
            this.dataModel.setValue("bizappid", (Object)name.getLocaleValue(), rowIndex);
        }
        this.dataModel.setValue(KEY_FID, (Object)scheme.getId(), rowIndex);
        this.dataModel.setValue(KEY_FORMNUMBER, (Object)scheme.getFormNumber(), rowIndex);
        this.dataModel.setValue(KEY_FORM_NAME, (Object)scheme.getFormName(), rowIndex);
        String modelType = FormMetadataCache.getFormConfig((String)scheme.getFormNumber()).getModelType();
        String billTypeName = ResManager.loadKDString((String)"\u5355\u636e", (String)"SecondConfirmPluginService_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        String baseTypeName = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"SecondConfirmPluginService_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        this.dataModel.setValue("formtype", (Object)("bill".equalsIgnoreCase(modelType) ? billTypeName : ("base".equalsIgnoreCase(modelType) ? baseTypeName : "")), rowIndex);
        String OperateName = scheme.getVerifyOperate();
        this.dataModel.setValue("verifyopcode", (Object)scheme.getVerifyOperate(), rowIndex);
        this.dataModel.setValue(VERIFY_OPERATE, (Object)OperateName, rowIndex);
        this.dataModel.setValue(VERIFY_MODE, (Object)scheme.getVerifyMode(), rowIndex);
        this.dataModel.setValue("enable", (Object)scheme.getEnable(), rowIndex);
        this.dataModel.setValue(AUTH_ONCE, (Object)scheme.getAuthOnce(), rowIndex);
    }

    private DynamicObject getAppInfo(String bizAppId) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"number,name");
            return dynamicObject;
        }
        catch (Exception e) {
            LOG.info("getAppInfo", (Object)e);
            return null;
        }
    }

    private int getInt(Boolean value) {
        if (value.booleanValue()) {
            return 1;
        }
        return 0;
    }

    private String getOperationsString(String operationStr, String formNumber) {
        String[] operations;
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operationStr)) {
            return "";
        }
        boolean showName = false;
        List ops = null;
        if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)formNumber)) {
            showName = true;
            ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String name : operations = operationStr.split(",")) {
            if (showName) {
                name = this.getOpName(name, ops);
            }
            builder.append(name);
            if (++i >= operations.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private String getFormName(String formNumber) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)formNumber)) {
            return "";
        }
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        return entityMetadata.getName() == null ? "" : entityMetadata.getName().toString();
    }

    private String getOpName(String opKey, List<Map<String, Object>> ops) {
        String opName = "";
        for (Map<String, Object> op : ops) {
            if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)opKey, (CharSequence)String.valueOf(op.get("key")))) continue;
            opName = op.get("name") == null ? "" : (String)((Map)op.get("name")).get(Lang.get().toString());
            break;
        }
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)opName)) {
            opName = opKey;
            LOG.info("\u83b7\u53d6\u64cd\u4f5c\u540d\u79f0\u5931\u8d25\uff0copKey:" + opKey + " ops:" + SerializationUtils.toJsonString(ops));
        }
        return opName;
    }

    private void putSchemeCache(List<OperateConfirmScheme> schemes) {
        String schemesJsonString = SerializationUtils.toJsonString(schemes);
        this.pageCache.put(OPERATION_SCHEMES, schemesJsonString);
        this.allScheme = schemes;
    }

    public void confirmListDo(String opKey, AbstractListPlugin plugin) {
        if (opKey.equalsIgnoreCase("new")) {
            this.doNew(plugin);
        } else if (opKey.equalsIgnoreCase(KEY_MODIFY)) {
            this.doModify(plugin);
        } else if (opKey.equalsIgnoreCase(KEY_DELETE)) {
            this.doBeforeDelete(plugin);
        } else if (opKey.equalsIgnoreCase("enable") || opKey.equalsIgnoreCase("disable")) {
            this.updateSchemeStatus(opKey);
        } else if (KEY_ADD_ORG.equals(opKey)) {
            this.showOrg(plugin);
        } else if (KEY_REFRESH.equals(opKey)) {
            String nodeId = this.pageCache.get(CURR_NODE);
            this.confirmListRefreshPage(nodeId);
        }
    }

    private void showOrg(AbstractListPlugin plugin) {
        OperateConfirmScheme myScheme = this.getSelectScheme();
        if (myScheme == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_ORG);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(SIGN_SCHEMEID, (Object)String.valueOf(myScheme.getId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, KEY_ADD_ORG);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d7\u63a7\u7ec4\u7ec7", (String)"OpConfirmListPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.formView.showForm(showParameter);
    }

    private OperateConfirmScheme getSelectScheme() {
        int rowIndex = this.dataModel.getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.formView.getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (selRows.length < 1) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OpConfirmListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        long fid = (Long)this.dataModel.getValue(KEY_FID, rowIndex);
        List<OperateConfirmScheme> allSchemes = this.getSchemeCache();
        OperateConfirmScheme myScheme = null;
        for (OperateConfirmScheme scheme : allSchemes) {
            if (fid != scheme.getId()) continue;
            myScheme = scheme;
            break;
        }
        return myScheme;
    }

    public List<OperateConfirmScheme> getSchemeCache() {
        if (this.allScheme != null) {
            return this.allScheme;
        }
        String schemesJsonString = this.pageCache.get(OPERATION_SCHEMES);
        this.allScheme = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)schemesJsonString) ? new ArrayList<OperateConfirmScheme>() : SerializationUtils.fromJsonStringToList((String)schemesJsonString, OperateConfirmScheme.class);
        return this.allScheme;
    }

    private void updateSchemeStatus(String opKey) {
        EntryGrid entry = (EntryGrid)this.formView.getControl(KEY_ENTRY_ENTITY);
        int[] rows = entry.getSelectRows();
        int selectedCount = rows.length;
        if (selectedCount == 0) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OpConfirmListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            OperateConfirmScheme[] operateConfirmScheme = new OperateConfirmScheme[selectedCount];
            int i = 0;
            for (int rowIndex : rows) {
                OperateConfirmScheme opScheme = new OperateConfirmScheme();
                opScheme.setId((Long)entry.getModel().getValue(KEY_FID, rowIndex));
                opScheme.setFormNumber((String)entry.getModel().getValue(KEY_FORMNUMBER, rowIndex));
                opScheme.setFormName(this.getFormName(opScheme.getFormNumber()));
                opScheme.setVerifyOperate((String)entry.getModel().getValue("verifyopcode", rowIndex));
                opScheme.setVerifyMode(Integer.parseInt((String)entry.getModel().getValue(VERIFY_MODE, rowIndex)));
                opScheme.setAuthOnce(this.getInt((Boolean)entry.getModel().getValue(AUTH_ONCE, rowIndex)));
                if ("enable".equalsIgnoreCase(opKey)) {
                    opScheme.setEnable(1);
                } else {
                    opScheme.setEnable(0);
                }
                operateConfirmScheme[i] = opScheme;
                ++i;
            }
            if (this.saveScheme(operateConfirmScheme)) {
                this.confirmService.clearType();
                this.confirmListRefreshPage("");
                String msg = "enable".equalsIgnoreCase(opKey) ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"OpConfirmListPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"OpConfirmListPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                this.formView.showSuccessNotification(msg);
            }
        }
    }

    private boolean saveScheme(OperateConfirmScheme[] schemes) {
        if (ObjectUtils.isEmpty((Object[])schemes)) {
            return false;
        }
        IDataEntityType opSchemeType = OrmUtils.getDataEntityType(OperateConfirmScheme.class);
        Object[] result = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)OPERATE_SCHEME);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        int size = schemes.length;
        if (size == 1) {
            OperateConfirmScheme scheme = schemes[0];
            if (scheme.getId() > 0L) {
                return this.schemeUpdate(scheme, type, cacheManager);
            }
            result = SaveServiceHelper.save((IDataEntityType)opSchemeType, (Object[])new Object[]{scheme});
            cacheManager.removeByDt();
            return !ObjectUtils.isEmpty((Object[])result);
        }
        return this.schemeBatchUpdate(size, schemes, type, cacheManager);
    }

    private boolean schemeBatchUpdate(int size, OperateConfirmScheme[] schemes, MainEntityType type, DataEntityCacheManager cacheManager) {
        Object[] ids = new Object[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = schemes[i].getId();
        }
        Object[] objs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)type);
        for (int j = 0; j < size; ++j) {
            objs[j] = this.setDynamicObject((DynamicObject)objs[j], schemes[j]);
        }
        BusinessDataWriter.update((IDataEntityType)type, (Object[])objs);
        cacheManager.removeByDt();
        return true;
    }

    private boolean schemeUpdate(OperateConfirmScheme scheme, MainEntityType type, DataEntityCacheManager cacheManager) {
        Object[] objs = BusinessDataServiceHelper.load((Object[])new Object[]{scheme.getId()}, (DynamicObjectType)type);
        if (ObjectUtils.isEmpty((Object[])objs)) {
            return false;
        }
        Object obj = objs[0];
        DynamicObject objSave = this.setDynamicObject((DynamicObject)obj, scheme);
        BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{objSave});
        cacheManager.removeByDt();
        return true;
    }

    private DynamicObject setDynamicObject(DynamicObject obj, OperateConfirmScheme scheme) {
        obj.set("id", (Object)scheme.getId());
        obj.set(KEY_FORMNUMBER, (Object)scheme.getFormNumber());
        obj.set(VERIFY_OPERATE, (Object)scheme.getVerifyOperate());
        obj.set(VERIFY_MODE, (Object)scheme.getVerifyMode());
        obj.set(AUTH_ONCE, (Object)scheme.getAuthOnce());
        obj.set("enable", (Object)scheme.getEnable());
        return obj;
    }

    private void doBeforeDelete(AbstractListPlugin plugin) {
        EntryGrid grid = (EntryGrid)this.formView.getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (selRows.length < 1) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OpConfirmListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)plugin);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u64cd\u4f5c\u9a8c\u8bc1\u65b9\u6848\uff1f", (String)"OpConfirmListPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.formView.showConfirm(strDeleteConfirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        }
    }

    public void doModify(AbstractListPlugin plugin) {
        int rowCount = this.dataModel.getEntryRowCount(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.formView.getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount != 0 && selRows != null && selRows.length >= 1) {
            int rowIndex = this.dataModel.getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
            String formNumber = (String)this.dataModel.getValue(KEY_FORMNUMBER, rowIndex);
            long fid = (Long)this.dataModel.getValue(KEY_FID, rowIndex);
            List<Map<String, Object>> operations = this.getOperations(rowIndex);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_secondopconfirm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("opentype", (Object)KEY_MODIFY);
            showParameter.setCustomParam(VALUE, operations);
            showParameter.setCustomParam(FORM_NUMBER, (Object)formNumber);
            showParameter.setCustomParam(VERIFY_MODE, this.dataModel.getValue(VERIFY_MODE, rowIndex));
            showParameter.setCustomParam(KEY_FID, (Object)fid);
            showParameter.setCustomParam(AUTH_ONCE, this.dataModel.getValue(AUTH_ONCE, rowIndex));
            showParameter.setCustomParam("treeNodeId", (Object)this.pageCache.get(CURR_NODE));
            showParameter.setCustomParam("enable", this.dataModel.getValue("enable", rowIndex));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, KEY_MODIFY);
            showParameter.setCloseCallBack(closeCallBack);
            this.formView.showForm(showParameter);
        } else {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OpConfirmListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private List<Map<String, Object>> getOperations(int selectRow) {
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>(6);
        String verifyOperateStr = (String)this.dataModel.getValue("verifyopcode", selectRow);
        HashMap<String, String> opsMap = new HashMap<String, String>();
        opsMap.put(VERIFY_OPERATE, verifyOperateStr);
        ops.add(opsMap);
        return ops;
    }

    private void doNew(AbstractListPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_secondopconfirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("treeNodeId", (Object)this.pageCache.get(CURR_NODE));
        showParameter.setCustomParam("opentype", (Object)"new");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "new");
        showParameter.setCloseCallBack(closeCallBack);
        this.formView.showForm(showParameter);
    }

    public void confirmListClosed(ClosedCallBackEvent closedCallBackEvent, String actionId) {
        if (actionId.equalsIgnoreCase("new")) {
            this.afterShowNewForm(closedCallBackEvent, "new");
        } else if (actionId.equalsIgnoreCase(KEY_MODIFY)) {
            this.afterShowNewForm(closedCallBackEvent, KEY_MODIFY);
        }
    }

    private void afterShowNewForm(ClosedCallBackEvent closedCallBackEvent, String actionId) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params != null) {
            DynamicObject formObject = (DynamicObject)params.get(FORM_OBJECT);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)formObject)) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"OpSchemePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String formNumber = formObject.getString("number");
            String formName = formObject.getLocaleString("name").toString();
            long fid = params.get(KEY_FID) == null ? 0L : Long.parseLong(params.get(KEY_FID).toString());
            List opParam = (List)params.get(VALUE);
            String bizAppId = this.pageCache.get(CURR_NODE);
            String verifyOperate = "";
            if (!ObjectUtils.isEmpty((Object)opParam)) {
                Map op = (Map)opParam.get(0);
                verifyOperate = (String)op.get(VERIFY_OPERATE);
            }
            OperateConfirmScheme scheme = new OperateConfirmScheme();
            if (fid != 0L) {
                scheme.setId(fid);
            }
            scheme.setEnable(this.getEnableFromBoolean(params.get(STATUS)));
            scheme.setVerifyMode(Integer.parseInt((String)params.get(VERIFY_MODE)));
            scheme.setFormName(formName);
            scheme.setFormNumber(formNumber);
            scheme.setVerifyOperate(verifyOperate);
            String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
            String formAppId = MetadataDao.getAppIdByFormId((String)formId);
            scheme.setBizAppId(formAppId);
            scheme.setFormBizAppId(formAppId);
            scheme.setAuthOnce(this.getInt((Boolean)params.get(AUTH_ONCE)));
            this.toDoSave(scheme, bizAppId, actionId);
        }
    }

    private void toDoSave(OperateConfirmScheme scheme, String bizAppId, String actionId) {
        OperateConfirmScheme[] schemes = new OperateConfirmScheme[]{scheme};
        if (this.saveScheme(schemes)) {
            this.confirmService.clearType();
            this.confirmListRefreshPage(bizAppId);
        }
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OpConfirmListPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private int getEnableFromBoolean(Object o) {
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public void doDelete() {
        EntryGrid grid = (EntryGrid)this.formView.getControl(KEY_ENTRY_ENTITY);
        int[] selRows = grid.getSelectRows();
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (int idx : selRows) {
            long fid = (Long)this.dataModel.getValue(KEY_FID, idx);
            schemeIds.add(fid);
        }
        this.delete(schemeIds);
        this.dataModel.deleteEntryRows(KEY_ENTRY_ENTITY, selRows);
        grid.clearEntryState();
        List<OperateConfirmScheme> allSchemes = this.getSchemeCache();
        Iterator<OperateConfirmScheme> iterator = allSchemes.iterator();
        while (iterator.hasNext()) {
            OperateConfirmScheme opConfirmScheme = iterator.next();
            if (!schemeIds.contains(opConfirmScheme.getId())) continue;
            iterator.remove();
        }
        this.putSchemeCache(allSchemes);
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OpConfirmListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private void delete(List<Long> schemeIds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)OPERATE_SCHEME);
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])schemeIds.toArray());
        DeleteServiceHelper.delete((String)SIGNENTITY_ORG, (QFilter[])new QFilter[]{new QFilter(SCHEME_ID, "in", schemeIds)});
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByDt();
    }

    public List<String> getSearchList(SearchEnterEvent e, String key) {
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_SEARCH_SCHEME, (CharSequence)key)) {
            String searchText = e.getText();
            return kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)searchText) ? this.doSearchList(searchText) : null;
        }
        return Collections.emptyList();
    }

    private List<String> doSearchList(String searchText) {
        HashSet<String> searchList = new HashSet<String>();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<String>();
        }
        List<OperateConfirmScheme> allSchemes = this.getSchemeCache();
        for (OperateConfirmScheme scheme : allSchemes) {
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)scheme.getFormName()) && scheme.getFormName().indexOf(searchText) == 0) {
                searchList.add(scheme.getFormName());
            } else if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)scheme.getFormNumber()) && scheme.getFormNumber().indexOf(searchText) == 0) {
                searchList.add(scheme.getFormNumber());
            }
            if (searchList.size() < 10) continue;
            break;
        }
        return new ArrayList<String>(searchList);
    }

    public void confirmListSearch(SearchEnterEvent e, Search search) {
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_SEARCH_SCHEME, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_SEARCH_TREE_NODE, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.searchNodeByText(searchText);
        }
    }

    private void searchNodeByText(String searchText) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)searchText)) {
            String nodes = this.pageCache.getBigObject(CACHE_ID_TREE_NODES);
            BizAppTreeBuilder bizAppTreeBuilder = (BizAppTreeBuilder)SerializationUtils.fromJsonString((String)nodes, BizAppTreeBuilder.class);
            TreeNode root = bizAppTreeBuilder.getRootNode();
            LeftTreeSearchUtil.searchNodeByTextInTree(KEY_TREE_VIEW, root, searchText, this.formView);
        }
    }

    private void doSearchByBill(String searchText) {
        List<OperateConfirmScheme> allSchemes = this.getSchemeCache();
        ArrayList<OperateConfirmScheme> mySchemes = new ArrayList<OperateConfirmScheme>(10);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)searchText)) {
            mySchemes.addAll(allSchemes);
        } else {
            for (OperateConfirmScheme scheme : allSchemes) {
                boolean flag = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)scheme.getFormName()) && scheme.getFormName().contains(searchText) || kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)scheme.getFormNumber()) && scheme.getFormNumber().contains(searchText);
                if (!flag) continue;
                mySchemes.add(scheme);
            }
        }
        this.refreshEntryGrid(mySchemes);
    }

    private void checkLastNode(int i, Integer number, List<TreeNode> treeNodes) {
        if (i == treeNodes.size() - 1) {
            number = treeNodes.size();
            this.pageCache.put("op_confirm_list_search_num", number + "");
            this.pageCache.remove("op_confirm_list_search_text");
            this.pageCache.removeBigObject("op_confirm_list_search_treeNodes");
            this.formView.showTipNotification(BaseMessage.getMessage((String)"M00029"));
        }
    }

    private List<TreeNode> getSearchNodes(List<TreeNode> allChildren, String searchText) {
        String confirmListSearchText = this.pageCache.get("op_confirm_list_search_text");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)confirmListSearchText) && searchText.equals(confirmListSearchText)) {
            String searchTreeNodesStr = this.pageCache.getBigObject("op_confirm_list_search_treeNodes");
            return SerializationUtils.fromJsonStringToList((String)searchTreeNodesStr, TreeNode.class);
        }
        List<TreeNode> collect = allChildren.stream().filter(v -> v.getText().contains(searchText)).collect(Collectors.toList());
        this.pageCache.put("op_confirm_list_search_num", "0");
        this.pageCache.put("op_confirm_list_search_text", searchText);
        this.pageCache.putBigObject("op_confirm_list_search_treeNodes", SerializationUtils.toJsonString(collect));
        return collect;
    }

    private void getAllChildren(List<TreeNode> children, List<TreeNode> allChildren) {
        if (children != null && children.size() > 0) {
            allChildren.addAll(children);
            for (TreeNode child : children) {
                this.getAllChildren(child.getChildren(), allChildren);
            }
        }
    }

    public TreeNode buildTreeNodes() {
        BizAppTreeBuilder bizAppTreeBuilder = new BizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpConfirmListPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        String json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
        this.pageCache.putBigObject(CACHE_ID_TREE_NODES, json);
        return root;
    }

    public void userPdSetUser(EventObject e) {
        Map userMap = UserServiceHelper.getUserInfoByID((long)RequestContext.get().getCurrUserId());
        String name = (String)userMap.get("name");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)name)) {
            this.dataModel.setValue("user", (Object)name);
        } else {
            String emailStr = (String)userMap.get(EMAIL);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)emailStr)) {
                this.dataModel.setValue("user", (Object)emailStr);
            } else {
                String phoneStr = (String)userMap.get(PHONE);
                this.dataModel.setValue("user", (Object)phoneStr);
            }
        }
    }

    public void setConfirmText(String text) {
        Label confirmText = (Label)this.formView.getControl("confirmtext");
        confirmText.setText(text);
    }

    public void showUserBindInfo() {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        Object confirmText = customParams.get(USER_BIND_CONFIRM_TEXT);
        Object path = customParams.get(USER_BIND_PATH_TEXT);
        if (confirmText != null && path != null) {
            Label confirmTextLabel = (Label)this.formView.getControl("confirmtext");
            Label pathLabel = (Label)this.formView.getControl("labelpath");
            confirmTextLabel.setText(confirmText.toString());
            pathLabel.setText(path.toString());
        }
    }

    public void showClosedForm(BeforeClosedEvent e, AbstractFormPlugin plugin) {
        String close = this.pageCache.get("close");
        if (this.dataModel.getDataChanged() && !"1".equals(close)) {
            e.setCancel(true);
            this.formView.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"ShortcutsFromPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("continue_close", (IFormPlugin)plugin));
        }
    }

    public Boolean checkPerm() {
        String formNumber = this.formView.getEntityId();
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        String formAppId = MetadataDao.getAppIdByFormId((String)formId);
        Boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)formAppId, (String)formNumber, (String)PERM_MODIFY);
        if (!hasPerm.booleanValue()) {
            String msg = this.getShowCheckMsg(formNumber);
            this.formView.showErrorNotification(msg);
        }
        return hasPerm;
    }

    private String getShowCheckMsg(String formId) {
        String msg = ResManager.loadKDString((String)"\u65e0\"%s\"\u7684\"\u4fee\u6539\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OpSchemePlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            LocaleString caption = formConfig.getCaption();
            msg = String.format(msg, caption.getLocaleValue());
        }
        catch (Exception e) {
            LOG.info("getShowCheckMsg", (Object)e);
            msg = String.format(msg, formId);
        }
        return msg;
    }

    public void refreshOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.dataModel.getEntryEntity(ENTITY_ORG);
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>();
        for (DynamicObject curOrgObj : curOrgList) {
            subOrgMap.put(curOrgObj.getDynamicObject(ORG_ID).getLong("id"), curOrgObj.get(IS_INCLUDE_SUB_ORG));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        int m = orgCol.size();
        for (int i = 0; i < m; ++i) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(i);
            DynamicObject org = orgObj.getDynamicObject("fbasedataId");
            if (org == null) continue;
            this.dataModel.createNewEntryRow(ENTITY_ORG);
            this.dataModel.setValue(ORG_ID, (Object)org, i);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong("id"));
            if (isIncludeSubOrg == null) continue;
            this.dataModel.setValue(IS_INCLUDE_SUB_ORG, isIncludeSubOrg, i);
        }
    }

    public void clearAllEntryRow() {
        int rowCount = this.dataModel.getEntryRowCount(ENTITY_ORG);
        for (int i = rowCount - 1; i >= 0; --i) {
            this.dataModel.deleteEntryRow(ENTITY_ORG, i);
        }
    }
}

