/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BaseThemeCusFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BaseThemeCusFormPlugin.class);
    private static final String KEY_HIDE_JSON_KEY = "content";
    private static final String KEY_COLOR_KEY = "color";
    private static final String KEY_JSON_KEY = "jsonedit";
    private static final String KEY_MAINBAR = "toolbarap";
    private static final String BTN_SAVE = "bar_save";
    private static final String KEY_ISDEFAULT_KEY = "isdefault";
    private static final String KEY_ENABLE_KEY = "enable";
    private static final String TBL_NAME = "T_BAS_UITheme";
    private static final String KEY_NUMBER_KEY = "number";
    private static final String KEY_THEME_TYPE = "ispreset";
    public static final String BOS_BASE_FORMPLUGIN = "bos-portal-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void afterBindData(EventObject e) {
        Object isPreset;
        super.afterBindData(e);
        Object json = this.getModel().getValue(KEY_HIDE_JSON_KEY);
        if (StringUtils.isNotBlank((Object)json)) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_JSON_KEY);
            codeEdit.setText(json.toString());
        }
        if (StringUtils.isNotBlank((Object)(isPreset = this.getModel().getValue(KEY_THEME_TYPE))) && Boolean.parseBoolean(isPreset.toString())) {
            HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
            jsonMap.put("l", -1);
            this.getView().updateControlMetadata(KEY_JSON_KEY, jsonMap);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)BTN_SAVE, (CharSequence)evt.getItemKey())) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_JSON_KEY);
            boolean type = Boolean.parseBoolean(this.getModel().getValue(KEY_THEME_TYPE).toString());
            String json = codeEdit.getText();
            if (StringUtils.isBlank((CharSequence)json)) {
                this.validReturn(evt, ResManager.loadKDString((String)"\u2018\u4e3b\u9898\u5185\u5bb9\u2019\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseThemeCusFormPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!type && StringUtils.isNotBlank((CharSequence)json)) {
                this.getModel().setValue(KEY_HIDE_JSON_KEY, (Object)json);
                Map theme = null;
                try {
                    Gson gson = new Gson();
                    Map map = (Map)gson.fromJson(json, Map.class);
                    map = (Map)JSON.parse((String)json);
                    theme = (Map)map.get("theme");
                }
                catch (Exception e) {
                    logger.info("json\u8f6c\u6362\u6210map\u5f02\u5e38, json\u5185\u5bb9:" + json, (Object)e);
                    this.validReturn(evt, ResManager.loadKDString((String)"\u4e3b\u9898\u5185\u5bb9\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseThemeCusFormPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (theme == null) {
                    this.validReturn(evt, ResManager.loadKDString((String)"\u4e3b\u9898\u5185\u5bb9\u5fc5\u987b\u5305\u542btheme\u3002", (String)"BaseThemeCusFormPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isBlank(theme.get("@theme-color"))) {
                    this.validReturn(evt, ResManager.loadKDString((String)"\u4e3b\u9898\u5185\u5bb9\u5fc5\u987b\u5305\u542b\u4e3b\u9898\u989c\u8272@theme-color\u3002", (String)"BaseThemeCusFormPlugin_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                String color = (String)theme.get("@theme-color");
                this.getModel().setValue(KEY_COLOR_KEY, (Object)color.replace(" ", ""));
            }
            Object isDefault = this.getModel().getValue(KEY_ISDEFAULT_KEY);
            Object number = this.getModel().getValue(KEY_NUMBER_KEY);
            Object enable = this.getModel().getValue(KEY_ENABLE_KEY);
            if (StringUtils.isNotBlank((Object)enable) && "0".equals(enable.toString())) {
                this.validReturn(evt, ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u4e3b\u9898\uff0c\u7981\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BaseThemeCusFormPlugin_4", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            if (StringUtils.isNotBlank((Object)isDefault) && !Boolean.parseBoolean(isDefault.toString()) && Boolean.TRUE.equals(this.isExistedDefault(id) == false)) {
                this.validReturn(evt, ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u4e00\u4e2a\u9ed8\u8ba4\u4e3b\u9898\uff0c\u5fc5\u987b\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e3b\u9898\u3002", (String)"BaseThemeCusFormPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.switchTheme();
        }
    }

    private void switchTheme() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map defaultThemeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)userId);
        proxy.addAction("modifyTheme", (Object)defaultThemeMap);
    }

    private void validReturn(BeforeItemClickEvent evt, String msg) {
        this.getView().showTipNotification(msg);
        evt.setCancel(true);
    }

    private Boolean isExistedDefault(Long id) {
        Long themeId;
        QFilter[] qFilter = new QFilter[]{new QFilter(KEY_ISDEFAULT_KEY, "=", (Object)Boolean.TRUE)};
        DynamicObject themeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_uitheme", (QFilter[])qFilter);
        if (themeObj != null && !id.equals(themeId = Long.valueOf(themeObj.getLong("id")))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

