/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BaseThemeCusListPlugin
extends AbstractListPlugin {
    private static final String BTN_ENABLE = "tblenable";
    private static final String KEY_MODIFY_KEY = "btnupdate";
    public static final String BOS_BASE_FORMPLUGIN = "bos-portal-plugin";
    private static final String NAME = "name";
    private static final String BAS_UITHEME = "bas_uitheme";
    private static final String ISDEFAULT = "isdefault";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_ENABLE, "btnaddnew", "btn_setdefault"});
        this.addClickListeners(new String[]{"preview", "edit"});
    }

    private void openSettingPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("uitheme_setting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void openEditPage() {
        IFormView pageView;
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u9898\u3002", (String)"BaseThemeCusListPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String pkid = rows.get(0).getPrimaryKeyValue().toString();
        String pageId = this.getPageCache().get(pkid);
        if (pageId != null && (pageView = this.getView().getView(pageId)) != null) {
            pageView.activate();
            this.getView().sendFormAction(pageView);
            return;
        }
        this.showThemeEditForm(false, pkid);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
        this.openEditPage();
    }

    private void showThemeEditForm(boolean isnew, String key) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bas_uitheme_editor");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!isnew && key != null) {
            DynamicObject userThemeInfo = BusinessDataServiceHelper.loadSingle((Object)key, (String)BAS_UITHEME, (String)NAME);
            String name = userThemeInfo.getString(NAME);
            fsp.setCaption(name);
            this.getPageCache().put(key, fsp.getPageId());
            fsp.setCustomParam("pkid", (Object)key);
        }
        this.getView().showForm(fsp);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"disable", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"enable", (CharSequence)formOperate.getOperateKey())) {
            this.switchTheme();
        }
        String itemkey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (itemkey) {
            case "addtheme": {
                this.showThemeEditForm(true, null);
                break;
            }
            case "btnupdate": {
                this.openEditPage();
                break;
            }
            case "setdefault": {
                this.setDefault();
                break;
            }
            case "bar_setting": {
                this.openSettingPage();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection col = ((ListView)this.getView()).getSelectedRows();
        if (StringUtils.equals((CharSequence)KEY_MODIFY_KEY, (CharSequence)key) && col != null && col.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u9898\u3002", (String)"BaseThemeCusListPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (BTN_ENABLE.equals(key) && col != null) {
            col.forEach(a -> {
                DynamicObject dyObj;
                Object status;
                Object pkId = a.getPrimaryKeyValue();
                if (pkId != null && "1394191290278625280".equals(pkId.toString()) && "0".equals(status = (dyObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)BAS_UITHEME)).get("enable"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7d27\u51d1\u4e3b\u9898beta\u4e3a\u7070\u5ea6\u529f\u80fd\uff0c\u8be5\u4e3b\u9898\u4e0b\u53ef\u80fd\u5b58\u5728\u90e8\u5206\u9875\u9762\u4e0d\u9002\u914d\u60c5\u51b5\uff08\u4e0d\u5f71\u54cd\u5176\u4ed6\u4e3b\u9898\u4f7f\u7528\uff09\u3002\u786e\u8ba4\u8981\u542f\u7528\u8be5\u4e3b\u9898\u5417\uff1f", (String)"BaseThemeCusListPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("tblenableCallBack"));
                    evt.setCancel(true);
                }
            });
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("tblenableCallBack".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("enable");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4ec5\u7ba1\u7406\u5458\u53ef\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"BaseThemeCusListPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void switchTheme() {
        long userId = RequestContext.get().getCurrUserId();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map defaultThemeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)userId);
        proxy.addAction("modifyTheme", (Object)defaultThemeMap);
    }

    private void setDefault() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u9898\u3002", (String)"BaseThemeCusListPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String pkId = rows.get(0).getPrimaryKeyValue().toString();
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)BAS_UITHEME);
        boolean enable = dyObj.getBoolean("enable");
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u8bbe\u4e3a\u9ed8\u8ba4\u4e3b\u9898\u3002", (String)"BaseThemeCusListPlugin_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean isDefault = dyObj.getBoolean(ISDEFAULT);
        if (isDefault) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3b\u9898\u5df2\u662f\u9ed8\u8ba4\u4e3b\u9898\u3002", (String)"BaseThemeCusListPlugin_4", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        dyObj.set(ISDEFAULT, (Object)Boolean.TRUE);
        List<DynamicObject> themeObjList = this.getDefaultTheme();
        themeObjList.forEach(dy -> dy.set(ISDEFAULT, (Object)Boolean.FALSE));
        themeObjList.add(dyObj);
        SaveServiceHelper.update((DynamicObject[])themeObjList.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4\u4e3b\u9898\u6210\u529f\u3002", (String)"BaseThemeCusListPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        ListView listView = (ListView)this.getView();
        listView.refresh();
    }

    private List<DynamicObject> getDefaultTheme() {
        QFilter filter = new QFilter(ISDEFAULT, "=", (Object)Boolean.TRUE);
        Map themeObjs = BusinessDataServiceHelper.loadFromCache((String)BAS_UITHEME, (QFilter[])new QFilter[]{filter});
        return new ArrayList<DynamicObject>(themeObjs.values());
    }
}

