/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.svc.control.ThemeOperationBar;

public class BaseThemeEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BaseThemeEditPlugin.class);
    private static final String BAS_UITHEME = "bas_uitheme";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTENT = "content";
    private static final String NUMBER = "number";
    private static final String COLOR = "color";
    private static final String VERSION = "version";
    private static final String VER = "ver";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String THEMEOPERATIONBARAP = "themeoperationbarap";
    private static final String[] FBS_ARR = new String[]{"\"", "'", "&", "<", ">"};

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        String pkid = (String)this.getView().getFormShowParameter().getCustomParam("pkid");
        if (pkid != null) {
            DynamicObject userThemeInfo = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)BAS_UITHEME);
            String id = userThemeInfo.getString(ID);
            Object name = userThemeInfo.get(NAME);
            String content = userThemeInfo.getString(CONTENT);
            result.put(ID, id);
            result.put(NUMBER, userThemeInfo.getString(NUMBER));
            result.put(NAME, name);
            result.put(VER, userThemeInfo.getString(VERSION));
            result.put(COLOR, userThemeInfo.getString(COLOR));
            result.put("isPreset", userThemeInfo.getBoolean("ispreset"));
            try {
                Gson gson = new Gson();
                Map mapContent = (Map)gson.fromJson(content, Map.class);
                result.put(CONTENT, mapContent);
            }
            catch (Exception ex) {
                logger.info("gson parse fromJson error", (Object)ex);
            }
        }
        ThemeOperationBar themeOperationBar = (ThemeOperationBar)this.getControl(THEMEOPERATIONBARAP);
        themeOperationBar.initThemeInfo(result);
    }

    public void customEvent(CustomEventArgs e) {
        List dataList;
        String key = e.getKey();
        String data = e.getEventArgs();
        if ("saveTheme".equals(key)) {
            if (!this.checkSavePermItem()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4e3b\u9898\u5b9a\u5236\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseThemeEditPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.saveTheme(data);
        } else if ("restoreTheme".equals(key) && !CollectionUtils.isEmpty((Collection)(dataList = (List)SerializationUtils.fromJsonString(data, List.class)))) {
            Object id = ((Map)dataList.get(0)).get(ID);
            this.restoreToDefaultTheme(id);
        }
    }

    private boolean checkSavePermItem() {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)BAS_UITHEME, (String)"0=KX5+QVF5+R");
    }

    private void saveTheme(String data) {
        DynamicObject userThemeInfo;
        Map map;
        try {
            map = (Map)SerializationUtils.fromJsonString(data, Map.class);
        }
        catch (Exception e) {
            logger.info("SerializationUtils.fromJsonString error", (Object)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u5185\u5bb9\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseThemeCusFormPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object id = map.get(ID);
        if (id != null) {
            userThemeInfo = BusinessDataServiceHelper.loadSingle(id, (String)BAS_UITHEME);
        } else {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BAS_UITHEME);
            userThemeInfo = new DynamicObject((DynamicObjectType)dt);
        }
        Object number = map.get(NUMBER);
        if (number == null || StringUtils.isEmpty((String)number.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"BaseThemeEditPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String num = number.toString();
        if (num.length() > 30) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e30\u3002", (String)"BaseThemeEditPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.isContainSpecialChar(num)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\u3002", (String)"BaseThemeEditPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String pkid = this.getThemeIdByNum(num);
        if (pkid != null && !pkid.equals(String.valueOf(id))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BaseThemeEditPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object isPreset = map.get("isPreset");
        Object name = map.get(NAME);
        Map lacalName = (Map)name;
        if ((isPreset == null || !"true".equals(isPreset.toString())) && this.isNameEmpty(name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f53\u524d\u8bed\u8a00\u4e3b\u9898\u540d\u79f0\u3002", (String)"BaseThemeEditPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Map.Entry entry : lacalName.entrySet()) {
            String value = (String)entry.getValue();
            if (value.length() > 50) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u3002", (String)"BaseThemeEditPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!this.isContainSpecialChar(value)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\u3002", (String)"BaseThemeEditPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object content = map.get(CONTENT);
        if (content == null || StringUtils.isEmpty((String)content.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseThemeEditPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object color = map.get(COLOR);
        if (color == null || StringUtils.isEmpty((String)color.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u8272\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseThemeEditPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        userThemeInfo.set(NUMBER, number);
        userThemeInfo.set(NAME, name);
        userThemeInfo.set(COLOR, color);
        userThemeInfo.set(VERSION, map.get(VER));
        userThemeInfo.set(CONTENT, (Object)SerializationUtils.toJsonString(content));
        userThemeInfo.set("enable", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userThemeInfo});
        if (id == null) {
            String newId = userThemeInfo.getString(ID);
            ThemeOperationBar themeOperationBar = (ThemeOperationBar)this.getControl(THEMEOPERATIONBARAP);
            themeOperationBar.updateThemeId((Object)newId);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BaseThemeEditPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private boolean isNameEmpty(Object name) {
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            return true;
        }
        if (name instanceof Map) {
            Map langName = (Map)name;
            String localName = (String)langName.get(RequestContext.get().getLang().name());
            return StringUtils.isEmpty((String)localName);
        }
        return false;
    }

    private String getThemeIdByNum(String number) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)BAS_UITHEME, (String)ID, (QFilter[])new QFilter[]{qFilter});
        if (data != null) {
            return data.getString(ID);
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bas_uitheme_preview");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("previewflexpanelap");
        this.getView().showForm(fsp);
    }

    private void restoreToDefaultTheme(Object pkid) {
        if (pkid == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        DynamicObject userThemeInfo = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)BAS_UITHEME);
        String id = userThemeInfo.getString(ID);
        Object name = userThemeInfo.get(NAME);
        String content = userThemeInfo.getString("defaultvalue");
        result.put(ID, id);
        result.put(NUMBER, userThemeInfo.getString(NUMBER));
        result.put(NAME, name);
        result.put(VER, userThemeInfo.getString(VERSION));
        result.put(COLOR, userThemeInfo.getString(COLOR));
        result.put("isPreset", userThemeInfo.getBoolean("ispreset"));
        try {
            Gson gson = new Gson();
            Map mapContent = (Map)gson.fromJson(content, Map.class);
            result.put(CONTENT, mapContent);
        }
        catch (Exception ex) {
            logger.info("gson parse fromJson error", (Object)ex);
        }
        userThemeInfo.set(CONTENT, (Object)content);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userThemeInfo});
        ThemeOperationBar themeOperationBar = (ThemeOperationBar)this.getControl(THEMEOPERATIONBARAP);
        themeOperationBar.restoreToDefaultTheme(result);
    }

    private boolean isContainSpecialChar(String cardTitleLocaleStr) {
        for (String key : FBS_ARR) {
            if (!cardTitleLocaleStr.contains(key)) continue;
            return true;
        }
        return false;
    }
}

