/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ThemeCustomSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String KEY_HIDE_JSON_KEY = "content";
    private static final String KEY_COLOR_KEY = "color";
    private static final String KEY_JSON_KEY = "jsonedit";
    private static final String KEY_MAINBAR = "toolbarap";
    private static final String BTN_SAVE = "bar_save";
    private static final String KEY_ISDEFAULT_KEY = "isdefault";
    private static final String KEY_ENABLE_KEY = "enable";
    private static final String TBL_NAME = "T_BAS_UITheme";
    private static final String KEY_NUMBER_KEY = "number";
    private static final String KEY_THEME_TYPE = "ispreset";
    private static final Log logger = LogFactory.getLog(ThemeCustomSavePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"portal_theme_save_lock");
            lock.lock();
            if (e.getDataEntities() != null && e.getDataEntities().length > 0) {
                DynamicObject entity = e.getDataEntities()[0];
                Object json = entity.get(KEY_HIDE_JSON_KEY);
                boolean type = Boolean.parseBoolean(entity.get(KEY_THEME_TYPE).toString());
                Object isDefault = entity.get(KEY_ISDEFAULT_KEY);
                Object number = entity.get(KEY_NUMBER_KEY);
                if (StringUtils.isNotBlank((Object)isDefault) && Boolean.parseBoolean(isDefault.toString())) {
                    this.updateIsNoDefault(number);
                }
            }
        }
        catch (Exception exception) {
            logger.info("\u4e3b\u9898\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25:", (Object)exception);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void updateIsNoDefault(Object number) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("FNUMBER", 1, number));
        String strSQL = "update T_BAS_UITheme set FISDEFAULT = 0 where FNUMBER !=?";
        DB.update((DBRoute)DBRoute.base, (String)strSQL, (Object[])params.toArray(new SqlParameter[params.size()]));
    }
}

