/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data.collect.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.collect.model.DataCollectSave;
import kd.bos.data.collect.service.DataCollectionDBService;
import kd.bos.data.collect.service.ListUtils;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionQuery;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class DATACService {
    private static Log logger = LogFactory.getLog(DATACService.class);
    private static final Timer messageScan = new Timer("datacollect-messageScanTask");
    private static AtomicBoolean isStarted = new AtomicBoolean();

    public static void start() {
        final Elector elector = ElectFactory.getElector((String)"datacollect-message");
        elector.registerListener(new ElectorListener(){

            public void notifyMaster() {
                if (elector.isMaster() && isStarted.compareAndSet(false, true)) {
                    messageScan.scheduleAtFixedRate((TimerTask)new ScanDataCollectTask(), 1000L, 120000L);
                }
            }

            public void notifyLostMaster() {
                if (isStarted.compareAndSet(true, false)) {
                    messageScan.cancel();
                }
            }
        });
        elector.start();
    }

    public static class ScanDataCollectTask
    extends TimerTask {
        @Override
        public void run() {
            ThreadPools.executeOnce((String)"datacollect_message_scan", () -> {
                List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
                accounts.forEach(account -> {
                    List sessionList = SessionQuery.getWebUserSessions((String)account.getAccountId());
                    if (sessionList == null || sessionList.size() <= 0) {
                        return;
                    }
                    RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
                    try (AutoCloseable ignored = rc.setupThreadRequestContext();){
                        ArrayList messageList = new ArrayList(10);
                        DataCollectionDBService.removeAllExpiredData(account);
                        int batchSize = 2000;
                        List<DataCollectSave> dataList = DataCollectionDBService.getAllUnsentDataByBatch(account, batchSize);
                        if (dataList == null || dataList.size() == 0) {
                            this.sendOldMessage((Account)account, sessionList, batchSize);
                            return;
                        }
                        if (dataList == null || dataList.size() == 0) {
                            return;
                        }
                        Map<String, List<DataCollectSave>> map = dataList.stream().collect(Collectors.groupingBy(DataCollectSave::getProjectId));
                        for (Map.Entry<String, List<DataCollectSave>> entry : map.entrySet()) {
                            this.prepareAndSend((Account)account, sessionList, entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        ExceptionLogger.log((String)"data error", (Throwable)e);
                    }
                });
            });
        }

        private void sendOldMessage(Account account, List<SessionInfo> sessionList, int batchSize) {
            List<DataCollectSave> oldDataList = DataCollectionDBService.getAllSentDataByBatch(account, batchSize);
            Map<Long, List<DataCollectSave>> map = oldDataList.stream().collect(Collectors.groupingBy(DataCollectSave::getGroupId));
            int i = 1;
            for (Map.Entry<Long, List<DataCollectSave>> entry : map.entrySet()) {
                if (i >= sessionList.size()) {
                    i = 1;
                }
                this.sendMessage(account, entry.getValue(), sessionList.get(i - 1), entry.getKey());
                ++i;
            }
        }

        private void prepareAndSend(Account account, List<SessionInfo> sessionList, List<DataCollectSave> dataList) {
            int i = 1;
            boolean isOk = true;
            int batchSize = 20;
            while (isOk) {
                List<DataCollectSave> needList = null;
                if (i * batchSize < dataList.size()) {
                    needList = ListUtils.copyList(dataList, (i - 1) * batchSize, batchSize);
                } else {
                    needList = ListUtils.copyList(dataList, (i - 1) * batchSize, dataList.size() - (i - 1) * batchSize);
                    isOk = false;
                }
                if (i >= sessionList.size()) {
                    i = 1;
                }
                this.sendMessage(account, needList, sessionList.get(i - 1), null);
                ++i;
            }
        }

        private void sendMessage(Account account, List<DataCollectSave> needList, SessionInfo session, Long oldGroupId) {
            if (CollectionUtils.isEmpty(needList) || session == null) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(needList.size());
            HashMap<String, Object> parentMap = new HashMap<String, Object>();
            Long groupId = IDService.get().genLongId();
            if (oldGroupId != null) {
                groupId = oldGroupId;
            }
            ArrayList dataList = new ArrayList(needList.size());
            String storeId = null;
            String projectId = null;
            for (DataCollectSave dataCollect : needList) {
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put("uid", dataCollect.getUserId());
                config.put("event_id", dataCollect.getEventId());
                config.put("dc_id", RequestContext.get().getAccountId());
                config.put("tenant_id", RequestContext.get().getTenantId());
                config.put("tenant_code", RequestContext.get().getTenantId());
                config.put("app_id", dataCollect.getAppId());
                config.put("form_id", dataCollect.getFormId());
                config.put("bill_form_id", dataCollect.getBillformId());
                config.put("event_name", dataCollect.getEventName());
                config.put("var", dataCollect.getCusData());
                config.put("time", dataCollect.getCreatTime().getTime());
                config.put("instance_number", dataCollect.getInstanceNum());
                if (StringUtils.isEmpty(projectId)) {
                    projectId = dataCollect.getProjectId();
                    storeId = dataCollect.getStoreId();
                }
                dataList.add(config);
                ids.add(dataCollect.getId());
            }
            parentMap.put("project", projectId);
            parentMap.put("store", storeId);
            parentMap.put("groupid", groupId);
            parentMap.put("data", dataList);
            String msg = MsgSessionUtil.buildWebSocketAction((String)"sendKDBussinessData", parentMap);
            PushMessage pushMessage = new PushMessage(PushMessageRange.Session, session.getGloableSessionId(), (Object)msg);
            PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
            DataCollectionDBService.handleGroupData(account, ids, groupId);
        }
    }
}

