/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data.collect.service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.collect.model.DataCollectSave;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.service.DBUtils;

public class DataCollectionDBService {
    private static Log log = LogFactory.getLog(DataCollectionDBService.class);

    public static boolean saveData(DataCollectSave dataCollect) {
        boolean isSucceed = true;
        if (dataCollect != null) {
            String sql = "insert into t_bas_data_collect_temp( " + DataCollectionDBService.getQueryColumnString() + " ) values (" + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            Object[] params = new Object[17];
            int i = 0;
            Long idValue = dataCollect.getId() == null ? Long.valueOf(ID.genLongId()) : dataCollect.getId();
            params[i++] = idValue;
            params[i++] = dataCollect.getAccountId();
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getAppId());
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getBillformId());
            params[i++] = dataCollect.getCreatTime();
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getClientIp());
            params[i++] = DBUtils.getNonNullString((String)SerializationUtils.toJsonString(dataCollect.getCusData()));
            params[i++] = DBUtils.getNonNullString((String)String.valueOf(idValue));
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getEventName());
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getFormId());
            params[i++] = dataCollect.getGroupId() == null ? Long.valueOf(0L) : dataCollect.getGroupId();
            params[i++] = DBUtils.getNonNullString((String)(kd.bos.util.StringUtils.isEmpty((String)dataCollect.getInstanceNum()) ? DataCollectionDBService.getInstanceCode() : dataCollect.getInstanceNum()));
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getProjectId());
            params[i++] = dataCollect.getSendTime();
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getStoreId());
            params[i++] = DBUtils.getNonNullString((String)dataCollect.getTenantId());
            params[i++] = dataCollect.getUserId();
            Account account = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
            isSucceed = DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        return isSucceed;
    }

    private static String getInstanceCode() {
        String instanceCode = "";
        Map map = LicenseServiceHelper.getProductInfo();
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)instanceCode)) continue;
                instanceCode = (String)entry.getValue();
                break;
            }
        }
        return instanceCode;
    }

    public static List<DataCollectSave> getAllUnsentDataByBatch(Account account, int batchSize) {
        String columns = DataCollectionDBService.getQueryColumnString();
        StringBuilder sql = new StringBuilder("select ").append("top ").append(batchSize).append(" ").append(columns).append(" from t_bas_data_collect_temp where ").append(DBUtils.getColumn((String)"GROUPID")).append(" = 0");
        return DataCollectionDBService.getAllDataByBatchBySQl(account, batchSize, sql);
    }

    public static List<DataCollectSave> getAllSentDataByBatch(Account account, int batchSize) {
        String columns = DataCollectionDBService.getQueryColumnString();
        StringBuilder sql = new StringBuilder("select ").append("top ").append(batchSize).append(" ").append(columns).append(" from t_bas_data_collect_temp where ").append(DBUtils.getColumn((String)"GROUPID")).append(" != 0");
        return DataCollectionDBService.getAllDataByBatchBySQl(account, batchSize, sql);
    }

    private static List<DataCollectSave> getAllDataByBatchBySQl(Account account, int batchSize, StringBuilder sql) {
        ArrayList dataList = new ArrayList();
        ResultSetHandler rsh = rs -> {
            while (rs.next()) {
                DataCollectSave dataCollect = new DataCollectSave();
                dataCollect.setId(rs.getLong(DBUtils.getColumn((String)"id")));
                dataCollect.setAccountId(rs.getLong(DBUtils.getColumn((String)"accountid")));
                dataCollect.setAppId(rs.getString(DBUtils.getColumn((String)"appid")));
                dataCollect.setBillformId(rs.getString(DBUtils.getColumn((String)"BILLFORMID")));
                dataCollect.setCreatTime(rs.getDate(DBUtils.getColumn((String)"createtime")));
                dataCollect.setClientIp(rs.getString(DBUtils.getColumn((String)"clientip")));
                dataCollect.setCusData((Map)SerializationUtils.fromJsonString(rs.getString(DBUtils.getColumn((String)"DATA")), HashMap.class));
                dataCollect.setEventId(rs.getString(DBUtils.getColumn((String)"EVENTID")));
                dataCollect.setEventName(rs.getString(DBUtils.getColumn((String)"EVENTNAME")));
                dataCollect.setFormId(rs.getString(DBUtils.getColumn((String)"formid")));
                dataCollect.setGroupId(rs.getLong(DBUtils.getColumn((String)"GROUPID")));
                dataCollect.setInstanceNum(rs.getString(DBUtils.getColumn((String)"INSTANCENUM")));
                dataCollect.setProjectId(rs.getString(DBUtils.getColumn((String)"PROJECTID")));
                dataCollect.setSendTime(rs.getDate(DBUtils.getColumn((String)"SENDTIME")));
                dataCollect.setStoreId(rs.getString(DBUtils.getColumn((String)"STOREID")));
                dataCollect.setTenantId(rs.getString(DBUtils.getColumn((String)"tenantid")));
                dataCollect.setUserId(rs.getLong(DBUtils.getColumn((String)"userid")));
                dataList.add(dataCollect);
            }
            return dataList;
        };
        List list = null;
        try {
            Object[] params = new Object[]{};
            list = (List)DBUtils.query((Account)account, (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)rsh);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static boolean removeByProjectId(Account account, Long groupId) {
        boolean isSucceed = true;
        if (groupId != null) {
            String sql = "delete from t_bas_data_collect_temp where " + DBUtils.getColumn((String)"GROUPID") + " = ?";
            Object[] params = new Object[]{groupId};
            isSucceed = DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        return isSucceed;
    }

    public static boolean removeAllExpiredData(Account account) {
        boolean isSucceed = true;
        LocalDateTime nowTime = LocalDateTime.now();
        int currentTime = DataCollectionDBService.getCurrentTimeNumber(nowTime);
        if (currentTime > 100 && currentTime < 120) {
            String sql = "delete from t_bas_data_collect_temp where " + DBUtils.getColumn((String)"createtime") + " < ?";
            Object[] params = new Object[]{nowTime.minusDays(3L)};
            isSucceed = DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        return isSucceed;
    }

    private static int getCurrentTimeNumber(LocalDateTime nowTime) {
        int hours = nowTime.getHour();
        int minutes = nowTime.getMinute();
        return hours * 100 + minutes;
    }

    public static boolean handleGroupData(Account account, List<Long> ids, Long groupId) {
        boolean isSucceed = true;
        if (groupId != null && ids != null && ids.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("update   t_bas_data_collect_temp  set ").append(DBUtils.getColumn((String)"GROUPID")).append("=? ").append(" where ").append(DBUtils.getColumn((String)"id")).append(" in ");
            builder.append("(");
            for (int i = 0; i < ids.size(); ++i) {
                if (i == 0) {
                    builder.append(ids.get(i));
                    continue;
                }
                builder.append(",").append(ids.get(i));
            }
            builder.append(")");
            String sql = builder.toString();
            Object[] params = new Object[]{groupId};
            isSucceed = DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        return isSucceed;
    }

    private static String getQueryColumnString() {
        StringBuilder colums = new StringBuilder();
        colums.append(DBUtils.getColumn((String)"id"));
        colums.append(",").append(DBUtils.getColumn((String)"accountid"));
        colums.append(",").append(DBUtils.getColumn((String)"appid"));
        colums.append(",").append(DBUtils.getColumn((String)"BILLFORMID"));
        colums.append(",").append(DBUtils.getColumn((String)"createtime"));
        colums.append(",").append(DBUtils.getColumn((String)"clientip"));
        colums.append(",").append(DBUtils.getColumn((String)"DATA"));
        colums.append(",").append(DBUtils.getColumn((String)"EVENTID"));
        colums.append(",").append(DBUtils.getColumn((String)"EVENTNAME"));
        colums.append(",").append(DBUtils.getColumn((String)"formid"));
        colums.append(",").append(DBUtils.getColumn((String)"GROUPID"));
        colums.append(",").append(DBUtils.getColumn((String)"INSTANCENUM"));
        colums.append(",").append(DBUtils.getColumn((String)"PROJECTID"));
        colums.append(",").append(DBUtils.getColumn((String)"SENDTIME"));
        colums.append(",").append(DBUtils.getColumn((String)"STOREID"));
        colums.append(",").append(DBUtils.getColumn((String)"tenantid"));
        colums.append(",").append(DBUtils.getColumn((String)"userid"));
        return colums.toString();
    }
}

